/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.part;

import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphDiagramEditorPlugin;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphDiagramEditorUtil;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphVisualIDRegistry;
import org.eclipse.gmf.graphdef.editor.part.Messages;
import org.eclipse.gmf.graphdef.editor.part.ModelElementSelectionPage;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class GMFGraphNewDiagramFileWizard
extends Wizard {
    private WizardNewFileCreationPage myFileCreationPage;
    private ModelElementSelectionPage diagramRootElementSelectionPage;
    private TransactionalEditingDomain myEditingDomain;

    public GMFGraphNewDiagramFileWizard(URI domainModelURI, EObject diagramRoot, TransactionalEditingDomain editingDomain) {
        Path filePath;
        assert (domainModelURI != null) : "Domain model uri must be specified";
        assert (diagramRoot != null) : "Doagram root element must be specified";
        assert (editingDomain != null) : "Editing domain must be specified";
        this.myFileCreationPage = new WizardNewFileCreationPage(Messages.GMFGraphNewDiagramFileWizard_CreationPageName, (IStructuredSelection)StructuredSelection.EMPTY);
        this.myFileCreationPage.setTitle(Messages.GMFGraphNewDiagramFileWizard_CreationPageTitle);
        this.myFileCreationPage.setDescription(NLS.bind((String)Messages.GMFGraphNewDiagramFileWizard_CreationPageDescription, (Object)"GMFGraph"));
        String fileName = domainModelURI.trimFileExtension().lastSegment();
        if (domainModelURI.isPlatformResource()) {
            filePath = new Path(domainModelURI.trimSegments(1).toPlatformString(true));
        } else if (domainModelURI.isFile()) {
            filePath = new Path(domainModelURI.trimSegments(1).toFileString());
        } else {
            throw new IllegalArgumentException("Unsupported URI: " + domainModelURI);
        }
        this.myFileCreationPage.setContainerFullPath((IPath)filePath);
        this.myFileCreationPage.setFileName(GMFGraphDiagramEditorUtil.getUniqueFileName((IPath)filePath, fileName, "gmfgraph_diagram"));
        this.diagramRootElementSelectionPage = new DiagramRootElementSelectionPage(Messages.GMFGraphNewDiagramFileWizard_RootSelectionPageName);
        this.diagramRootElementSelectionPage.setTitle(Messages.GMFGraphNewDiagramFileWizard_RootSelectionPageTitle);
        this.diagramRootElementSelectionPage.setDescription(Messages.GMFGraphNewDiagramFileWizard_RootSelectionPageDescription);
        this.diagramRootElementSelectionPage.setModelElement(diagramRoot);
        this.myEditingDomain = editingDomain;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.myFileCreationPage);
        this.addPage((IWizardPage)this.diagramRootElementSelectionPage);
    }

    public boolean performFinish() {
        LinkedList<IFile> affectedFiles = new LinkedList<IFile>();
        IFile diagramFile = this.myFileCreationPage.createNewFile();
        GMFGraphDiagramEditorUtil.setCharset(diagramFile);
        affectedFiles.add(diagramFile);
        URI diagramModelURI = URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString(), (boolean)true);
        ResourceSet resourceSet = this.myEditingDomain.getResourceSet();
        final Resource diagramResource = resourceSet.createResource(diagramModelURI);
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(this.myEditingDomain, Messages.GMFGraphNewDiagramFileWizard_InitDiagramCommand, affectedFiles){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                int diagramVID = GMFGraphVisualIDRegistry.getDiagramVisualID(GMFGraphNewDiagramFileWizard.this.diagramRootElementSelectionPage.getModelElement());
                if (diagramVID != 1000) {
                    return CommandResult.newErrorCommandResult((String)Messages.GMFGraphNewDiagramFileWizard_IncorrectRootError);
                }
                Diagram diagram = ViewService.createDiagram((EObject)GMFGraphNewDiagramFileWizard.this.diagramRootElementSelectionPage.getModelElement(), (String)"GMFGraph", (PreferencesHint)GMFGraphDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                diagramResource.getContents().add((Object)diagram);
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
            diagramResource.save(GMFGraphDiagramEditorUtil.getSaveOptions());
            GMFGraphDiagramEditorUtil.openDiagram(diagramResource);
        }
        catch (ExecutionException e) {
            GMFGraphDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", e);
        }
        catch (IOException ex) {
            GMFGraphDiagramEditorPlugin.getInstance().logError("Save operation failed for: " + diagramModelURI, ex);
        }
        catch (PartInitException ex) {
            GMFGraphDiagramEditorPlugin.getInstance().logError("Unable to open editor", ex);
        }
        return true;
    }

    private static class DiagramRootElementSelectionPage
    extends ModelElementSelectionPage {
        protected DiagramRootElementSelectionPage(String pageName) {
            super(pageName);
        }

        protected String getSelectionTitle() {
            return Messages.GMFGraphNewDiagramFileWizard_RootSelectionPageSelectionTitle;
        }

        protected boolean validatePage() {
            if (this.selectedModelElement == null) {
                this.setErrorMessage(Messages.GMFGraphNewDiagramFileWizard_RootSelectionPageNoSelectionMessage);
                return false;
            }
            boolean result = ViewService.getInstance().provides((IOperation)new CreateDiagramViewOperation((IAdaptable)new EObjectAdapter(this.selectedModelElement), "GMFGraph", GMFGraphDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT));
            this.setErrorMessage(result ? null : Messages.GMFGraphNewDiagramFileWizard_RootSelectionPageInvalidSelectionMessage);
            return result;
        }
    }
}

