/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression;

import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;

public class AnalysationIssue {
    private final Type type;
    private final String message;
    private final SyntaxElement element;
    private final boolean isWarningNotError;

    public AnalysationIssue(Type type, String message, SyntaxElement element) {
        this(type, message, element, false);
    }

    public AnalysationIssue(Type type, String message, SyntaxElement element, boolean isWarningNotError) {
        this.type = type;
        this.message = message;
        this.element = element;
        this.isWarningNotError = isWarningNotError;
    }

    public boolean isWarningNotError() {
        return this.isWarningNotError;
    }

    public SyntaxElement getElement() {
        return this.element;
    }

    public String getMessage() {
        return this.message;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "[" + this.type.name + "] - " + this.message + " : " + this.element;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INCOMPATIBLE_TYPES("Incompatible types"),
        UNNECESSARY_CAST("Unnecessary cast"),
        FEATURE_NOT_FOUND("Callable not found"),
        TYPE_NOT_FOUND("Type not found"),
        INTERNAL_ERROR("Internal error"),
        JAVA_TYPE_NOT_FOUND("Java Type not found"),
        SYNTAX_ERROR("Syntax error"),
        DEFINITION_NOT_FOUND("Definition not found");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

