/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.migrate;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.gmf.internal.common.migrate.MigrationHelperDelegate;

public class MigrationHelper
extends XMIHelperImpl {
    private final MigrationHelperDelegate myDelegate;
    private boolean myIsDelegateDisabled = true;
    private Map<EStructuralFeature, EStructuralFeature> myNarrowedFeatureTypes;

    public MigrationHelper(XMLResource resource, MigrationHelperDelegate delegate) {
        super(resource);
        assert (delegate != null);
        this.myDelegate = delegate;
    }

    void enableDelegate(boolean enabled) {
        this.myIsDelegateDisabled = !enabled;
    }

    public EObject createObject(EFactory factory, EClassifier type) {
        if (this.myIsDelegateDisabled) {
            return super.createObject(factory, type);
        }
        EObject result = this.myDelegate.createObject(factory, type);
        if (result == null) {
            result = super.createObject(factory, type);
        }
        this.myDelegate.processObject(result);
        return result;
    }

    public void setValue(EObject object, EStructuralFeature feature, Object value, int position) {
        if (this.myIsDelegateDisabled) {
            super.setValue(object, feature, value, position);
            return;
        }
        EStructuralFeature originalFeature = this.getOriginalFeature(feature);
        if (originalFeature != null) {
            feature = originalFeature;
        }
        if (!this.myDelegate.setValue(object, feature, value, position)) {
            super.setValue(object, feature, value, position);
        }
    }

    public EStructuralFeature getFeature(EClass eClass, String namespaceURI, String name, boolean isElement) {
        EClass narrow;
        if (this.myIsDelegateDisabled) {
            return super.getFeature(eClass, namespaceURI, name, isElement);
        }
        EStructuralFeature result = this.myDelegate.getFeature(eClass, namespaceURI, name, isElement);
        if (result == null) {
            result = super.getFeature(eClass, namespaceURI, name, isElement);
        }
        if ((narrow = this.myDelegate.getStructuralFeatureType(result)) != null) {
            EStructuralFeature fake = this.addNarrowedFeature(result);
            fake.setEType((EClassifier)narrow);
            return fake;
        }
        return result;
    }

    public EClassifier getType(EFactory factory, String typeName) {
        if (this.myIsDelegateDisabled) {
            return super.getType(factory, typeName);
        }
        EClassifier result = this.myDelegate.getType(factory, typeName);
        if (result == null) {
            result = super.getType(factory, typeName);
        }
        return result;
    }

    public void popContext() {
        super.popContext();
        if (this.myIsDelegateDisabled) {
            return;
        }
        this.myDelegate.postProcess();
    }

    protected EStructuralFeature getOriginalFeature(EStructuralFeature feature) {
        if (this.myNarrowedFeatureTypes == null) {
            this.myNarrowedFeatureTypes = new HashMap<EStructuralFeature, EStructuralFeature>();
        }
        return this.myNarrowedFeatureTypes.get(feature);
    }

    protected EStructuralFeature addNarrowedFeature(EStructuralFeature originalFeature) {
        if (this.myNarrowedFeatureTypes == null) {
            this.myNarrowedFeatureTypes = new HashMap<EStructuralFeature, EStructuralFeature>();
        }
        EStructuralFeature result = (EStructuralFeature)EcoreUtil.copy((EObject)originalFeature);
        this.myNarrowedFeatureTypes.put(result, originalFeature);
        return result;
    }
}

