/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.util;

import org.eclipse.gmf.runtime.common.ui.util.IInlineTextActionHandler;
import org.eclipse.swt.widgets.Text;

public abstract class BaseInlineTextActionHandler
implements IInlineTextActionHandler {
    protected static final String EMPTY_STRING = "";
    private boolean hooked;
    private Text text;

    BaseInlineTextActionHandler(Text text) {
        this.setText(text);
    }

    private void setText(Text text) {
        this.text = text;
    }

    protected Text getText() {
        return this.text;
    }

    public void dispose() {
        if (this.isHooked()) {
            this.unHookHandlers();
        }
        this.setText(null);
    }

    protected boolean isHooked() {
        return this.hooked;
    }

    protected void setHooked(boolean hooked) {
        this.hooked = hooked;
    }

    protected void handleCut() {
        this.getText().cut();
    }

    protected void handleCopy() {
        this.getText().copy();
    }

    protected void handlePaste() {
        this.getText().paste();
    }

    protected void handleSelectAll() {
        this.getText().selectAll();
    }

    protected void handleDelete() {
        if (this.getText().getSelectionCount() > 0) {
            this.getText().insert(EMPTY_STRING);
        } else {
            int pos = this.getText().getCaretPosition();
            if (pos < this.getText().getCharCount()) {
                this.getText().setSelection(pos, pos + 1);
                this.getText().insert(EMPTY_STRING);
            }
        }
    }
}

