/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.properties;

import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.ui.services.properties.ICompositePropertySource;
import org.eclipse.gmf.runtime.common.ui.services.properties.IPropertiesProvider;
import org.eclipse.gmf.runtime.common.ui.services.properties.PropertiesService;

public class GetPropertySourceOperation
implements IOperation {
    private Object object;
    private ICompositePropertySource propertySource;

    public GetPropertySourceOperation(Object object) {
        this.object = object;
    }

    public Object execute(IProvider provider) {
        assert (provider != null) : "provider cannot be null";
        if (provider instanceof IPropertiesProvider) {
            IPropertiesProvider propertieProvider = (IPropertiesProvider)provider;
            ICompositePropertySource result = propertieProvider.getPropertySource(this.object);
            if (result != null) {
                PropertiesService.getInstance().applyModifiers(propertieProvider, result);
            }
            if (this.propertySource == null) {
                this.propertySource = result;
                return this.propertySource;
            }
            if (result != null) {
                this.propertySource.addPropertySource(result);
            }
        }
        return this.propertySource;
    }

    public ICompositePropertySource getPropertySource() {
        return this.propertySource;
    }

    public Object getObject() {
        return this.object;
    }
}

