/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gmf.runtime.common.ui.services.marker.MarkerNavigationService;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.internal.l10n.EditorMessages;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;

public class IDEDiagramDocumentEditor
extends DiagramDocumentEditor
implements IGotoMarker {
    public IDEDiagramDocumentEditor(boolean hasFlyoutPalette) {
        super(hasFlyoutPalette);
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        boolean success;
        block19: {
            IFile original;
            Shell shell = this.getSite().getShell();
            IEditorInput input = this.getEditorInput();
            SaveAsDialog dialog = new SaveAsDialog(shell);
            IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
            if (original != null) {
                dialog.setOriginalFile(original);
            }
            dialog.create();
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider == null) {
                return;
            }
            if (provider.isDeleted((Object)input) && original != null) {
                String message = NLS.bind((String)org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.l10n.EditorMessages.Editor_warning_save_delete, (Object)original.getName());
                dialog.setErrorMessage(null);
                dialog.setMessage(message, 2);
            }
            if (dialog.open() == 1) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IPath filePath = dialog.getResult();
            if (filePath == null) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = workspaceRoot.getFile(filePath);
            FileEditorInput newInput = new FileEditorInput(file);
            IEditorMatchingStrategy matchingStrategy = this.getEditorDescriptor().getEditorMatchingStrategy();
            IEditorReference[] editorRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int i = 0;
            while (i < editorRefs.length) {
                if (matchingStrategy.matches(editorRefs[i], (IEditorInput)newInput)) {
                    MessageDialog.openWarning((Shell)shell, (String)EditorMessages.FileSaveAs_DialogTitle, (String)EditorMessages.FileSaveAs_DialogMessageText);
                    return;
                }
                ++i;
            }
            success = false;
            try {
                try {
                    provider.aboutToChange((Object)newInput);
                    this.getDocumentProvider((IEditorInput)newInput).saveDocument(progressMonitor, (Object)newInput, this.getDocumentProvider().getDocument((Object)this.getEditorInput()), true);
                    success = true;
                }
                catch (CoreException x) {
                    IStatus status = x.getStatus();
                    if (status == null || status.getSeverity() != 8) {
                        ErrorDialog.openError((Shell)shell, (String)org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.l10n.EditorMessages.Editor_error_saving_title2, (String)org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.l10n.EditorMessages.Editor_error_saving_message2, (IStatus)x.getStatus());
                    }
                    provider.changed((Object)newInput);
                    if (success) {
                        this.setInput((IEditorInput)newInput);
                        this.getGraphicalViewer().deselectAll();
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                provider.changed((Object)newInput);
                if (success) {
                    this.setInput((IEditorInput)newInput);
                    this.getGraphicalViewer().deselectAll();
                }
                throw throwable;
            }
            provider.changed((Object)newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
                this.getGraphicalViewer().deselectAll();
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    public final void gotoMarker(IMarker marker) {
        MarkerNavigationService.getInstance().gotoMarker((IEditorPart)this, marker);
    }
}

