/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.LogicColorConstants;

public class LogicFlowBorder
extends LineBorder {
    private int grabBarWidth;
    private Dimension grabBarSize;

    public LogicFlowBorder() {
    }

    public LogicFlowBorder(Dimension size) {
        this.setGrabBarWidth(size.width);
        this.grabBarSize = new Dimension(size);
    }

    public Insets getInsets(IFigure figure) {
        return new Insets(this.getWidth() + 2, this.grabBarWidth + 2, this.getWidth() + 2, this.getWidth() + 2);
    }

    public Dimension getPreferredSize() {
        return this.grabBarSize;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        Rectangle bounds = figure.getBounds();
        tempRect.setBounds(new Rectangle(bounds.x, bounds.y, this.grabBarWidth, bounds.height));
        graphics.setBackgroundColor(LogicColorConstants.logicGreen);
        graphics.fillRectangle(tempRect);
        super.paint(figure, graphics, insets);
    }

    public void setGrabBarWidth(int width) {
        this.grabBarWidth = width;
    }
}

