/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ui.services;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.search.core.services.AbstractExtensionManager;
import org.eclipse.emf.search.ui.Activator;
import org.eclipse.emf.search.ui.l10n.Messages;
import org.eclipse.emf.search.ui.services.OpenDiagramParticipantDescriptor;

public final class OpenDiagramParticipantExtensionManager
extends AbstractExtensionManager {
    private static final String bundleId = Activator.getDefault().getBundle().getSymbolicName();
    public static final String OPEN_DIAGRAM_PARTICIPANT_EXT_POINT_ID = String.valueOf(bundleId) + ".openDiagramParticipants";
    private static OpenDiagramParticipantExtensionManager manager;
    private SortedSet<OpenDiagramParticipantDescriptor> participantContributions = new TreeSet<OpenDiagramParticipantDescriptor>(new Comparator<OpenDiagramParticipantDescriptor>(){

        @Override
        public int compare(OpenDiagramParticipantDescriptor o1, OpenDiagramParticipantDescriptor o2) {
            return o1.getID().compareTo(o2.getID());
        }
    });

    protected OpenDiagramParticipantExtensionManager() {
        super(OPEN_DIAGRAM_PARTICIPANT_EXT_POINT_ID);
        this.readRegistry();
    }

    public static OpenDiagramParticipantExtensionManager getInstance() {
        return manager == null ? (manager = new OpenDiagramParticipantExtensionManager()) : manager;
    }

    public OpenDiagramParticipantDescriptor find(String id) {
        for (OpenDiagramParticipantDescriptor desc : this.participantContributions) {
            if (!id.equals(desc.getID())) continue;
            return desc;
        }
        return null;
    }

    public OpenDiagramParticipantDescriptor[] getModelSearchParticipantDescriptors() {
        return this.participantContributions.toArray(new OpenDiagramParticipantDescriptor[this.participantContributions.size()]);
    }

    protected void addExtension(IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement confElt = iConfigurationElementArray[n2];
            try {
                this.participantContributions.add(new OpenDiagramParticipantDescriptor(confElt));
            }
            catch (CoreException ce) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, bundleId, 0, Messages.getString("ModelExtensibleSearchParticipantTabExtensionManager.1"), (Throwable)ce));
            }
            ++n2;
        }
    }

    protected void removeExtension(IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement confElt = iConfigurationElementArray[n2];
            String id = confElt.getAttribute("id");
            OpenDiagramParticipantDescriptor descriptor = this.find(id);
            this.participantContributions.remove(descriptor);
            ++n2;
        }
    }
}

