/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ui.internal.replace.provisional;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.search.ui.internal.replace.provisional.ModelSearchWizardDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.ui.refactoring.ExceptionHandler;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.WorkbenchRunnableAdapter;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class TextualModelSearchRefactoringOperation {
    private RefactoringWizard fWizard;
    private RefactoringStatus fInitialConditions;
    public static final int INITIAL_CONDITION_CHECKING_FAILED = 1025;

    public TextualModelSearchRefactoringOperation(RefactoringWizard wizard) {
        Assert.isNotNull((Object)wizard);
        this.fWizard = wizard;
    }

    public RefactoringStatus getInitialConditionCheckingStatus() {
        return this.fInitialConditions;
    }

    public int run(final Shell parent, final String dialogTitle) throws InterruptedException {
        Assert.isNotNull((Object)dialogTitle);
        final Refactoring refactoring = this.fWizard.getRefactoring();
        final IJobManager manager = Job.getJobManager();
        final int[] result = new int[1];
        final InterruptedException[] canceled = new InterruptedException[1];
        Runnable r = new Runnable(){

            public void run() {
                try {
                    try {
                        manager.beginRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), null);
                        refactoring.setValidationContext((Object)parent);
                        TextualModelSearchRefactoringOperation.this.fInitialConditions = TextualModelSearchRefactoringOperation.this.checkInitialConditions(refactoring, parent, dialogTitle);
                        if (TextualModelSearchRefactoringOperation.this.fInitialConditions.hasFatalError()) {
                            String message = TextualModelSearchRefactoringOperation.this.fInitialConditions.getMessageMatchingSeverity(4);
                            MessageDialog.openInformation((Shell)parent, (String)dialogTitle, (String)message);
                            result[0] = 1025;
                        } else {
                            TextualModelSearchRefactoringOperation.this.fWizard.setInitialConditionCheckingStatus(TextualModelSearchRefactoringOperation.this.fInitialConditions);
                            ModelSearchWizardDialog dialog = new ModelSearchWizardDialog(parent, (IWizard)TextualModelSearchRefactoringOperation.this.fWizard);
                            dialog.create();
                            IWizardContainer wizardContainer = (IWizardContainer)dialog;
                            result[0] = wizardContainer.getCurrentPage() == null ? 1 : dialog.open();
                        }
                    }
                    catch (InterruptedException e) {
                        canceled[0] = e;
                        manager.endRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                        refactoring.setValidationContext(null);
                    }
                    catch (OperationCanceledException e) {
                        canceled[0] = new InterruptedException(e.getMessage());
                        manager.endRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                        refactoring.setValidationContext(null);
                    }
                }
                finally {
                    manager.endRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                    refactoring.setValidationContext(null);
                }
            }
        };
        BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)r);
        if (canceled[0] != null) {
            throw canceled[0];
        }
        return result[0];
    }

    private RefactoringStatus checkInitialConditions(Refactoring refactoring, Shell parent, String title) throws InterruptedException {
        try {
            CheckConditionsOperation cco = new CheckConditionsOperation(refactoring, 2);
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            service.busyCursorWhile((IRunnableWithProgress)new WorkbenchRunnableAdapter((IWorkspaceRunnable)cco, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()));
            return cco.getStatus();
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)parent, (String)title, (String)RefactoringUIMessages.RefactoringUI_open_unexpected_exception);
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringUIMessages.RefactoringUI_open_unexpected_exception);
        }
    }
}

