/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ecore.common.utils.http;

import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.search.core.scope.IModelSearchScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreModelSearchScopeHttpVisitor {
    IModelSearchScope<Object, Resource> modelSearchScope;

    public EcoreModelSearchScopeHttpVisitor(IModelSearchScope<Object, Resource> scope) {
        this.modelSearchScope = scope;
    }

    public boolean visit(URL url) {
        if (this.isParticipantCurrentSearchEngineValid(url)) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI fileURI = null;
            try {
                fileURI = URI.createURI((String)url.toURI().toString());
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
            if (fileURI != null) {
                this.initResourceSet((ResourceSet)resourceSet, fileURI);
                try {
                    Resource resource = resourceSet.getResource(fileURI, true);
                    if (resource instanceof Resource) {
                        this.modelSearchScope.addParticipant((Object)resource);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public IModelSearchScope<Object, Resource> getModelSearchScope() {
        return this.modelSearchScope;
    }

    protected void initResourceSet(ResourceSet resourceSet, URI fileURI) {
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
    }

    protected boolean isParticipantCurrentSearchEngineValid(URL url) {
        if (url != null) {
            return url.toString().endsWith(".ecore");
        }
        return false;
    }
}

