/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.notify;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.emf.eef.runtime.context.impl.DomainPropertiesEditionContext;
import org.eclipse.emf.eef.runtime.impl.operation.WizardEditingOperation;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class OpenTransactionalWizardOnDoubleClick
implements IDoubleClickListener {
    protected EditingDomain editingDomain;
    protected AdapterFactory adapterFactory;
    private IProgressMonitor progressMonitor;

    public OpenTransactionalWizardOnDoubleClick(EditingDomain editingDomain, AdapterFactory adapterFactory) {
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
    }

    public void doubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof StructuredSelection) {
            EObject eObject = null;
            Object firstElement = ((StructuredSelection)selection).getFirstElement();
            if (firstElement instanceof EObject) {
                eObject = (EObject)firstElement;
            } else if (firstElement instanceof IAdaptable && ((IAdaptable)firstElement).getAdapter(EObject.class) != null) {
                eObject = (EObject)((IAdaptable)firstElement).getAdapter(EObject.class);
            }
            if (eObject != null) {
                DomainPropertiesEditionContext propertiesEditionContext = new DomainPropertiesEditionContext(null, null, this.editingDomain, this.adapterFactory, eObject);
                WizardEditingOperation operation = new WizardEditingOperation(propertiesEditionContext);
                try {
                    operation.execute(this.getProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    EEFRuntimePlugin.getDefault().logError("An error occured during wizard editing.", (Exception)((Object)e));
                }
            }
        }
    }

    public IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }
}

