/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestExecutionContext;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestResultFormatter;
import org.apache.tools.ant.util.FileUtils;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

abstract class AbstractJUnitResultFormatter
implements TestResultFormatter {
    protected static String NEW_LINE = System.getProperty("line.separator");
    protected TestExecutionContext context;
    private SysOutErrContentStore sysOutStore;
    private SysOutErrContentStore sysErrStore;

    AbstractJUnitResultFormatter() {
    }

    public void sysOutAvailable(byte[] data) {
        if (this.sysOutStore == null) {
            this.sysOutStore = new SysOutErrContentStore(true);
        }
        try {
            this.sysOutStore.store(data);
        }
        catch (IOException e) {
            this.handleException(e);
            return;
        }
    }

    public void sysErrAvailable(byte[] data) {
        if (this.sysErrStore == null) {
            this.sysErrStore = new SysOutErrContentStore(false);
        }
        try {
            this.sysErrStore.store(data);
        }
        catch (IOException e) {
            this.handleException(e);
            return;
        }
    }

    public void setContext(TestExecutionContext context) {
        this.context = context;
    }

    boolean hasSysOut() {
        return this.sysOutStore != null && this.sysOutStore.hasData();
    }

    boolean hasSysErr() {
        return this.sysErrStore != null && this.sysErrStore.hasData();
    }

    Reader getSysOutReader() throws IOException {
        return this.sysOutStore.getReader();
    }

    Reader getSysErrReader() throws IOException {
        return this.sysErrStore.getReader();
    }

    void writeSysOut(Writer writer) throws IOException {
        Objects.requireNonNull(writer, "Writer cannot be null");
        this.writeFrom(this.sysOutStore, writer);
    }

    void writeSysErr(Writer writer) throws IOException {
        Objects.requireNonNull(writer, "Writer cannot be null");
        this.writeFrom(this.sysErrStore, writer);
    }

    static Optional<TestIdentifier> traverseAndFindTestClass(TestPlan testPlan, TestIdentifier testIdentifier) {
        if (AbstractJUnitResultFormatter.isTestClass(testIdentifier).isPresent()) {
            return Optional.of(testIdentifier);
        }
        Optional parent = testPlan.getParent(testIdentifier);
        return parent.isPresent() ? AbstractJUnitResultFormatter.traverseAndFindTestClass(testPlan, (TestIdentifier)parent.get()) : Optional.empty();
    }

    static Optional<ClassSource> isTestClass(TestIdentifier testIdentifier) {
        if (testIdentifier == null) {
            return Optional.empty();
        }
        Optional source = testIdentifier.getSource();
        if (!source.isPresent()) {
            return Optional.empty();
        }
        TestSource testSource = (TestSource)source.get();
        if (testSource instanceof ClassSource) {
            return Optional.of((ClassSource)testSource);
        }
        return Optional.empty();
    }

    private void writeFrom(SysOutErrContentStore store, Writer writer) throws IOException {
        char[] chars = new char[1024];
        int numRead = -1;
        Throwable throwable = null;
        Object var6_7 = null;
        try (Reader reader = store.getReader();){
            while ((numRead = reader.read(chars)) != -1) {
                writer.write(chars, 0, numRead);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void close() throws IOException {
        FileUtils.close((AutoCloseable)this.sysOutStore);
        FileUtils.close((AutoCloseable)this.sysErrStore);
    }

    protected void handleException(Throwable t) {
        this.context.getProject().ifPresent(p -> p.log("Exception in listener " + this.getClass().getName(), t, 4));
    }

    private static final class SysOutErrContentStore
    implements Closeable {
        private static final int DEFAULT_CAPACITY_IN_BYTES = 51200;
        private static final Reader EMPTY_READER = new Reader(){

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                return -1;
            }

            @Override
            public void close() throws IOException {
            }
        };
        private final String tmpFileSuffix;
        private ByteBuffer inMemoryStore = ByteBuffer.allocate(51200);
        private boolean usingFileStore = false;
        private Path filePath;
        private FileOutputStream fileOutputStream;

        SysOutErrContentStore(boolean isSysOut) {
            this.tmpFileSuffix = isSysOut ? ".sysout" : ".syserr";
        }

        void store(byte[] data) throws IOException {
            if (this.usingFileStore) {
                this.storeToFile(data, 0, data.length);
                return;
            }
            try {
                this.inMemoryStore.put(data);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                this.usingFileStore = true;
                this.fileOutputStream = this.createFileStore();
                this.storeToFile(this.inMemoryStore.array(), 0, this.inMemoryStore.position());
                this.storeToFile(data, 0, data.length);
                this.inMemoryStore = null;
                return;
            }
        }

        private void storeToFile(byte[] data, int offset, int length) throws IOException {
            if (this.fileOutputStream == null) {
                return;
            }
            this.fileOutputStream.write(data, offset, length);
        }

        private FileOutputStream createFileStore() throws IOException {
            this.filePath = Files.createTempFile(null, this.tmpFileSuffix, new FileAttribute[0]);
            this.filePath.toFile().deleteOnExit();
            return new FileOutputStream(this.filePath.toFile());
        }

        Reader getReader() throws IOException {
            if (this.usingFileStore && this.filePath != null) {
                return new BufferedReader(new FileReader(this.filePath.toFile()));
            }
            if (this.inMemoryStore != null) {
                return new InputStreamReader(new ByteArrayInputStream(this.inMemoryStore.array(), 0, this.inMemoryStore.position()));
            }
            return EMPTY_READER;
        }

        boolean hasData() {
            if (this.inMemoryStore != null && this.inMemoryStore.position() > 0) {
                return true;
            }
            return this.usingFileStore && this.filePath != null;
        }

        @Override
        public void close() throws IOException {
            this.inMemoryStore = null;
            FileUtils.close((OutputStream)this.fileOutputStream);
            FileUtils.delete((File)this.filePath.toFile());
        }
    }
}

