/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.net4j.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenUtil {
    private GenUtil() {
    }

    public static boolean isPrimitiveType(EClassifier eType) {
        Class result;
        block3: {
            try {
                result = eType.getInstanceClass();
                if (result != null) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        Class instanceClass = result;
        return instanceClass.isPrimitive();
    }

    public static String getFeatureUpperName(String featureName) {
        return GenUtil.format(featureName, '_', null, false, true).toUpperCase();
    }

    public static String getFeatureGetterName(String featureName, boolean isBooleanType) {
        String capName = StringUtil.cap((String)featureName);
        String result = isBooleanType ? "is" + capName : "get" + ("Class".equals(capName) ? "Class_" : capName);
        return result;
    }

    public static String format(String name, char separator, String prefix, boolean includePrefix, boolean includeLeadingSeparator) {
        String leadingSeparators;
        String string = leadingSeparators = includeLeadingSeparator ? GenUtil.getLeadingSeparators(name, '_') : null;
        if (leadingSeparators != null) {
            name = name.substring(leadingSeparators.length());
        }
        List<String> parsedName = new ArrayList<String>();
        if (prefix != null && name.startsWith(prefix) && name.length() > prefix.length() && Character.isUpperCase(name.charAt(prefix.length()))) {
            name = name.substring(prefix.length());
            if (includePrefix) {
                parsedName = GenUtil.parseName(prefix, '_');
            }
        }
        if (name.length() != 0) {
            parsedName.addAll(GenUtil.parseName(name, '_'));
        }
        StringBuilder result = new StringBuilder();
        Iterator nameIter = parsedName.iterator();
        while (nameIter.hasNext()) {
            String nameComponent = (String)nameIter.next();
            result.append(nameComponent);
            if (!nameIter.hasNext() || nameComponent.length() <= 1) continue;
            result.append(separator);
        }
        if (result.length() == 0 && prefix != null) {
            result.append(prefix);
        }
        return leadingSeparators != null ? "_" + result.toString() : result.toString();
    }

    public static List<String> parseName(String sourceName, char separator) {
        ArrayList<String> result = new ArrayList<String>();
        if (sourceName != null) {
            StringBuilder currentWord = new StringBuilder();
            boolean lastIsLower = false;
            int index = 0;
            int length = sourceName.length();
            while (index < length) {
                char curChar = sourceName.charAt(index);
                if (Character.isUpperCase(curChar) || !lastIsLower && Character.isDigit(curChar) || curChar == separator) {
                    if (lastIsLower && currentWord.length() > 1 || curChar == separator && currentWord.length() > 0) {
                        result.add(currentWord.toString());
                        currentWord = new StringBuilder();
                    }
                    lastIsLower = false;
                } else {
                    int currentWordLength;
                    if (!lastIsLower && (currentWordLength = currentWord.length()) > 1) {
                        char lastChar = currentWord.charAt(--currentWordLength);
                        currentWord.setLength(currentWordLength);
                        result.add(currentWord.toString());
                        currentWord = new StringBuilder();
                        currentWord.append(lastChar);
                    }
                    lastIsLower = true;
                }
                if (curChar != separator) {
                    currentWord.append(curChar);
                }
                ++index;
            }
            result.add(currentWord.toString());
        }
        return result;
    }

    private static String getLeadingSeparators(String name, char separator) {
        int i = 0;
        int len = name.length();
        while (i < len && name.charAt(i) == separator) {
            ++i;
        }
        return i != 0 ? name.substring(0, i) : null;
    }
}

