/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.protocol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.protocol.LoadRevisionRequest;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadRevisionByTimeRequest
extends LoadRevisionRequest {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, LoadRevisionByTimeRequest.class);
    private long timeStamp;

    public LoadRevisionByTimeRequest(IChannel channel, Collection<CDOID> ids, int referenceChunk, long timeStamp) {
        super(channel, ids, referenceChunk);
        this.timeStamp = timeStamp;
    }

    @Override
    protected short getSignalID() {
        return 8;
    }

    @Override
    protected void requesting(ExtendedDataOutputStream out) throws IOException {
        super.requesting(out);
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing timeStamp: {0}", new Object[]{this.timeStamp});
        }
        out.writeLong(this.timeStamp);
    }

    @Override
    public String toString() {
        return MessageFormat.format("{0}(ids={1}, referenceChunk={2}, timeStamp={3})", ((Object)((Object)this)).getClass().getSimpleName(), this.getIds(), this.getReferenceChunk(), this.timeStamp);
    }
}

