/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.protocol;

import java.io.IOException;
import java.util.HashSet;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.internal.cdo.CDOSessionImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.protocol.CDOClientProtocol;
import org.eclipse.net4j.signal.Indication;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class InvalidationIndication
extends Indication {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, InvalidationIndication.class);

    protected short getSignalID() {
        return 14;
    }

    protected void indicating(ExtendedDataInputStream in) throws IOException {
        long timeStamp = in.readLong();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Read timeStamp: {0,date} {0,time}", new Object[]{timeStamp});
        }
        int size = in.readInt();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Reading {0} dirty IDs", new Object[]{size});
        }
        CDOSessionImpl session = this.getSession();
        HashSet<CDOIDAndVersion> dirtyOIDs = new HashSet<CDOIDAndVersion>();
        int i = 0;
        while (i < size) {
            CDOIDAndVersion dirtyOID = CDOIDUtil.readIDAndVersion((ExtendedDataInput)in, (CDOIDObjectFactory)session);
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Read dirty ID: {0}", new Object[]{dirtyOID});
            }
            dirtyOIDs.add(dirtyOID);
            ++i;
        }
        session.notifyInvalidation(timeStamp, dirtyOIDs, null);
    }

    protected CDOSessionImpl getSession() {
        return (CDOSessionImpl)this.getProtocol().getInfraStructure();
    }

    public CDOClientProtocol getProtocol() {
        return (CDOClientProtocol)super.getProtocol();
    }
}

