/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.analyzer;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.analyzer.CDOFetchRuleManager;
import org.eclipse.emf.cdo.common.analyzer.CDOFetchRule;
import org.eclipse.emf.cdo.common.id.CDOID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOFetchRuleManagerThreadLocal
implements CDOFetchRuleManager {
    private static final ThreadLocal<CDOFetchRuleManager> threadLocal = new ThreadLocal();

    public static void join(CDOFetchRuleManager fetchRulemanager) {
        threadLocal.set(fetchRulemanager);
    }

    public static CDOFetchRuleManager getCurrent() {
        return threadLocal.get();
    }

    public static void leave() {
        threadLocal.set(null);
    }

    @Override
    public CDOID getContext() {
        CDOFetchRuleManager analyzer = CDOFetchRuleManagerThreadLocal.getCurrent();
        return analyzer != null ? analyzer.getContext() : null;
    }

    @Override
    public List<CDOFetchRule> getFetchRules(Collection<CDOID> ids) {
        CDOFetchRuleManager analyzer = CDOFetchRuleManagerThreadLocal.getCurrent();
        return analyzer != null ? analyzer.getFetchRules(ids) : null;
    }

    @Override
    public int getLoadRevisionCollectionChunkSize() {
        CDOFetchRuleManager analyzer = CDOFetchRuleManagerThreadLocal.getCurrent();
        return analyzer != null ? analyzer.getLoadRevisionCollectionChunkSize() : 0;
    }
}

