/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.analyzer;

import org.eclipse.emf.cdo.analyzer.CDOFeatureAnalyzer;
import org.eclipse.emf.cdo.analyzer.CDOFetchRuleManager;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.internal.cdo.InternalCDOObject;
import org.eclipse.emf.internal.cdo.analyzer.CDOFetchRuleManagerThreadLocal;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class CDOAbstractFeatureRuleAnalyzer
implements CDOFeatureAnalyzer,
CDOFetchRuleManager {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, CDOAbstractFeatureRuleAnalyzer.class);
    protected CDOFeature lastTraverseFeature;
    protected int lastTraverseIndex;
    protected long lastAccessTime;
    protected long lastElapseTimeBetweenOperations;
    protected InternalCDOObject lastTraverseCDOObject;
    protected long lastLatencyTime;
    protected int loadRevisionCollectionChunkSize;
    private boolean didFetch;
    private int fetchCount = 0;

    public int getFetchCount() {
        return this.fetchCount;
    }

    public int getLoadRevisionCollectionChunkSize() {
        return this.loadRevisionCollectionChunkSize;
    }

    public void preTraverseFeature(InternalCDOObject cdoObject, CDOFeature feature, int index) {
        if (TRACER.isEnabled()) {
            TRACER.format("preTraverseFeature : {0}.{1}", new Object[]{cdoObject.cdoClass(), feature.getName()});
        }
        this.loadRevisionCollectionChunkSize = cdoObject.cdoView().getLoadRevisionCollectionChunkSize();
        this.lastTraverseFeature = feature;
        this.lastTraverseCDOObject = cdoObject;
        this.lastTraverseIndex = index;
        this.lastElapseTimeBetweenOperations = System.currentTimeMillis() - this.lastAccessTime;
        this.lastAccessTime = System.currentTimeMillis();
        this.didFetch = false;
        CDOFetchRuleManagerThreadLocal.join(this);
        this.doPreTraverseFeature(cdoObject, feature, index);
    }

    public void postTraverseFeature(InternalCDOObject cdoObject, CDOFeature feature, int index, Object value) {
        if (TRACER.isEnabled()) {
            TRACER.format("postTraverseFeature : {0}.{1}", new Object[]{cdoObject.cdoClass(), feature.getName()});
        }
        try {
            this.doPostTraverseFeature(cdoObject, feature, index, value);
        }
        finally {
            CDOFetchRuleManagerThreadLocal.leave();
            this.lastAccessTime = System.currentTimeMillis();
        }
    }

    protected void doPreTraverseFeature(InternalCDOObject cdoObject, CDOFeature feature, int index) {
    }

    protected void doPostTraverseFeature(InternalCDOObject cdoObject, CDOFeature feature, int index, Object value) {
    }

    protected void fetchData() {
        this.didFetch = true;
        ++this.fetchCount;
    }

    protected boolean didFetch() {
        return this.didFetch;
    }
}

