/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionResolver;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.internal.server.Transaction;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerIndication;
import org.eclipse.emf.cdo.server.IRevisionManager;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CommitTransactionIndication
extends CDOServerIndication {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, CommitTransactionIndication.class);
    private Transaction transaction;

    protected short getSignalID() {
        return 13;
    }

    protected void indicating(ExtendedDataInputStream in) throws IOException {
        Repository repository = this.getRepository();
        IRevisionManager revisionResolver = repository.getRevisionManager();
        int viewID = in.readInt();
        this.transaction = this.getTransaction(viewID);
        this.transaction.preCommit();
        Transaction.TransactionPackageManager packageManager = this.transaction.getPackageManager();
        CDOPackage[] newPackages = new CDOPackage[in.readInt()];
        CDORevision[] newObjects = new CDORevision[in.readInt()];
        CDORevisionDelta[] dirtyObjectDeltas = new CDORevisionDelta[in.readInt()];
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Reading {0} new packages", new Object[]{newPackages.length});
        }
        int i = 0;
        while (i < newPackages.length) {
            newPackages[i] = CDOModelUtil.readPackage((CDOPackageManager)packageManager, (ExtendedDataInput)in);
            packageManager.addPackage(newPackages[i]);
            ++i;
        }
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Reading {0} new objects", new Object[]{newObjects.length});
        }
        i = 0;
        while (i < newObjects.length) {
            newObjects[i] = CDORevisionUtil.read((ExtendedDataInput)in, (CDORevisionResolver)revisionResolver, (CDOPackageManager)packageManager);
            ++i;
        }
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Reading {0} dirty object deltas", new Object[]{dirtyObjectDeltas.length});
        }
        i = 0;
        while (i < dirtyObjectDeltas.length) {
            dirtyObjectDeltas[i] = new CDORevisionDeltaImpl((ExtendedDataInput)in, (CDOPackageManager)packageManager);
            ++i;
        }
        this.transaction.commit(newPackages, newObjects, dirtyObjectDeltas);
    }

    protected void responding(ExtendedDataOutputStream out) throws IOException {
        boolean success = false;
        try {
            String rollbackMessage = this.transaction.getRollbackMessage();
            success = rollbackMessage == null;
            out.writeBoolean(success);
            if (success) {
                out.writeLong(this.transaction.getTimeStamp());
                List<CDOIDMetaRange> metaRanges = this.transaction.getMetaIDRanges();
                for (CDOIDMetaRange metaRange : metaRanges) {
                    CDOIDUtil.writeMetaRange((ExtendedDataOutput)out, (CDOIDMetaRange)metaRange);
                }
                Map<CDOIDTemp, CDOID> idMappings = this.transaction.getIDMappings();
                for (Map.Entry<CDOIDTemp, CDOID> entry : idMappings.entrySet()) {
                    CDOIDTemp oldID = entry.getKey();
                    if (oldID.isMeta()) continue;
                    CDOID newID = entry.getValue();
                    CDOIDUtil.write((ExtendedDataOutput)out, (CDOID)oldID);
                    CDOIDUtil.write((ExtendedDataOutput)out, (CDOID)newID);
                }
                CDOIDUtil.write((ExtendedDataOutput)out, (CDOID)CDOID.NULL);
            } else {
                out.writeString(rollbackMessage);
            }
        }
        finally {
            this.transaction.postCommit(success);
        }
    }

    private Transaction getTransaction(int viewID) {
        IView view = this.getSession().getView(viewID);
        if (view instanceof Transaction) {
            return (Transaction)view;
        }
        throw new IllegalStateException("Illegal transaction: " + view);
    }
}

