/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ResourceChangeAdapter
extends AdapterImpl {
    private final Comparison comparison;
    private final IComparisonScope scope;
    private final Set<Resource> resourcesToDelete;
    private final Set<Resource> addedResources;
    private final List<IResourceChangeParticipant> participants;

    public ResourceChangeAdapter(Comparison comparison, IComparisonScope scope) {
        this.comparison = (Comparison)Preconditions.checkNotNull((Object)comparison);
        this.scope = (IComparisonScope)Preconditions.checkNotNull((Object)scope);
        Preconditions.checkArgument((boolean)(scope.getLeft() instanceof ResourceSet));
        Preconditions.checkArgument((boolean)(scope.getRight() instanceof ResourceSet));
        this.resourcesToDelete = Sets.newLinkedHashSet();
        this.addedResources = Sets.newLinkedHashSet();
        this.participants = Lists.newArrayList();
    }

    public void notifyChanged(Notification msg) {
        if (!msg.isTouch()) {
            if (msg.getNotifier() instanceof Resource && msg.getFeatureID(Resource.class) == 2) {
                Resource resource = (Resource)msg.getNotifier();
                this.resourceContentsChanged(resource, msg);
            } else if (msg.getNotifier() instanceof ResourceSet && msg.getFeatureID(ResourceSet.class) == 0) {
                switch (msg.getEventType()) {
                    case 3: {
                        this.resourceAdded((Resource)msg.getNewValue());
                        break;
                    }
                    case 5: {
                        for (Resource r : (List)msg.getNewValue()) {
                            this.resourceAdded(r);
                        }
                        break;
                    }
                }
            }
        }
    }

    public boolean isAdapterForType(Object type) {
        return type == ResourceChangeAdapter.class;
    }

    public void addParticipant(IResourceChangeParticipant participant) {
        this.participants.add((IResourceChangeParticipant)Preconditions.checkNotNull((Object)participant));
    }

    public void removeParticipant(IResourceChangeParticipant participant) {
        this.participants.remove(participant);
    }

    public boolean mustDelete(Resource r) {
        return this.resourcesToDelete.contains(r);
    }

    protected void resourceAdded(Resource resource) {
        this.addedResources.add(resource);
        if (EcoreUtil.getAdapter((List)resource.eAdapters(), ResourceChangeAdapter.class) == null) {
            resource.eAdapters().add((Object)this);
        }
        for (IResourceChangeParticipant participant : Iterables.filter(this.participants, this.interestedIn(resource))) {
            for (URI relatedURI : participant.associatedResourceURIs(resource)) {
                if (resource.getResourceSet().getResource(relatedURI, false) != null || this.getResourceSetOnOtherSide(resource).getResource(relatedURI, false) == null) continue;
                resource.getResourceSet().createResource(relatedURI);
            }
        }
    }

    protected ResourceSet getResourceSetOnOtherSide(Resource r) {
        ResourceSet resourceSet = r.getResourceSet();
        if (this.scope.getLeft() == resourceSet) {
            return (ResourceSet)this.scope.getRight();
        }
        if (this.scope.getRight() == resourceSet) {
            return (ResourceSet)this.scope.getLeft();
        }
        throw new IllegalArgumentException("The given resource is neither on the left nor on the right");
    }

    protected void resourceContentsChanged(Resource resource, Notification msg) {
        block6: {
            block5: {
                Iterable interestedParticipants;
                if (resource.getContents() != null && !resource.getContents().isEmpty()) break block5;
                if (!this.isEmptyAndMissingOnOtherSide(resource) || !Iterables.all((Iterable)(interestedParticipants = Iterables.filter(this.participants, this.interestedIn(resource))), this.acceptDelete(resource))) break block6;
                this.resourcesToDelete.add(resource);
                for (IResourceChangeParticipant participant : interestedParticipants) {
                    for (URI relatedURI : participant.associatedResourceURIs(resource)) {
                        Resource related = resource.getResourceSet().getResource(relatedURI, false);
                        if (related == null) continue;
                        this.resourcesToDelete.add(related);
                    }
                }
                break block6;
            }
            if (this.resourcesToDelete.remove(resource)) {
                Iterable interestedParticipants = Iterables.filter(this.participants, this.interestedIn(resource));
                for (IResourceChangeParticipant participant : interestedParticipants) {
                    for (URI relatedURI : participant.associatedResourceURIs(resource)) {
                        Resource related = resource.getResourceSet().getResource(relatedURI, false);
                        if (related == null) continue;
                        this.resourcesToDelete.remove(related);
                    }
                }
            }
        }
    }

    public boolean isEmptyAndMissingOnOtherSide(Resource resource) {
        return resource.getContents().isEmpty() && (this.addedResources.contains(resource) || this.getResourceMatch(resource).isMissingOnOtherSide());
    }

    protected ResourceMatch getResourceMatch(Resource resource) {
        for (MatchResource matchRes : this.comparison.getMatchedResources()) {
            if (matchRes.getLeft() == resource) {
                return new ResourceMatch(matchRes, DifferenceSource.LEFT);
            }
            if (matchRes.getRight() != resource) continue;
            return new ResourceMatch(matchRes, DifferenceSource.RIGHT);
        }
        throw new IllegalStateException(EMFCompareMessages.getString("ResourceAttachmentChangeSpec.MissingMatch", resource.getURI().lastSegment()));
    }

    private Predicate<IResourceChangeParticipant> interestedIn(final Resource r) {
        return new Predicate<IResourceChangeParticipant>(){

            public boolean apply(IResourceChangeParticipant input) {
                return input.interestedIn(r);
            }
        };
    }

    private Predicate<IResourceChangeParticipant> acceptDelete(final Resource r) {
        return new Predicate<IResourceChangeParticipant>(){

            public boolean apply(IResourceChangeParticipant input) {
                return input.acceptDelete(r);
            }
        };
    }

    public static interface IResourceChangeParticipant {
        public boolean interestedIn(Resource var1);

        public boolean acceptDelete(Resource var1);

        public Collection<URI> associatedResourceURIs(Resource var1);
    }

    private static final class ResourceMatch {
        private final MatchResource matchResource;
        private final DifferenceSource side;

        private ResourceMatch(MatchResource matchResource, DifferenceSource side) {
            this.matchResource = (MatchResource)Preconditions.checkNotNull((Object)matchResource);
            this.side = (DifferenceSource)((Object)Preconditions.checkNotNull((Object)((Object)side)));
        }

        public boolean isMissingOnOtherSide() {
            switch (this.side) {
                case LEFT: {
                    return this.matchResource.getRight() == null;
                }
                case RIGHT: {
                    return this.matchResource.getLeft() == null;
                }
            }
            throw new IllegalStateException();
        }
    }
}

