/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compre.uml2.edit.papyrus.internal.decorator;

import org.eclipse.emf.compre.uml2.edit.papyrus.internal.decorator.PapyrusStereotypedElementUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.emf.facet.custom.core.exception.CustomizationException;
import org.eclipse.papyrus.emf.facet.custom.metamodel.custompt.IImage;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.ImageManager;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.PropertiesHandler;
import org.eclipse.papyrus.infra.services.labelprovider.service.IFilteredLabelProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.graphics.Image;

public class PapyrusElementFilteredLabelProvider
extends UMLLabelProvider
implements IFilteredLabelProvider {
    private PropertiesHandler propertiesHandler = new PropertiesHandler(this.getCustomizationManager());
    private ImageManager imageManager = new ImageManager();

    public boolean accept(Object object) {
        return PapyrusStereotypedElementUtil.isPapyrusStereotypedElement(object);
    }

    public String getText(Object object) {
        EObject element = (EObject)object;
        ICustomizationManager customizationManager = this.getCustomizationManager();
        if (customizationManager == null) {
            return super.getText(element);
        }
        try {
            return (String)customizationManager.getCustomValueOf(element, this.propertiesHandler.getLabelProperty(), String.class);
        }
        catch (CustomizationException customizationException) {
            return super.getText(element);
        }
    }

    public Image getImage(Object object) {
        EObject element = (EObject)object;
        ICustomizationManager customizationManager = this.getCustomizationManager();
        if (customizationManager == null) {
            return super.getImage(element);
        }
        try {
            IImage image = (IImage)customizationManager.getCustomValueOf(element, this.propertiesHandler.getImageProperty(), IImage.class);
            return this.imageManager.getImage(image);
        }
        catch (CustomizationException customizationException) {
            return super.getImage(element);
        }
    }
}

