/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import java.util.Iterator;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.IMerger;

public class ConflictMerger
extends AbstractMerger {
    public boolean isMergerFor(Diff target) {
        return target.getConflict() != null && target.getConflict().getKind() == ConflictKind.REAL;
    }

    public void copyLeftToRight(Diff target, Monitor monitor) {
        if (target.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        if (target.getSource() == DifferenceSource.LEFT) {
            Conflict conflict = target.getConflict();
            for (Diff conflictedDiff : conflict.getDifferences()) {
                if (target == conflictedDiff || target.getKind() == DifferenceKind.MOVE && conflictedDiff.getKind() != DifferenceKind.MOVE && conflictedDiff.getKind() != DifferenceKind.DELETE || conflictedDiff.getSource() != DifferenceSource.RIGHT) continue;
                this.mergeConflictedDiff(conflictedDiff, true, monitor);
            }
        }
        this.getHighestRankingMerger(target).copyLeftToRight(target, monitor);
    }

    public void copyRightToLeft(Diff target, Monitor monitor) {
        if (target.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        if (target.getSource() == DifferenceSource.RIGHT) {
            Conflict conflict = target.getConflict();
            for (Diff conflictedDiff : conflict.getDifferences()) {
                if (target == conflictedDiff || target.getKind() == DifferenceKind.MOVE && conflictedDiff.getKind() != DifferenceKind.MOVE && conflictedDiff.getKind() != DifferenceKind.DELETE || conflictedDiff.getSource() != DifferenceSource.LEFT) continue;
                this.mergeConflictedDiff(conflictedDiff, false, monitor);
            }
        }
        this.getHighestRankingMerger(target).copyRightToLeft(target, monitor);
    }

    private void mergeConflictedDiff(Diff conflictedDiff, boolean leftToRight, Monitor monitor) {
        if (conflictedDiff.getKind() != DifferenceKind.MOVE) {
            IMerger highestRankingMerger = this.getHighestRankingMerger(conflictedDiff);
            if (leftToRight) {
                highestRankingMerger.copyLeftToRight(conflictedDiff, monitor);
            } else {
                highestRankingMerger.copyRightToLeft(conflictedDiff, monitor);
            }
        } else {
            conflictedDiff.setState(DifferenceState.MERGED);
        }
    }

    private IMerger getHighestRankingMerger(Diff target) {
        Iterator<IMerger> mergers = this.getRegistry().getMergers(target).iterator();
        IMerger ret = null;
        if (mergers.hasNext()) {
            IMerger highestRanking = mergers.next();
            while (mergers.hasNext()) {
                IMerger merger = mergers.next();
                if (highestRanking != this && (merger == this || merger.getRanking() <= highestRanking.getRanking())) continue;
                highestRanking = merger;
            }
            ret = highestRanking;
        }
        if (ret == null) {
            throw new IllegalStateException(EMFCompareMessages.getString("IMerger.MissingMerger", target.getClass().getSimpleName()));
        }
        return ret;
    }
}

