/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.ui;

import fr.inria.aoste.timesquare.launcher.ui.MyAbstractLaunchConfigurationTab;
import fr.inria.aoste.timesquare.utils.ui.listeners.FileExtensionFilter;
import fr.inria.aoste.timesquare.utils.ui.listeners.SelectionFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TextBrowse
implements SelectionListener,
ModifyListener {
    private IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
    private Button b;
    private final MyAbstractLaunchConfigurationTab modelSimulationTab;
    private Text t;
    private Group group;
    private String[] listExtension = null;
    private String textlabel = "";
    private IFile value = null;

    public TextBrowse(MyAbstractLaunchConfigurationTab modelSimulationTab, Composite parent, String label, String[] extension) {
        this.modelSimulationTab = modelSimulationTab;
        if (extension != null) {
            this.listExtension = (String[])extension.clone();
        }
        this.textlabel = label;
        this.createSourceEditor(parent, label);
    }

    protected IFile getSourceFile() {
        if (this.value != null) {
            return this.value;
        }
        IResource res = this.root.findMember(this.t.getText());
        if (res instanceof IFile) {
            this.value = (IFile)res;
        } else {
            this.modelSimulationTab.setErrorMessage("Wrong file name " + this.t.getText() + ".");
        }
        return this.value;
    }

    protected void setSourceFile(IFile file) {
        this.value = file;
        if (file == null) {
            this.t.setText("");
        } else {
            this.t.setText(file.getFullPath().toString());
        }
    }

    protected void createSourceEditor(Composite parent, String label) {
        Font font = parent.getFont();
        this.group = new Group(parent, 0);
        this.group.setText(label);
        GridData gd = new GridData(768);
        this.group.setLayoutData((Object)gd);
        FormLayout layout = new FormLayout();
        this.group.setLayout((Layout)layout);
        this.group.setFont(font);
        this.t = new Text((Composite)this.group, 2052);
        this.b = this.modelSimulationTab.createPushButton((Composite)this.group, "Browse...", null);
        int k = 3;
        FormData data = new FormData();
        data.top = new FormAttachment(0, k);
        data.left = new FormAttachment(0, k);
        data.right = new FormAttachment((Control)this.b, -k);
        data.bottom = new FormAttachment(100, -k);
        this.t.setLayoutData((Object)data);
        this.t.setFont(font);
        data = new FormData();
        data.top = new FormAttachment(0, k);
        data.width = 100;
        data.right = new FormAttachment(100, -k);
        data.bottom = new FormAttachment(100, -k);
        this.b.setLayoutData((Object)data);
        this.t.addModifyListener((ModifyListener)this);
        this.b.addSelectionListener((SelectionListener)this);
    }

    public Group getGroup() {
        return this.group;
    }

    private void handleSearchButtonSelected() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(new Shell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)this.root);
        dialog.setAllowMultiple(false);
        dialog.setDoubleClickSelects(false);
        dialog.setTitle(this.textlabel);
        dialog.setMessage("message");
        dialog.setInitialSelection((Object)this.value);
        dialog.addFilter((ViewerFilter)new FileExtensionFilter(this.listExtension));
        dialog.setValidator((ISelectionStatusValidator)new SelectionFile());
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        if (results != null && results.length != 0 && results[0] instanceof IFile) {
            this.setSourceFile((IFile)results[0]);
        }
    }

    public void modifyText(ModifyEvent e) {
        this.modelSimulationTab.updateLaunchConfigurationDialog();
    }

    public void widgetSelected(SelectionEvent e) {
        this.handleSearchButtonSelected();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }
}

