/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons.MoccmlExecutionPlatform;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse.OperationExecution;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.AbstractConcurrentExecutionEngine;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dsa.executors.CodeExecutionException;
import org.eclipse.gemoc.executionframework.engine.Activator;
import org.eclipse.gemoc.trace.commons.model.trace.SmallStep;
import org.eclipse.gemoc.trace.commons.model.trace.Step;

public class SynchroneExecution
extends OperationExecution {
    public SynchroneExecution(SmallStep<?> smallStep, AbstractConcurrentExecutionEngine engine, Consumer<Step<?>> beforeStep, Consumer<List<Object>> afterStep) {
        super(smallStep, engine, beforeStep, afterStep);
    }

    @Override
    public void run() throws CodeExecutionException {
        this.beforeStepCallback((Step<?>)this.getSmallStep());
        Object res = this.callExecutor();
        this.setResult(res);
        try {
            this.applyAnimationTime();
        }
        catch (InterruptedException e) {
            Activator.getDefault().error("Exception received " + e.getMessage(), (Throwable)e);
        }
        this.afterStepCallback(Collections.singletonList(res));
    }

    private Object callExecutor() throws CodeExecutionException {
        Object res = null;
        res = ((MoccmlExecutionPlatform)this.getExecutionContext().getExecutionPlatform()).getCodeExecutor().execute(this.getSmallStep().getMseoccurrence());
        return res;
    }

    private void applyAnimationTime() throws InterruptedException {
        int animationDelay = this.getEngine().getExecutionContext().getRunConfiguration().getAnimationDelay();
        if (animationDelay != 0) {
            Thread.sleep(animationDelay);
        }
    }
}

