/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.sat;

import fr.kairos.timesquare.ccsl.sat.IClause;
import fr.kairos.timesquare.ccsl.sat.IClauseVisitor;
import fr.kairos.timesquare.ccsl.sat.SimpleClause;
import java.util.Collections;
import java.util.Iterator;

public class Clause
implements IClause {
    private SimpleClause positive;
    private SimpleClause negative;

    protected Clause(int[] positive, int[] negative) {
        this(new SimpleClause(positive), new SimpleClause(negative));
    }

    protected Clause(SimpleClause positive, SimpleClause negative) {
        this.positive = positive;
        this.negative = negative;
    }

    public static Clause hornClause(int pos, int ... neg) {
        return new Clause(new int[]{pos}, neg);
    }

    public static Clause dualHornClause(int neg, int ... pos) {
        return new Clause(pos, new int[]{neg});
    }

    public static Clause goalClause(int ... neg) {
        return new Clause(new int[0], neg);
    }

    public SimpleClause getPositive() {
        return this.positive;
    }

    public SimpleClause getNegative() {
        return this.negative;
    }

    @Override
    public Iterator<Clause> iterator() {
        return Collections.singleton(this).iterator();
    }

    @Override
    public void accept(IClauseVisitor visitor) {
        visitor.visit(this);
    }
}

