/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.core.console;

import fr.inria.aoste.timesquare.launcher.core.Activator;
import fr.inria.aoste.timesquare.launcher.core.console.ConsoleRemoveAllTerminatedAction;
import fr.inria.aoste.timesquare.launcher.core.console.ConsoleRemoveLaunchAction;
import fr.inria.aoste.timesquare.launcher.core.console.ConsoleSimulation;
import fr.inria.aoste.timesquare.launcher.core.console.ConsoleTerminateAction;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.IStreamsProxy2;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.actions.CloseConsoleAction;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;

public class SimulationConsolePageParticipant
implements IConsolePageParticipant {
    public static final String CONSOLE_OPEN_ON_OUT = "DEBUG.consoleOpenOnOut";
    public static final String CONSOLE_OPEN_ON_ERR = "DEBUG.consoleOpenOnErr";
    private CloseConsoleAction close;
    private ConsoleTerminateAction fTerminate;
    private ConsoleRemoveLaunchAction fRemoveTerminated;
    private ConsoleRemoveAllTerminatedAction fRemoveAllTerminated;
    private ShowWhenContentChangesAction fStdOut;
    private ShowWhenContentChangesAction fStdErr;
    private ConsoleSimulation fConsole;
    private IPageBookViewPage fPage;
    private IConsoleView fView;
    private EOFHandler fEOFHandler;
    private String fContextId = "org.eclipse.debug.ui.console";
    private IContextActivation fActivatedContext;
    private IHandlerActivation fActivatedHandler;

    public void activated() {
        IPageSite site = this.fPage.getSite();
        IHandlerService handlerService = (IHandlerService)site.getService(IHandlerService.class);
        IContextService contextService = (IContextService)site.getService(IContextService.class);
        this.fActivatedContext = contextService.activateContext(this.fContextId);
        this.fActivatedHandler = handlerService.activateHandler("org.eclipse.debug.ui.commands.eof", (IHandler)this.fEOFHandler);
    }

    public void deactivated() {
        IPageSite site = this.fPage.getSite();
        IHandlerService handlerService = (IHandlerService)site.getService(IHandlerService.class);
        IContextService contextService = (IContextService)site.getService(IContextService.class);
        handlerService.deactivateHandler(this.fActivatedHandler);
        contextService.deactivateContext(this.fActivatedContext);
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0 && this.fView != null && this.getProcess().equals(DebugUITools.getCurrentProcess())) {
            this.fView.display((IConsole)this.fConsole);
        }
    }

    public void dispose() {
    }

    public void init(IPageBookViewPage page, IConsole console) {
        try {
            this.fPage = page;
            this.fConsole = (ConsoleSimulation)console;
            this.fRemoveTerminated = new ConsoleRemoveLaunchAction(this.fConsole.getiProcess().getLaunch());
            this.fRemoveAllTerminated = new ConsoleRemoveAllTerminatedAction();
            this.fTerminate = new ConsoleTerminateAction(page.getSite().getWorkbenchWindow(), this.fConsole);
            this.close = new CloseConsoleAction((IConsole)this.fConsole);
            this.fStdOut = new ShowStandardOutAction();
            this.fStdErr = new ShowStandardErrorAction();
            this.fView = (IConsoleView)this.fPage.getSite().getPage().findView("org.eclipse.ui.console.ConsoleView");
            IActionBars actionBars = this.fPage.getSite().getActionBars();
            this.configureToolBar(actionBars.getToolBarManager());
            this.fEOFHandler = new EOFHandler();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public Object getAdapter(Class required) {
        if (ILaunchConfiguration.class.equals((Object)required)) {
            ILaunch launch = this.getProcess().getLaunch();
            if (launch != null) {
                return launch.getLaunchConfiguration();
            }
            return null;
        }
        return null;
    }

    protected void configureToolBar(IToolBarManager mgr) {
        if (this.fTerminate != null) {
            mgr.appendToGroup("launchGroup", (IAction)this.fTerminate);
        }
        if (this.fRemoveTerminated != null) {
            mgr.appendToGroup("launchGroup", (IAction)this.fRemoveTerminated);
        }
        if (this.fRemoveAllTerminated != null) {
            mgr.appendToGroup("launchGroup", (IAction)this.fRemoveAllTerminated);
        }
        if (this.close != null) {
            mgr.appendToGroup("outputGroup", (IAction)this.close);
        }
        mgr.appendToGroup("outputGroup", (IAction)this.fStdOut);
        mgr.appendToGroup("outputGroup", (IAction)this.fStdErr);
    }

    protected IProcess getProcess() {
        return this.fConsole != null ? this.fConsole.getiProcess() : null;
    }

    private class EOFHandler
    extends AbstractHandler {
        private EOFHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            try {
                IStreamsProxy proxy = SimulationConsolePageParticipant.this.getProcess().getStreamsProxy();
                if (proxy instanceof IStreamsProxy2) {
                    IStreamsProxy2 proxy2 = (IStreamsProxy2)proxy;
                    proxy2.closeInputStream();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public class ShowStandardErrorAction
    extends ShowWhenContentChangesAction {
        public ShowStandardErrorAction() {
            super("Show Console When Standard Error Changes");
            this.setId("fr.inria.aoste.timesquare.launcher.core.ShowWhenStderrChangesAction");
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.show_stderr_action_context");
            this.setImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_ELCL_STANDARD_ERR"));
        }

        @Override
        protected String getKey() {
            return SimulationConsolePageParticipant.CONSOLE_OPEN_ON_ERR;
        }
    }

    public class ShowStandardOutAction
    extends ShowWhenContentChangesAction {
        public ShowStandardOutAction() {
            super("Show Console When Standard Out Changes");
            this.setId("fr.inria.aoste.timesquare.launcher.core.ShowWhenStdoutChangesAction");
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.show_stdout_action_context");
            this.setImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_ELCL_STANDARD_OUT"));
        }

        @Override
        protected String getKey() {
            return SimulationConsolePageParticipant.CONSOLE_OPEN_ON_OUT;
        }
    }

    public abstract class ShowWhenContentChangesAction
    extends Action
    implements IPropertyChangeListener {
        public ShowWhenContentChangesAction(String name) {
            super(name, 2);
            this.setToolTipText(name);
            this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
            this.update();
        }

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals(this.getKey())) {
                this.update();
            }
        }

        protected abstract String getKey();

        private void update() {
            IPreferenceStore store = this.getPreferenceStore();
            if (store.getBoolean(this.getKey())) {
                this.setChecked(true);
            } else {
                this.setChecked(false);
            }
        }

        private IPreferenceStore getPreferenceStore() {
            return Activator.getDefault().getPreferenceStore();
        }

        public void run() {
            IPreferenceStore store = this.getPreferenceStore();
            boolean show = this.isChecked();
            store.removePropertyChangeListener((IPropertyChangeListener)this);
            store.setValue(this.getKey(), show);
            store.addPropertyChangeListener((IPropertyChangeListener)this);
        }

        public void dispose() {
            this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }
}

