/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.core.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.gemoc.commons.eclipse.core.resources.NatureToggling;

public class IProjectUtils {
    public static IFolder createFolder(IProject project, String nameOrPath) throws CoreException {
        return IProjectUtils.createFolder(project, nameOrPath, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IFolder createFolder(IProject project, String nameOrPath, IProgressMonitor monitor) throws CoreException {
        return IProjectUtils.createFolder(project, (IPath)new Path(nameOrPath), monitor);
    }

    public static IFolder createFolder(IProject project, IPath path, IProgressMonitor monitor) throws CoreException {
        IFolder folder = project.getFolder(path);
        if (!folder.exists()) {
            if (path.segmentCount() > 1) {
                Path currentFolderPath = new Path("");
                int i = 0;
                while (i < path.segmentCount() - 1) {
                    currentFolderPath = currentFolderPath.append(path.segment(i));
                    IProjectUtils.createFolder(project, (IPath)currentFolderPath, monitor);
                    ++i;
                }
            }
            folder.create(true, true, monitor);
        }
        return folder;
    }

    public static IFile createFile(IProject project, String nameOrPath, String content, IProgressMonitor monitor) throws CoreException {
        ByteArrayInputStream contentStream = new ByteArrayInputStream(content.getBytes());
        IFile file = IProjectUtils.createFile(project, (IPath)new Path(nameOrPath), (InputStream)contentStream, monitor);
        return file;
    }

    public static IFile createFile(IProject project, String nameOrPath, InputStream contentStream, IProgressMonitor monitor) throws CoreException {
        return IProjectUtils.createFile(project, (IPath)new Path(nameOrPath), contentStream, monitor);
    }

    public static IFile createFile(IProject project, IPath path, InputStream contentStream, IProgressMonitor monitor) throws CoreException {
        IFile file = project.getFile(path);
        return IProjectUtils.createFile(project, file, contentStream, monitor);
    }

    public static IFile createFile(IProject project, IFile file, String content) throws CoreException {
        return IProjectUtils.createFile(project, file, content, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IFile createFile(IProject project, IFile file, String content, IProgressMonitor monitor) throws CoreException {
        ByteArrayInputStream contentStream = new ByteArrayInputStream(content.getBytes());
        return IProjectUtils.createFile(project, file, (InputStream)contentStream, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IFile createFile(IProject project, IFile file, InputStream contentStream, IProgressMonitor monitor) throws CoreException {
        if (!file.exists()) {
            IPath path = file.getProjectRelativePath();
            if (path.segmentCount() > 1) {
                Path currentFolderPath = new Path("");
                int i = 0;
                while (i < path.segmentCount() - 1) {
                    currentFolderPath = currentFolderPath.append(path.segment(i));
                    IProjectUtils.createFolder(project, (IPath)currentFolderPath, monitor);
                    ++i;
                }
            }
            try {
                file.create(contentStream, true, monitor);
            }
            finally {
                try {
                    contentStream.close();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "", "Could not close stream for file " + file.getFullPath(), (Throwable)e));
                }
            }
        }
        return file;
    }

    public static void addNature(IProject project, String natureId) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        if (!project.hasNature(natureId)) {
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 1, natures.length);
            newNatures[0] = natureId;
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
    }

    public static void removeNature(IProject project, String natureId) throws CoreException {
        IProjectDescription description = project.getDescription();
        ArrayList<String> natures = new ArrayList<String>(Arrays.asList(description.getNatureIds()));
        natures.remove(natureId);
        String[] newNatures = natures.toArray(new String[natures.size()]);
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }

    public static NatureToggling toggleNature(IProject project, String natureId) throws CoreException {
        if (!project.hasNature(natureId)) {
            IProjectUtils.addNature(project, natureId);
            return NatureToggling.Added;
        }
        IProjectUtils.removeNature(project, natureId);
        return NatureToggling.Removed;
    }

    public static void setFileContent(IProject project, String filePath, String fileContent) throws CoreException {
        IProjectUtils.setFileContent(project, (IPath)new Path(filePath), fileContent);
    }

    public static void setFileContent(IProject project, IPath filePath, String fileContent) throws CoreException {
        IFile file = project.getFile(filePath);
        IProjectUtils.setFileContent(project, file, fileContent, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void setFileContent(IProject project, IFile file, String fileContent, IProgressMonitor monitor) throws CoreException {
        if (file.exists()) {
            ByteArrayInputStream contentStream = new ByteArrayInputStream(fileContent.getBytes());
            try {
                file.setContents((InputStream)contentStream, true, true, monitor);
            }
            finally {
                try {
                    contentStream.close();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "", "Could not close stream for file " + file.getFullPath(), (Throwable)e));
                }
            }
        }
    }
}

