/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.validation;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.runtime.AcceleoQueryValidationException;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.ValidationResult;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.AbstractCollectionType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecoretools.ale.core.Activator;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.AcceleoValidationMessage;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.CodeLocation;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.DiagnosticsFactory;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.InternalError;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.Message;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.Scopes;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.impl.StackedScopes;
import org.eclipse.emf.ecoretools.ale.core.interpreter.notapi.EvalEnvironment;
import org.eclipse.emf.ecoretools.ale.core.parser.ParsedFile;
import org.eclipse.emf.ecoretools.ale.core.validation.IConvertType;
import org.eclipse.emf.ecoretools.ale.core.validation.IValidator;
import org.eclipse.emf.ecoretools.ale.core.validation.SafeValidator;
import org.eclipse.emf.ecoretools.ale.core.validation.impl.ConvertType;
import org.eclipse.emf.ecoretools.ale.implementation.Attribute;
import org.eclipse.emf.ecoretools.ale.implementation.BehavioredClass;
import org.eclipse.emf.ecoretools.ale.implementation.Block;
import org.eclipse.emf.ecoretools.ale.implementation.ConditionalBlock;
import org.eclipse.emf.ecoretools.ale.implementation.ExpressionStatement;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureInsert;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureRemove;
import org.eclipse.emf.ecoretools.ale.implementation.ForEach;
import org.eclipse.emf.ecoretools.ale.implementation.If;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationPackage;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;
import org.eclipse.emf.ecoretools.ale.implementation.Statement;
import org.eclipse.emf.ecoretools.ale.implementation.VariableAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.VariableDeclaration;
import org.eclipse.emf.ecoretools.ale.implementation.VariableInsert;
import org.eclipse.emf.ecoretools.ale.implementation.VariableRemove;
import org.eclipse.emf.ecoretools.ale.implementation.While;
import org.eclipse.emf.ecoretools.ale.implementation.util.ImplementationSwitch;

public class BaseValidator
extends ImplementationSwitch<Object> {
    private List<Message> msgs;
    private List<ParsedFile<ModelUnit>> allModels;
    private ParsedFile<ModelUnit> currentModel;
    private Map<Expression, IValidationResult> validations;
    private Map<Expression, Map<String, Set<IType>>> validationContexts;
    private Map<Block, Scopes.Scope> blockContexts;
    protected Scopes scopes;
    private AstValidator expValidator;
    private IQueryEnvironment qryEnv;
    private List<IValidator> validators;
    private IConvertType convert;
    protected IAleEnvironment environment;

    public BaseValidator(IAleEnvironment environment, List<IValidator> validators) {
        this.environment = environment;
        this.qryEnv = environment.getContext();
        this.expValidator = new AstValidator(new ValidationServices((IReadOnlyQueryEnvironment)this.qryEnv));
        this.convert = new ConvertType((IReadOnlyQueryEnvironment)this.qryEnv);
        this.scopes = new StackedScopes();
        this.validators = new ArrayList<IValidator>();
        validators.forEach(validator -> {
            this.validators.add(new SafeValidator((IValidator)validator));
            validator.setBase(this);
        });
    }

    public Scopes getScopes() {
        return this.scopes;
    }

    public List<Message> validate(List<ParsedFile<ModelUnit>> roots) {
        this.msgs = new ArrayList<Message>();
        this.validations = new HashMap<Expression, IValidationResult>();
        this.validationContexts = new HashMap<Expression, Map<String, Set<IType>>>();
        this.blockContexts = new HashMap<Block, Scopes.Scope>();
        this.allModels = roots;
        List allUnits = roots.stream().map(p -> (ModelUnit)p.getRoot()).filter(Objects::nonNull).collect(Collectors.toList());
        new EvalEnvironment(this.environment, null, null);
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateModelBehavior(allUnits));
        });
        roots.forEach(root -> {
            this.currentModel = root;
            this.scopes.clear();
            this.doSwitchSafely((EObject)this.currentModel.getRoot());
        });
        return this.msgs;
    }

    @Override
    public Object caseModelUnit(ModelUnit root) {
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateModelUnit(root));
        });
        for (BehavioredClass xtdClass : root.getClassExtensions()) {
            this.doSwitchSafely((EObject)xtdClass);
        }
        for (BehavioredClass xtdClass : root.getClassDefinitions()) {
            this.doSwitchSafely((EObject)xtdClass);
        }
        return null;
    }

    @Override
    public Object caseExtendedClass(ExtendedClass xtdClass) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scopes.Scope classScope = this.scopes.pushNew();){
            for (Attribute attrib : xtdClass.getAttributes()) {
                if (attrib.getInitialValue() == null) continue;
                this.validateAndStore(attrib.getInitialValue(), new HashMap<String, Set<IType>>());
            }
            this.validators.stream().forEach(validator -> {
                boolean bl = this.msgs.addAll(validator.validateExtendedClass(xtdClass));
            });
            EClassifierType selfType = xtdClass.getBaseClass() == null ? new EClassifierType((IReadOnlyQueryEnvironment)this.qryEnv, (EClassifier)ImplementationPackage.eINSTANCE.getUnresolvedEClassifier()) : new EClassifierType((IReadOnlyQueryEnvironment)this.qryEnv, (EClassifier)xtdClass.getBaseClass());
            classScope.putTypes("self", (Set<IType>)Sets.newHashSet((Object[])new IType[]{selfType}));
            for (Method operation : xtdClass.getMethods()) {
                this.doSwitchSafely(operation);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    @Override
    public Object caseRuntimeClass(RuntimeClass runtimeCls) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scopes.Scope classScope = this.scopes.pushNew();){
            Collection registered;
            for (Attribute attrib : runtimeCls.getAttributes()) {
                if (attrib.getInitialValue() == null) continue;
                this.validateAndStore(attrib.getInitialValue(), new HashMap<String, Set<IType>>());
            }
            this.validators.stream().forEach(validator -> {
                boolean bl = this.msgs.addAll(validator.validateRuntimeClass(runtimeCls));
            });
            String pkgName = ((ModelUnit)runtimeCls.eContainer()).getName();
            if (pkgName.lastIndexOf(46) != -1 && pkgName.lastIndexOf(46) != pkgName.length() - 1) {
                pkgName = pkgName.substring(pkgName.lastIndexOf(46) + 1);
            }
            if (!(registered = this.qryEnv.getEPackageProvider().getTypes(pkgName, runtimeCls.getName())).isEmpty()) {
                EClassifier runtimeEClass = (EClassifier)registered.iterator().next();
                HashSet<IType> selfTypeSet = new HashSet<IType>();
                EClassifierType selfType = new EClassifierType((IReadOnlyQueryEnvironment)this.qryEnv, runtimeEClass);
                selfTypeSet.add((IType)selfType);
                classScope.putTypes("self", selfTypeSet);
            }
            for (Method operation : runtimeCls.getMethods()) {
                this.doSwitchSafely(operation);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    @Override
    public Object caseMethod(Method mtd) {
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateMethod(mtd));
        });
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scopes.Scope methodScope = this.scopes.pushNew();){
            boolean hasACorrespondingEOperation;
            if (mtd.getOperationRef() != null) {
                for (EParameter param : mtd.getOperationRef().getEParameters()) {
                    boolean previousDeclaration = methodScope.findTypes(param.getName()).isPresent();
                    if (previousDeclaration) continue;
                    IType aqlParameterType = this.convert.toAQL((ETypedElement)param);
                    methodScope.putTypes(param.getName(), (Set<IType>)Sets.newHashSet((Object[])new IType[]{aqlParameterType}));
                }
            }
            boolean bl = hasACorrespondingEOperation = mtd.getOperationRef() != null;
            if (hasACorrespondingEOperation) {
                boolean returnsSomething;
                EClassifier methodType = mtd.getOperationRef().getEType();
                boolean bl2 = returnsSomething = methodType != null;
                if (returnsSomething) {
                    EClassifierType returnType = new EClassifierType((IReadOnlyQueryEnvironment)this.qryEnv, methodType);
                    methodScope.putTypes("result", (Set<IType>)Sets.newHashSet((Object[])new IType[]{returnType}));
                }
            }
            this.doSwitchSafely(mtd.getBody());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    @Override
    public Object caseBlock(Block block) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scopes.Scope blockScope = this.scopes.pushNew();){
            this.blockContexts.put(block, blockScope);
            for (Statement stmt : block.getStatements()) {
                this.doSwitchSafely(stmt);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    @Override
    public Object caseExpressionStatement(ExpressionStatement expStmt) {
        this.validateAndStore(expStmt.getExpression(), this.getCurrentScope());
        return null;
    }

    @Override
    public Object caseFeatureAssignment(FeatureAssignment featAssign) {
        Map<String, Set<IType>> scope = this.getCurrentScope();
        this.validateAndStore(featAssign.getTarget(), scope);
        this.validateAndStore(featAssign.getValue(), scope);
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateFeatureAssignment(featAssign));
        });
        return null;
    }

    @Override
    public Object caseFeatureInsert(FeatureInsert featInsert) {
        Map<String, Set<IType>> scope = this.getCurrentScope();
        this.validateAndStore(featInsert.getTarget(), scope);
        this.validateAndStore(featInsert.getValue(), scope);
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateFeatureInsert(featInsert));
        });
        return null;
    }

    @Override
    public Object caseFeatureRemove(FeatureRemove featRemove) {
        Map<String, Set<IType>> scope = this.getCurrentScope();
        this.validateAndStore(featRemove.getTarget(), scope);
        this.validateAndStore(featRemove.getValue(), scope);
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateFeatureRemove(featRemove));
        });
        return null;
    }

    @Override
    public Object caseForEach(ForEach loop) {
        this.validateAndStore(loop.getCollectionExpression(), this.getCurrentScope());
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateForEach(loop));
        });
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scopes.Scope loopScope = this.scopes.pushNew();){
            loopScope.putTypes(loop.getVariable(), this.getPossibleCollectionTypes(loop.getCollectionExpression()));
            this.doSwitchSafely(loop.getBody());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    @Override
    public Object caseIf(If ifStmt) {
        for (ConditionalBlock cBlock : ifStmt.getBlocks()) {
            this.validateAndStore(cBlock.getCondition(), this.getCurrentScope());
        }
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateIf(ifStmt));
        });
        for (ConditionalBlock cBlock : ifStmt.getBlocks()) {
            Throwable throwable = null;
            Object var5_8 = null;
            try (Scopes.Scope blockScope = this.scopes.pushNew();){
                IValidationResult validRes = this.validations.get(cBlock.getCondition());
                if (validRes != null) {
                    Map vartypes = validRes.getInferredVariableTypes(cBlock.getCondition(), Boolean.valueOf(true));
                    for (Map.Entry vartype : vartypes.entrySet()) {
                        blockScope.putTypes((String)vartype.getKey(), (Set<IType>)((Set)vartype.getValue()));
                    }
                }
                this.doSwitchSafely(cBlock.getBlock());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (ifStmt.getElse() != null) {
            Throwable throwable = null;
            Iterator iterator = null;
            try (Scopes.Scope elseScope = this.scopes.pushNew();){
                HashMap<String, Set> vartypes = new HashMap<String, Set>();
                for (ConditionalBlock cBlock : ifStmt.getBlocks()) {
                    IValidationResult validRes = this.validations.get(cBlock.getCondition());
                    if (validRes == null) continue;
                    Map previousVartypes = validRes.getInferredVariableTypes(cBlock.getCondition(), Boolean.valueOf(false));
                    for (String varName : previousVartypes.keySet()) {
                        Set types = (Set)vartypes.get(varName);
                        if (types == null) {
                            vartypes.put(varName, (Set)previousVartypes.get(varName));
                            continue;
                        }
                        types.addAll((Collection)previousVartypes.get(varName));
                    }
                }
                for (Map.Entry vartype : vartypes.entrySet()) {
                    elseScope.putTypes((String)vartype.getKey(), (Set<IType>)((Set)vartype.getValue()));
                }
                this.doSwitchSafely(ifStmt.getElse());
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        return null;
    }

    @Override
    public Object caseVariableAssignment(VariableAssignment varAssign) {
        this.validateAndStore(varAssign.getValue(), this.getCurrentScope());
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateVariableAssignment(varAssign));
        });
        return null;
    }

    @Override
    public Object caseVariableDeclaration(VariableDeclaration varDecl) {
        if (varDecl.getInitialValue() != null) {
            this.validateAndStore(varDecl.getInitialValue(), this.getCurrentScope());
        }
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateVariableDeclaration(varDecl));
        });
        Scopes.Scope lastScope = this.scopes.getCurrent();
        if (varDecl.getInitialValue() != null) {
            lastScope.putTypes(varDecl.getName(), this.getPossibleTypes(varDecl.getInitialValue()));
        } else {
            IType declaredType = this.convert.toAQL(varDecl.getType());
            lastScope.putTypes(varDecl.getName(), (Set<IType>)Sets.newHashSet((Object[])new IType[]{declaredType}));
        }
        return null;
    }

    @Override
    public Object caseVariableInsert(VariableInsert insert) {
        Map<String, Set<IType>> scope = this.getCurrentScope();
        this.validateAndStore(insert.getValue(), scope);
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateVariableInsert(insert));
        });
        return null;
    }

    @Override
    public Object caseVariableRemove(VariableRemove remove) {
        Map<String, Set<IType>> scope = this.getCurrentScope();
        this.validateAndStore(remove.getValue(), scope);
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateVariableRemove(remove));
        });
        return null;
    }

    @Override
    public Object caseWhile(While loop) {
        this.validateAndStore(loop.getCondition(), this.getCurrentScope());
        this.validators.stream().forEach(validator -> {
            boolean bl = this.msgs.addAll(validator.validateWhile(loop));
        });
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scopes.Scope loopScope = this.scopes.pushNew();){
            IValidationResult validRes = this.validations.get(loop.getCondition());
            if (validRes != null) {
                Map vartypes = validRes.getInferredVariableTypes(loop.getCondition(), Boolean.valueOf(true));
                for (Map.Entry vartype : vartypes.entrySet()) {
                    loopScope.putTypes((String)vartype.getKey(), (Set<IType>)((Set)vartype.getValue()));
                }
            }
            this.doSwitchSafely(loop.getBody());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    private void doSwitchSafely(EObject object) {
        try {
            this.doSwitch(object);
        }
        catch (Exception e) {
            Activator.error("An internal error occurred while validating switching on: " + object, e);
        }
    }

    public Map<String, Set<IType>> getCurrentScope() {
        return this.scopes.getCurrent().getVariableTypes();
    }

    private IValidationResult validateExpression(Expression exp, Map<String, Set<IType>> variableTypes, List<Message> messages) {
        IQueryBuilderEngine.AstResult fakeAst = new IQueryBuilderEngine.AstResult(exp, this.currentModel.getStartPositions(), this.currentModel.getEndPositions(), new ArrayList(), (Diagnostic)new BasicDiagnostic());
        try {
            IValidationResult validationResult = this.expValidator.validate(variableTypes, fakeAst);
            this.msgs.addAll(BaseValidator.toMessages(validationResult, (EObject)exp));
            return validationResult;
        }
        catch (AcceleoQueryValidationException e) {
            InternalError internalError = DiagnosticsFactory.eINSTANCE.createInternalError();
            internalError.setLocation(DiagnosticsFactory.eINSTANCE.createCodeLocation());
            internalError.getLocation().setStartPosition(this.currentModel.getStartPositions().get(exp));
            internalError.getLocation().setEndPosition(this.currentModel.getEndPositions().get(exp));
            internalError.setMessage(e.getMessage());
            internalError.setCause(e);
            internalError.setSource((EObject)exp);
            this.msgs.add(internalError);
            return new ValidationResult(fakeAst);
        }
    }

    private static List<Message> toMessages(IValidationResult validationResult, EObject ast) {
        ArrayList<Message> messages = new ArrayList<Message>(validationResult.getMessages().size());
        for (IValidationMessage validation : validationResult.getMessages()) {
            CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
            location.setStartPosition(validation.getStartPosition());
            location.setEndPosition(validation.getEndPosition());
            AcceleoValidationMessage acceleoMessage = DiagnosticsFactory.eINSTANCE.createAcceleoValidationMessage();
            acceleoMessage.setMessage(validation.getMessage());
            acceleoMessage.setLevel(validation.getLevel());
            acceleoMessage.setLocation(location);
            acceleoMessage.setSource(ast);
            messages.add(acceleoMessage);
        }
        return messages;
    }

    public int getStartOffset(Object obj) {
        Integer start = this.currentModel.getStartPositions().get(obj);
        return start == null ? 0 : start;
    }

    public int getEndOffset(Object obj) {
        Integer start = this.currentModel.getEndPositions().get(obj);
        return start == null ? 0 : start;
    }

    public List<Integer> getLines(Object obj) {
        List<Integer> lines = this.currentModel.getLines(obj);
        if (lines.isEmpty()) {
            lines.add(0);
        }
        return lines;
    }

    public String getSourceFile(Object obj) {
        return this.currentModel.getSourceFile();
    }

    private void validateAndStore(Expression exp, Map<String, Set<IType>> context) {
        IValidationResult expValidation = this.validateExpression(exp, context, this.msgs);
        this.validations.put(exp, expValidation);
        this.validationContexts.put(exp, context);
        if (!this.scopes.isEmpty()) {
            HashSet<IType> inferredTypes = expValidation.getPossibleTypes(exp);
            if (inferredTypes == null) {
                inferredTypes = new HashSet<IType>(0);
            }
            this.scopes.getCurrent().putTypes(exp, inferredTypes);
        }
    }

    public Set<IType> getPossibleTypes(Expression exp) {
        IValidationResult validRes = this.validations.get(exp);
        Set possibleTypes = null;
        if (validRes != null) {
            possibleTypes = validRes.getPossibleTypes(exp);
        } else {
            EObject parent = exp.eContainer();
            while (parent instanceof Expression) {
                if (this.validations.get(parent) != null) {
                    possibleTypes = this.validations.get(parent).getPossibleTypes(exp);
                    break;
                }
                parent = parent.eContainer();
            }
        }
        return possibleTypes == null ? Collections.emptySet() : possibleTypes;
    }

    public Set<IType> getPossibleCollectionTypes(Expression exp) {
        HashSet<IType> res = new HashSet<IType>();
        IValidationResult validRes = this.validations.get(exp);
        if (validRes != null) {
            Set types = validRes.getPossibleTypes(exp);
            for (IType type : types) {
                if (type instanceof AbstractCollectionType) {
                    res.add(((AbstractCollectionType)type).getCollectionType());
                    continue;
                }
                res.add(type);
            }
        }
        return res;
    }

    public List<ExtendedClass> findExtensions(EClass realType) {
        return this.allModels.stream().flatMap(m -> ((ModelUnit)m.getRoot()).getClassExtensions().stream()).filter(xtdCls -> xtdCls.getBaseClass() != null).filter(xtdCls -> xtdCls.getBaseClass().isSuperTypeOf(realType)).collect(Collectors.toList());
    }

    public IQueryEnvironment getQryEnv() {
        return this.qryEnv;
    }

    public Method getContainingOperation(Statement statement) {
        EObject parent = statement.eContainer();
        while (parent != null && !(parent instanceof Method)) {
            parent = parent.eContainer();
        }
        return (Method)parent;
    }

    public Map<String, Set<IType>> getValidationContext(Expression exp) {
        Map<String, Set<IType>> res = this.validationContexts.get(exp);
        if (res != null) {
            return res;
        }
        return new HashMap<String, Set<IType>>();
    }

    public Map<String, Set<IType>> getValidationContext(Block block) {
        Scopes.Scope res = this.blockContexts.get(block);
        if (res != null) {
            return res.getVariableTypes();
        }
        return new HashMap<String, Set<IType>>();
    }
}

