/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.site.P2Utils;

public class PluginPathFinder {
    private static final String DROPINS = "dropins";
    private static final String LINK = ".link";
    private static final String ECLIPSE = "eclipse";

    private static String getSitePath(String platformHome, File linkFile, boolean features) {
        String prefix = new Path(platformHome).removeLastSegments(1).toString();
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (FileInputStream fis = new FileInputStream(linkFile);){
                properties.load(fis);
                String path = properties.getProperty("path");
                if (path != null) {
                    if (!new Path(path).isAbsolute()) {
                        path = String.valueOf(prefix) + '/' + path;
                    }
                    path = String.valueOf(path) + "/eclipse/";
                    path = features ? String.valueOf(path) + "features" : String.valueOf(path) + "plugins";
                    if (new File(path).exists()) {
                        return path;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private static File[] getSites(String platformHome, boolean features) {
        File[] linkFiles;
        ArrayList<File> sites = new ArrayList<File>();
        File file = new File(platformHome, features ? "features" : "plugins");
        if (!features && !file.exists()) {
            file = new File(platformHome);
        }
        if (file.exists()) {
            sites.add(file);
        }
        if ((linkFiles = new File(String.valueOf(platformHome) + '/' + "links").listFiles()) != null) {
            File[] fileArray = linkFiles;
            int n = linkFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File linkFile = fileArray[n2];
                String path = PluginPathFinder.getSitePath(platformHome, linkFile, features);
                if (path != null) {
                    sites.add(new File(path));
                }
                ++n2;
            }
        }
        return sites.toArray(new File[sites.size()]);
    }

    private static List<File> getDropins(String platformHome, boolean features) {
        File[] contents;
        File dropins = new File(platformHome, DROPINS);
        if (!dropins.exists()) {
            return Collections.emptyList();
        }
        ArrayList<File> sites = new ArrayList<File>();
        ArrayList<File> results = new ArrayList<File>();
        File[] fileArray = contents = dropins.listFiles();
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            File content = fileArray[n2];
            if (content.isFile()) {
                if (content.getName().endsWith(LINK)) {
                    String path = PluginPathFinder.getSitePath(platformHome, content, features);
                    if (path != null) {
                        sites.add(new File(path));
                    }
                } else {
                    results.add(content);
                }
            } else if (content.isDirectory() && content.getName().equals(features ? "features" : "plugins")) {
                results.addAll(Arrays.asList(content.listFiles()));
            } else {
                File temp = new File(content, features ? "features" : "plugins");
                if (temp.isDirectory()) {
                    sites.add(temp);
                } else {
                    temp = new File(content, ECLIPSE + File.separator + (features ? "features" : "plugins"));
                    if (temp.isDirectory()) {
                        sites.add(temp);
                    } else {
                        results.add(content);
                    }
                }
            }
            ++n2;
        }
        results.addAll(PluginPathFinder.scanLocations(sites.toArray(new File[sites.size()])));
        return results;
    }

    public static File[] getFeaturePaths(String platformHome) {
        return PluginPathFinder.getPaths(platformHome, true, false);
    }

    public static File[] getPluginPaths(String platformHome, boolean filterP2Base) {
        return PluginPathFinder.getPaths(platformHome, false, filterP2Base);
    }

    public static File[] getPluginPaths(String platformHome) {
        return PluginPathFinder.getPaths(platformHome, false, false);
    }

    public static File[] getPaths(String platformHome, boolean features, boolean filterP2Base) {
        URL[] urls;
        if (filterP2Base && (urls = P2Utils.readBundlesTxt(platformHome)) != null && urls.length > 0) {
            return Utils.asFile(urls);
        }
        List<File> list = PluginPathFinder.scanLocations(PluginPathFinder.getSites(platformHome, features));
        list.addAll(PluginPathFinder.getDropins(platformHome, features));
        return Utils.asFile(list);
    }

    private static List<File> scanLocations(File[] sites) {
        ArrayList<File> result = new ArrayList<File>();
        File[] fileArray = sites;
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            File[] children;
            File site = fileArray[n2];
            if (site != null && site.exists() && (children = site.listFiles()) != null) {
                result.addAll(Arrays.asList(children));
            }
            ++n2;
        }
        return result;
    }
}

