/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Visibility implements Enumerator
{
    VISIBLE(0, "visible", "visible"),
    HIDDEN(1, "hidden", "hidden"),
    COLLAPSE(2, "collapse", "collapse"),
    INHERIT(3, "inherit", "inherit");

    public static final int VISIBLE_VALUE = 0;
    public static final int HIDDEN_VALUE = 1;
    public static final int COLLAPSE_VALUE = 2;
    public static final int INHERIT_VALUE = 3;
    private static final Visibility[] VALUES_ARRAY;
    public static final List<Visibility> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Visibility[]{VISIBLE, HIDDEN, COLLAPSE, INHERIT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Visibility get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Visibility result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Visibility getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Visibility result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Visibility get(int value) {
        switch (value) {
            case 0: {
                return VISIBLE;
            }
            case 1: {
                return HIDDEN;
            }
            case 2: {
                return COLLAPSE;
            }
            case 3: {
                return INHERIT;
            }
        }
        return null;
    }

    private Visibility(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

