/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext_ng.internal;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.Triple;
import org.eclipse.fx.core.geom.Size;
import org.eclipse.fx.core.text.TextUtil;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.styledtext_ng.StyledLineRenderer;

public class SingleCharStyledLineRenderer
implements StyledLineRenderer {
    private final LayoutPane node;
    private final int tabAdvance = 4;
    private int[] tabPositions;
    private char[] renderedText = new char[0];
    private char[] originalText = new char[0];
    double h;
    double w;
    List<TextNode> currentNodes = new ArrayList<TextNode>();
    private Font normal;
    private Font bold;
    private Font italic;
    private Font boldItalic;
    private RangeSet<Integer> boldRange = TreeRangeSet.create();
    private RangeSet<Integer> italicRange = TreeRangeSet.create();
    private List<PaintRange> paintRanges = new ArrayList<PaintRange>();
    private boolean combinedAction;
    private int flag = 0;
    private static final int FONTS = 1;
    private static final int FILL = 2;

    public SingleCharStyledLineRenderer() {
        this.node = new LayoutPane(this);
    }

    @Override
    public void setVisibleRange(double minX, double maxX) {
    }

    @Override
    public void setFont(String family, double size) {
        this.normal = Font.font((String)family, (double)size);
        this.bold = Font.font((String)family, (FontWeight)FontWeight.BOLD, (double)size);
        this.italic = Font.font((String)family, (FontPosture)FontPosture.ITALIC, (double)size);
        this.boldItalic = Font.font((String)family, (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.ITALIC, (double)size);
        Size dim = Util.getSize(this.normal, 'A');
        this.w = dim.width;
        this.h = dim.height;
        this.rebuildFonts();
        this.node.requestLayout();
    }

    @Override
    public Subscription setBold(org.eclipse.fx.core.Range r) {
        Range range = Range.closed((Comparable)Integer.valueOf(r.start), (Comparable)Integer.valueOf(r.end - 1));
        this.boldRange.add(range);
        this.rebuildFonts();
        return () -> {
            this.boldRange.remove(range);
            this.rebuildFonts();
        };
    }

    @Override
    public Subscription setItalic(org.eclipse.fx.core.Range r) {
        Range range = Range.closed((Comparable)Integer.valueOf(r.start), (Comparable)Integer.valueOf(r.end - 1));
        this.italicRange.add(range);
        this.rebuildFonts();
        return () -> {
            this.italicRange.remove(range);
            this.rebuildFonts();
        };
    }

    @Override
    public Subscription setForeground(Paint paint, org.eclipse.fx.core.Range r) {
        PaintRange range = new PaintRange(paint, (Range<Integer>)Range.closed((Comparable)Integer.valueOf(r.start), (Comparable)Integer.valueOf(r.end - 1)));
        this.paintRanges.add(range);
        this.rebuildFill();
        return () -> {
            this.paintRanges.remove(range);
            this.rebuildFill();
        };
    }

    @Override
    public void setText(char[] text) {
        Triple rv = TextUtil.replaceTabBySpace((char[])text, (int)4);
        this.tabPositions = (int[])rv.value3;
        this.originalText = text;
        this.renderedText = ((int[])rv.value3).length == 0 ? text : (char[])rv.value1;
        this.rebuild();
    }

    private Paint getPaint(int index) {
        for (PaintRange r : this.paintRanges) {
            if (!r.range.contains((Comparable)Integer.valueOf(index))) continue;
            return r.paint;
        }
        return Color.BLACK;
    }

    private void rebuild() {
        ArrayList<TextNode> l = new ArrayList<TextNode>(this.originalText.length);
        int i = 0;
        while (i < this.renderedText.length) {
            if (this.renderedText[i] != ' ') {
                TextNode node = new TextNode(i, this.renderedText[i]);
                node.setFontData(this.boldRange.contains((Comparable)Integer.valueOf(i)), this.italicRange.contains((Comparable)Integer.valueOf(i)));
                node.setFill(this.getPaint(i));
                this.updateFont(node);
                l.add(node);
            }
            ++i;
        }
        this.currentNodes = l;
        this.node.getChildren().setAll(this.currentNodes);
        this.node.requestLayout();
    }

    private void rebuildFonts() {
        if (this.combinedAction) {
            this.flag |= 1;
        } else {
            for (TextNode t : this.currentNodes) {
                t.setFontData(this.boldRange.contains((Comparable)Integer.valueOf(t.index)), this.italicRange.contains((Comparable)Integer.valueOf(t.index)));
            }
            this.currentNodes.forEach(this::updateFont);
        }
    }

    private void rebuildFill() {
        if (this.combinedAction) {
            this.flag |= 2;
        } else {
            this.currentNodes.forEach(n -> n.setFill(this.getPaint(n.index)));
        }
    }

    @Override
    public void combinedAction(Runnable r) {
        this.combinedAction = true;
        try {
            r.run();
        }
        finally {
            this.combinedAction = false;
        }
        if ((this.flag & 1) == 1) {
            this.rebuildFonts();
        }
        if ((this.flag & 2) == 2) {
            this.rebuildFill();
        }
    }

    private void updateFont(TextNode node) {
        if (node.bold && node.italic) {
            node.setFont(this.boldItalic);
        } else if (node.bold) {
            node.setFont(this.bold);
        } else if (node.italic) {
            node.setFont(this.italic);
        } else {
            node.setFont(this.normal);
        }
    }

    @Override
    public void clearStyles() {
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    public double getCharWidth() {
        return this.w;
    }

    public double getCharHeight() {
        return this.h;
    }

    public double getWidth() {
        return this.w * (double)this.renderedText.length;
    }

    public double getHeight() {
        return this.h;
    }

    static class LayoutPane
    extends Region {
        private SingleCharStyledLineRenderer r;

        public LayoutPane(SingleCharStyledLineRenderer r) {
            this.r = r;
        }

        public ObservableList<Node> getChildren() {
            return super.getChildren();
        }

        protected void layoutChildren() {
            double w = this.r.getCharWidth();
            double h = this.r.getCharHeight();
            this.r.currentNodes.forEach(n -> n.resizeRelocate((double)n.index * w, 0.0, w, h));
        }

        protected double computeMinWidth(double height) {
            return this.r.getWidth();
        }

        protected double computeMinHeight(double width) {
            System.err.println("MIn: " + this.getHeight());
            return this.r.getCharHeight();
        }

        protected double computePrefHeight(double width) {
            System.err.println("PREF: " + this.getHeight());
            return this.r.getCharHeight();
        }

        protected double computePrefWidth(double height) {
            return this.r.getWidth();
        }

        protected double computeMaxHeight(double width) {
            return this.r.getCharHeight();
        }

        protected double computeMaxWidth(double height) {
            return this.r.getWidth();
        }
    }

    static class PaintRange {
        final Paint paint;
        final Range<Integer> range;

        public PaintRange(Paint paint, Range<Integer> range) {
            this.paint = paint;
            this.range = range;
        }
    }

    static class TextNode
    extends Text {
        final int index;
        boolean bold;
        boolean italic;

        public TextNode(int index, char c) {
            super(TextUtil.toString((char)c));
            this.setManaged(false);
            this.index = index;
        }

        public void setFontData(boolean bold, boolean italic) {
            this.bold = bold;
            this.italic = italic;
        }
    }
}

