/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.converter;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fx.formats.svg.converter.Colors;
import org.eclipse.fx.formats.svg.svg.ContentElement;
import org.eclipse.fx.formats.svg.svg.CoreAttributes;
import org.eclipse.fx.formats.svg.svg.Fill_rule;
import org.eclipse.fx.formats.svg.svg.FilterPrimitiveElement;
import org.eclipse.fx.formats.svg.svg.PresentationAttributes;
import org.eclipse.fx.formats.svg.svg.SpreadMethod;
import org.eclipse.fx.formats.svg.svg.Stroke_linecap;
import org.eclipse.fx.formats.svg.svg.Stroke_linejoin;
import org.eclipse.fx.formats.svg.svg.SvgCircleElement;
import org.eclipse.fx.formats.svg.svg.SvgClipPathElement;
import org.eclipse.fx.formats.svg.svg.SvgDefsElement;
import org.eclipse.fx.formats.svg.svg.SvgElement;
import org.eclipse.fx.formats.svg.svg.SvgEllipseElement;
import org.eclipse.fx.formats.svg.svg.SvgFeGaussianBlurElement;
import org.eclipse.fx.formats.svg.svg.SvgFilterElement;
import org.eclipse.fx.formats.svg.svg.SvgGElement;
import org.eclipse.fx.formats.svg.svg.SvgImageElement;
import org.eclipse.fx.formats.svg.svg.SvgLinearGradientElement;
import org.eclipse.fx.formats.svg.svg.SvgPackage;
import org.eclipse.fx.formats.svg.svg.SvgPathElement;
import org.eclipse.fx.formats.svg.svg.SvgPolygonElement;
import org.eclipse.fx.formats.svg.svg.SvgPolylineElement;
import org.eclipse.fx.formats.svg.svg.SvgRadialGradientElement;
import org.eclipse.fx.formats.svg.svg.SvgRectElement;
import org.eclipse.fx.formats.svg.svg.SvgStopElement;
import org.eclipse.fx.formats.svg.svg.SvgSvgElement;
import org.eclipse.fx.formats.svg.svg.SvgUseElement;
import org.eclipse.fx.formats.svg.svg.XLinkAttributes;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class FXMLConverter {
    private SvgSvgElement rootElement;

    public FXMLConverter(SvgSvgElement rootElement) {
        this.rootElement = rootElement;
    }

    public CharSequence generate() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence content = this.handle(this.rootElement);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"<?import java.lang.*?>");
        _builder.newLine();
        _builder.append((Object)"<?import javafx.scene.*?>");
        _builder.newLine();
        _builder.append((Object)"<?import javafx.scene.shape.*?>");
        _builder.newLine();
        _builder.append((Object)"<?import javafx.scene.paint.*?>");
        _builder.newLine();
        _builder.append((Object)"<?import javafx.scene.image.*?>");
        _builder.newLine();
        _builder.append((Object)"<?import javafx.scene.transform.*?>");
        _builder.newLine();
        _builder.append((Object)"<?import javafx.scene.effect.*?>");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)content, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _handle(EObject o) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<!-- Unhandled type '");
        EClass _eClass = o.eClass();
        String _name = _eClass.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"' -->");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _handle(SvgLinearGradientElement o) {
        return null;
    }

    protected CharSequence _handle(SvgRadialGradientElement o) {
        return null;
    }

    protected CharSequence _handle(SvgSvgElement element) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<Group id='_root' xmlns:fx=\"http://javafx.com/fxml\" xmlns:fxsvg=\"http://efxclipse.org/fxml-svg\">");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _class_ = element.getClass_();
        CharSequence _handleStyleClassAttributes = this.handleStyleClassAttributes(_class_);
        _builder.append((Object)_handleStyleClassAttributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<children>");
        _builder.newLine();
        EList _children = element.getChildren();
        for (SvgElement o : _children) {
            _builder.append((Object)"\t\t");
            CharSequence _handle = this.handle(o);
            _builder.append((Object)_handle, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"</children>");
        _builder.newLine();
        _builder.append((Object)"</Group>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _handle(SvgDefsElement element) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<fx:define>");
        _builder.newLine();
        EList _children = element.getChildren();
        for (SvgElement o : _children) {
            _builder.append((Object)"\t");
            CharSequence _handle = this.handle(o);
            _builder.append((Object)_handle, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"</fx:define>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence handleGradient(SvgLinearGradientElement element, Double opacity) {
        boolean _notEquals_5;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        AffineTransform _createAffineTransform;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<LinearGradient");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _gradientTransform = element.getGradientTransform();
        AffineTransform t = _createAffineTransform = this.createAffineTransform(_gradientTransform);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _x1 = element.getX1();
        double x1 = this.parseCoordinate(_x1);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _y1 = element.getY1();
        double y1 = this.parseCoordinate(_y1);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _x2 = element.getX2();
        double x2 = this.parseCoordinate(_x2);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _y2 = element.getY2();
        double y2 = this.parseCoordinate(_y2);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        String _x1_1 = element.getX1();
        boolean bl = _notEquals = !Objects.equal((Object)_x1_1, null);
        if (_notEquals) {
            _builder.append((Object)"startX=\"");
            Point2D.Double _double = new Point2D.Double(x1, y1);
            Point2D _transform = t.transform(_double, null);
            double _x = _transform.getX();
            _builder.append((Object)_x, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _y1_1 = element.getY1();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_y1_1, null);
        if (_notEquals_1) {
            _builder.append((Object)"startY=\"");
            Point2D.Double _double_1 = new Point2D.Double(x1, y1);
            Point2D _transform_1 = t.transform(_double_1, null);
            double _y = _transform_1.getY();
            _builder.append((Object)_y, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _x2_1 = element.getX2();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_x2_1, null);
        if (_notEquals_2) {
            _builder.append((Object)"endX=\"");
            Point2D.Double _double_2 = new Point2D.Double(x2, y2);
            Point2D _transform_2 = t.transform(_double_2, null);
            double _x_1 = _transform_2.getX();
            _builder.append((Object)_x_1, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _y2_1 = element.getY2();
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)_y2_1, null);
        if (_notEquals_3) {
            _builder.append((Object)"endY=\"");
            Point2D.Double _double_3 = new Point2D.Double(x2, y2);
            Point2D _transform_3 = t.transform(_double_3, null);
            double _y_1 = _transform_3.getY();
            _builder.append((Object)_y_1, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        SpreadMethod _spreadMethod = element.getSpreadMethod();
        boolean bl5 = _notEquals_4 = !Objects.equal((Object)((Object)_spreadMethod), (Object)((Object)SpreadMethod.PAD));
        if (_notEquals_4) {
            _builder.append((Object)"cycleMethod=\"");
            SpreadMethod _spreadMethod_1 = element.getSpreadMethod();
            String _fx = this.toFx(_spreadMethod_1);
            _builder.append((Object)_fx, "\t");
            _builder.append((Object)"\"");
        } else {
            _builder.append((Object)"cycleMethod=\"NO_CYCLE\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"proportional=\"false\">");
        _builder.newLine();
        _builder.append((Object)"\t");
        ContentElement<?> owner = this.resolveGradientStopElement(element);
        _builder.newLineIfNotEmpty();
        boolean bl6 = _notEquals_5 = !Objects.equal(owner, null);
        if (_notEquals_5) {
            _builder.append((Object)"\t");
            _builder.append((Object)"<stops>");
            _builder.newLine();
            EList<?> _children = owner.getChildren();
            Iterable _filter = Iterables.filter(_children, SvgStopElement.class);
            for (SvgStopElement o : _filter) {
                _builder.append((Object)"\t");
                CharSequence _handleStop = this.handleStop(o, opacity);
                _builder.append((Object)_handleStop, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"</stops>");
            _builder.newLine();
        }
        _builder.append((Object)"</LinearGradient>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence handleGradient(SvgRadialGradientElement element, Double opacity) {
        boolean _notEquals_8;
        boolean _notEquals_7;
        String _fy_2;
        boolean _notEquals_6;
        boolean _notEquals_5;
        String _fy_1;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        AffineTransform _createAffineTransform;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<RadialGradient");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _gradientTransform = element.getGradientTransform();
        AffineTransform t = _createAffineTransform = this.createAffineTransform(_gradientTransform);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _cx = element.getCx();
        double cx = this.parseCoordinate(_cx);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _cy = element.getCy();
        double cy = this.parseCoordinate(_cy);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _fx = element.getFx();
        double fx = this.parseCoordinate(_fx);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _fy = element.getFy();
        double fy = this.parseCoordinate(_fy);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        String _cx_1 = element.getCx();
        boolean bl = _notEquals = !Objects.equal((Object)_cx_1, null);
        if (_notEquals) {
            _builder.append((Object)"centerX=\"");
            Point2D.Double _double = new Point2D.Double(cx, cy);
            Point2D _transform = t.transform(_double, null);
            double _x = _transform.getX();
            _builder.append((Object)_x, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _cy_1 = element.getCy();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_cy_1, null);
        if (_notEquals_1) {
            _builder.append((Object)"centerY=\"");
            Point2D.Double _double_1 = new Point2D.Double(cx, cy);
            Point2D _transform_1 = t.transform(_double_1, null);
            double _y = _transform_1.getY();
            _builder.append((Object)_y, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _r = element.getR();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_r, null);
        if (_notEquals_2) {
            _builder.append((Object)"radius=\"");
            String _r_1 = element.getR();
            double _parseLength = this.parseLength(_r_1);
            double _scaleX = t.getScaleX();
            double _multiply = _parseLength * _scaleX;
            _builder.append((Object)_multiply, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        boolean _or = false;
        String _fx_1 = element.getFx();
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)_fx_1, null);
        _or = _notEquals_3 ? true : (_notEquals_4 = !Objects.equal((Object)(_fy_1 = element.getFy()), null));
        if (_or) {
            _builder.append((Object)"focusDistance=\"");
            double _calculateFocusDistance = this.calculateFocusDistance(t, cx, cy, fx, fy);
            _builder.append((Object)_calculateFocusDistance, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        boolean _or_1 = false;
        String _fx_2 = element.getFx();
        boolean bl5 = _notEquals_5 = !Objects.equal((Object)_fx_2, null);
        _or_1 = _notEquals_5 ? true : (_notEquals_6 = !Objects.equal((Object)(_fy_2 = element.getFy()), null));
        if (_or_1) {
            _builder.append((Object)"focusAngle=\"");
            double _calculateFocusAngle = this.calculateFocusAngle(t, cx, cy, fx, fy);
            _builder.append((Object)_calculateFocusAngle, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        SpreadMethod _spreadMethod = element.getSpreadMethod();
        boolean bl6 = _notEquals_7 = !Objects.equal((Object)((Object)_spreadMethod), (Object)((Object)SpreadMethod.PAD));
        if (_notEquals_7) {
            _builder.append((Object)"cycleMethod=\"");
            SpreadMethod _spreadMethod_1 = element.getSpreadMethod();
            String _fx_3 = this.toFx(_spreadMethod_1);
            _builder.append((Object)_fx_3, "\t");
            _builder.append((Object)"\"");
        } else {
            _builder.append((Object)"cycleMethod=\"NO_CYCLE\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"proportional=\"false\">");
        _builder.newLine();
        _builder.append((Object)"\t");
        ContentElement<?> owner = this.resolveGradientStopElement(element);
        _builder.newLineIfNotEmpty();
        boolean bl7 = _notEquals_8 = !Objects.equal(owner, null);
        if (_notEquals_8) {
            _builder.append((Object)"\t");
            _builder.append((Object)"<stops>");
            _builder.newLine();
            EList<?> _children = owner.getChildren();
            Iterable _filter = Iterables.filter(_children, SvgStopElement.class);
            for (SvgStopElement o : _filter) {
                _builder.append((Object)"\t");
                CharSequence _handleStop = this.handleStop(o, opacity);
                _builder.append((Object)_handleStop, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"</stops>");
            _builder.newLine();
        }
        _builder.append((Object)"</RadialGradient>");
        _builder.newLine();
        return _builder;
    }

    public AffineTransform createAffineTransform(String transformSpec) {
        boolean _equals = Objects.equal((Object)transformSpec, null);
        if (_equals) {
            return new AffineTransform();
        }
        int _indexOf = transformSpec.indexOf("(");
        int _plus = _indexOf + 1;
        int _indexOf_1 = transformSpec.indexOf(")");
        String params = transformSpec.substring(_plus, _indexOf_1);
        boolean _startsWith = transformSpec.startsWith("matrix");
        if (_startsWith) {
            String[] parts = params.split("\\s*,\\s*|\\s+");
            String _get = parts[0];
            double _parseDouble = Double.parseDouble(_get);
            String _get_1 = parts[1];
            double _parseDouble_1 = Double.parseDouble(_get_1);
            String _get_2 = parts[2];
            double _parseDouble_2 = Double.parseDouble(_get_2);
            String _get_3 = parts[3];
            double _parseDouble_3 = Double.parseDouble(_get_3);
            String _get_4 = parts[4];
            double _parseDouble_4 = Double.parseDouble(_get_4);
            String _get_5 = parts[5];
            double _parseDouble_5 = Double.parseDouble(_get_5);
            AffineTransform rv = new AffineTransform(_parseDouble, _parseDouble_1, _parseDouble_2, _parseDouble_3, _parseDouble_4, _parseDouble_5);
            return rv;
        }
        boolean _startsWith_1 = transformSpec.startsWith("translate");
        if (_startsWith_1) {
            String[] parts_1 = params.split("\\s*,\\s*|\\s+");
            AffineTransform rv_1 = new AffineTransform();
            String _get_6 = parts_1[0];
            double _parseDouble_6 = Double.parseDouble(_get_6);
            String _get_7 = parts_1[1];
            double _parseDouble_7 = Double.parseDouble(_get_7);
            rv_1.translate(_parseDouble_6, _parseDouble_7);
            return rv_1;
        }
        boolean _startsWith_2 = transformSpec.startsWith("scale");
        if (_startsWith_2) {
            String[] parts_2 = params.split("\\s*,\\s*|\\s+");
            AffineTransform rv_2 = new AffineTransform();
            String _get_8 = parts_2[0];
            double _parseDouble_8 = Double.parseDouble(_get_8);
            String _get_9 = parts_2[1];
            double _parseDouble_9 = Double.parseDouble(_get_9);
            rv_2.scale(_parseDouble_8, _parseDouble_9);
            return rv_2;
        }
        boolean _startsWith_3 = transformSpec.startsWith("rotate");
        if (_startsWith_3) {
            String[] parts_3 = params.split("\\s*,\\s*|\\s+");
            AffineTransform rv_3 = new AffineTransform();
            String _get_10 = parts_3[0];
            double _parseDouble_10 = Double.parseDouble(_get_10);
            String _get_11 = parts_3[1];
            double _parseDouble_11 = Double.parseDouble(_get_11);
            String _get_12 = parts_3[2];
            double _parseDouble_12 = Double.parseDouble(_get_12);
            rv_3.rotate(_parseDouble_10, _parseDouble_11, _parseDouble_12);
            return rv_3;
        }
        return new AffineTransform();
    }

    public double calculateFocusDistance(AffineTransform transform, double cx, double cy, double fx, double fy) {
        if (fx == cx && fy == cy) {
            return 0.0;
        }
        Point2D.Double _double = new Point2D.Double(cx, cy);
        Point2D c = transform.transform(_double, null);
        Point2D.Double _double_1 = new Point2D.Double(fx, fy);
        Point2D f = transform.transform(_double_1, null);
        double _x = c.getX();
        double _x_1 = f.getX();
        double _minus = _x - _x_1;
        double _pow = Math.pow(_minus, 2.0);
        double _y = c.getY();
        double _y_1 = f.getY();
        double _minus_1 = _y - _y_1;
        double _pow_1 = Math.pow(_minus_1, 2.0);
        double _plus = _pow + _pow_1;
        return Math.sqrt(_plus);
    }

    public double calculateFocusAngle(AffineTransform transform, double cx, double cy, double fx, double fy) {
        if (fx == cx && fy == cy) {
            return 0.0;
        }
        Point2D.Double _double = new Point2D.Double(cx, cy);
        Point2D c = transform.transform(_double, null);
        Point2D.Double _double_1 = new Point2D.Double(fx, fy);
        Point2D f = transform.transform(_double_1, null);
        double _y = c.getY();
        double _y_1 = f.getY();
        double _minus = _y - _y_1;
        double _pow = Math.pow(_minus, 2.0);
        double _x = c.getX();
        double _x_1 = f.getX();
        double _minus_1 = _x - _x_1;
        double _pow_1 = Math.pow(_minus_1, 2.0);
        double _divide = _pow / _pow_1;
        return Math.atan(_divide);
    }

    public ContentElement<?> resolveGradientStopElement(SvgElement element) {
        if (element instanceof ContentElement) {
            ContentElement rv = (ContentElement)((Object)element);
            EList _children = rv.getChildren();
            Iterable _filter = Iterables.filter(_children, SvgStopElement.class);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter);
            if (_isEmpty) {
                if (element instanceof XLinkAttributes) {
                    boolean _notEquals;
                    XLinkAttributes v = (XLinkAttributes)((Object)element);
                    SvgElement _resolvedInstance = v.getResolvedInstance();
                    boolean bl = _notEquals = !Objects.equal((Object)_resolvedInstance, null);
                    if (_notEquals) {
                        SvgElement _resolvedInstance_1 = v.getResolvedInstance();
                        return this.resolveGradientStopElement(_resolvedInstance_1);
                    }
                }
            } else {
                return rv;
            }
        }
        return null;
    }

    public SvgElement resolveElement(String id) {
        TreeIterator _allContents = EcoreUtil.getAllContents((EObject)this.rootElement, (boolean)true);
        UnmodifiableIterator treeIt = Iterators.filter((Iterator)_allContents, SvgElement.class);
        while (treeIt.hasNext()) {
            boolean _notEquals;
            SvgElement o = (SvgElement)treeIt.next();
            if (o instanceof CoreAttributes) {
                String _id = ((CoreAttributes)((Object)o)).getId();
                boolean _equals = id.equals(_id);
                if (!_equals) continue;
                return o;
            }
            SvgElement eo = o;
            EClass _eClass = eo.eClass();
            EStructuralFeature f = _eClass.getEStructuralFeature("id");
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)f, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean _equals_1;
                Object _eGet = eo.eGet(f);
                _and = _equals_1 = id.equals(_eGet);
            }
            if (!_and) continue;
            return o;
        }
        return null;
    }

    public CharSequence handleStop(SvgStopElement element, Double opacity) {
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<Stop");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _offset = element.getOffset();
        boolean bl = _notEquals = !Objects.equal((Object)_offset, null);
        if (_notEquals) {
            _builder.append((Object)"offset=\"");
            String _offset_1 = element.getOffset();
            double _parsePercentage = this.parsePercentage(_offset_1);
            _builder.append((Object)_parsePercentage, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)">");
        _builder.newLine();
        String _stop_opacity = element.getStop_opacity();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_stop_opacity, null);
        if (_notEquals_1) {
            boolean _notEquals_2;
            _builder.append((Object)"\t");
            _builder.append((Object)"<color>");
            _builder.newLine();
            boolean bl3 = _notEquals_2 = !Objects.equal((Object)opacity, null);
            if (_notEquals_2) {
                boolean _notEquals_3;
                String _stop_color = element.getStop_color();
                boolean bl4 = _notEquals_3 = !Objects.equal((Object)_stop_color, null);
                if (_notEquals_3) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    String _stop_color_1 = element.getStop_color();
                    String _stop_opacity_1 = element.getStop_opacity();
                    double _parseDouble = Double.parseDouble(_stop_opacity_1);
                    double _multiply = _parseDouble * opacity;
                    CharSequence _fillPaint = this.fillPaint(_stop_color_1, _multiply);
                    _builder.append((Object)_fillPaint, "\t\t");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<opacity>");
                    String _stop_opacity_2 = element.getStop_opacity();
                    double _parseDouble_1 = Double.parseDouble(_stop_opacity_2);
                    double _multiply_1 = _parseDouble_1 * opacity;
                    _builder.append((Object)_multiply_1, "\t\t");
                    _builder.append((Object)"</opacity>");
                    _builder.newLineIfNotEmpty();
                }
            } else {
                boolean _notEquals_4;
                String _stop_color_2 = element.getStop_color();
                boolean bl5 = _notEquals_4 = !Objects.equal((Object)_stop_color_2, null);
                if (_notEquals_4) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    String _stop_color_3 = element.getStop_color();
                    String _stop_opacity_3 = element.getStop_opacity();
                    double _parseDouble_2 = Double.parseDouble(_stop_opacity_3);
                    CharSequence _fillPaint_1 = this.fillPaint(_stop_color_3, _parseDouble_2);
                    _builder.append((Object)_fillPaint_1, "\t\t");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<opacity>");
                    String _stop_opacity_4 = element.getStop_opacity();
                    _builder.append((Object)_stop_opacity_4, "\t\t");
                    _builder.append((Object)"</opacity>");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"</color>");
            _builder.newLine();
        } else {
            boolean _notEquals_5;
            String _stop_color_4 = element.getStop_color();
            boolean bl6 = _notEquals_5 = !Objects.equal((Object)_stop_color_4, null);
            if (_notEquals_5) {
                boolean _notEquals_6;
                _builder.append((Object)"\t");
                _builder.append((Object)"<color>");
                _builder.newLine();
                boolean bl7 = _notEquals_6 = !Objects.equal((Object)opacity, null);
                if (_notEquals_6) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    String _stop_color_5 = element.getStop_color();
                    CharSequence _fillPaint_2 = this.fillPaint(_stop_color_5, opacity);
                    _builder.append((Object)_fillPaint_2, "\t\t");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    String _stop_color_6 = element.getStop_color();
                    CharSequence _fillPaint_3 = this.fillPaint(_stop_color_6);
                    _builder.append((Object)_fillPaint_3, "\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"</color>");
                _builder.newLine();
            }
        }
        _builder.append((Object)"</Stop>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _handle(SvgImageElement element) {
        String _clip_path_2;
        String _trim_2;
        boolean _equals_1;
        boolean _not;
        String _clip_path_1;
        String _trim_1;
        int _length_1;
        boolean _greaterThan;
        boolean _notEquals_5;
        String _filter;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<ImageView");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _x = element.getX();
        boolean bl = _notEquals = !Objects.equal((Object)_x, null);
        if (_notEquals) {
            _builder.append((Object)"x=\"");
            String _x_1 = element.getX();
            double _parseLength = this.parseLength(_x_1);
            _builder.append((Object)_parseLength, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _y = element.getY();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_y, null);
        if (_notEquals_1) {
            _builder.append((Object)"y=\"");
            String _y_1 = element.getY();
            double _parseLength_1 = this.parseLength(_y_1);
            _builder.append((Object)_parseLength_1, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)">");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _class_ = element.getClass_();
        CharSequence _handleStyleClassAttributes = this.handleStyleClassAttributes(_class_);
        _builder.append((Object)_handleStyleClassAttributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<Image");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"url=\"");
        String _xlink__href = element.getXlink__href();
        _builder.append((Object)_xlink__href, "\t\t");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"/>");
        _builder.newLine();
        String _transform = element.getTransform();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_transform, null);
        if (_notEquals_2) {
            _builder.append((Object)"\t");
            _builder.append((Object)"<transforms>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            String _transform_1 = element.getTransform();
            String _handleTransform = this.handleTransform(_transform_1);
            _builder.append((Object)_handleTransform, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"</transforms>");
            _builder.newLine();
        }
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)(_filter = element.getFilter()), null);
        if (_notEquals_3) {
            boolean _notEquals_4;
            _builder.append((Object)"\t");
            String _filter_1 = element.getFilter();
            String _filter_2 = element.getFilter();
            int _length = _filter_2.length();
            int _minus = _length - 1;
            String _substring = _filter_1.substring(5, _minus);
            String _trim = _substring.trim();
            SvgElement _resolveElement = this.resolveElement(_trim);
            SvgFilterElement e = (SvgFilterElement)_resolveElement;
            _builder.newLineIfNotEmpty();
            boolean bl5 = _notEquals_4 = !Objects.equal((Object)e, null);
            if (_notEquals_4) {
                boolean _equals;
                EList _children = e.getChildren();
                Iterable _filter_3 = Iterables.filter((Iterable)_children, FilterPrimitiveElement.class);
                int _size = IterableExtensions.size((Iterable)_filter_3);
                boolean bl6 = _equals = _size == 1;
                if (_equals) {
                    _builder.append((Object)"\t");
                    EList _children_1 = e.getChildren();
                    Iterable _filter_4 = Iterables.filter((Iterable)_children_1, FilterPrimitiveElement.class);
                    FilterPrimitiveElement _head = (FilterPrimitiveElement)IterableExtensions.head((Iterable)_filter_4);
                    SvgElement fiElement = (SvgElement)((Object)_head);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<effect>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    CharSequence _handleFilter = this.handleFilter(fiElement);
                    _builder.append((Object)_handleFilter, "\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"</effect>");
                    _builder.newLine();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<!-- Multi filter needs different handling -->");
                    _builder.newLine();
                }
            }
        }
        boolean _and = false;
        boolean _and_1 = false;
        String _clip_path = element.getClip_path();
        boolean bl7 = _notEquals_5 = !Objects.equal((Object)_clip_path, null);
        _and_1 = !_notEquals_5 ? false : (_greaterThan = (_length_1 = (_trim_1 = (_clip_path_1 = element.getClip_path()).trim()).length()) > 0);
        _and = !_and_1 ? false : (_not = !(_equals_1 = (_trim_2 = (_clip_path_2 = element.getClip_path()).trim()).equals("none")));
        if (_and) {
            String _clip_path_5;
            boolean _equals_2;
            boolean _not_1;
            String _transform_3;
            String _trim_3;
            int _length_3;
            boolean _greaterThan_1;
            boolean _notEquals_6;
            _builder.append((Object)"\t");
            _builder.append((Object)"<clip>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            String _clip_path_3 = element.getClip_path();
            String _clip_path_4 = element.getClip_path();
            int _length_2 = _clip_path_4.length();
            int _minus_1 = _length_2 - 1;
            String _substring_1 = _clip_path_3.substring(5, _minus_1);
            SvgElement _resolveElement_1 = this.resolveElement(_substring_1);
            SvgClipPathElement clipElement = (SvgClipPathElement)_resolveElement_1;
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"<Group>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"<children>");
            _builder.newLine();
            EList _children_2 = clipElement.getChildren();
            for (SvgElement e_1 : _children_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t\t");
                CharSequence _handle = this.handle(e_1);
                _builder.append((Object)_handle, "\t\t\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"</children>");
            _builder.newLine();
            boolean _and_2 = false;
            boolean _and_3 = false;
            String _transform_2 = clipElement.getTransform();
            boolean bl8 = _notEquals_6 = !Objects.equal((Object)_transform_2, null);
            _and_3 = !_notEquals_6 ? false : (_greaterThan_1 = (_length_3 = (_trim_3 = (_transform_3 = clipElement.getTransform()).trim()).length()) > 0);
            _and_2 = !_and_3 ? false : (_not_1 = !(_equals_2 = (_clip_path_5 = element.getClip_path()).equals("none")));
            if (_and_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"<transforms>");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                String _transform_4 = clipElement.getTransform();
                String _handleTransform_1 = this.handleTransform(_transform_4);
                _builder.append((Object)_handleTransform_1, "\t\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"</transforms>");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"</Group>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"</clip>");
            _builder.newLine();
        }
        _builder.append((Object)"</ImageView>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _handle(SvgRectElement element) {
        String _clip_path_2;
        String _trim_2;
        boolean _equals_1;
        boolean _not;
        String _clip_path_1;
        String _trim_1;
        int _length_1;
        boolean _greaterThan;
        boolean _notEquals_11;
        String _filter;
        boolean _notEquals_9;
        boolean _notEquals_8;
        boolean _notEquals_7;
        boolean _notEquals_6;
        boolean _notEquals_5;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<Rectangle");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _x = element.getX();
        boolean bl = _notEquals = !Objects.equal((Object)_x, null);
        if (_notEquals) {
            _builder.append((Object)"x=\"");
            String _x_1 = element.getX();
            double _parseLength = this.parseLength(_x_1);
            _builder.append((Object)_parseLength, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _y = element.getY();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_y, null);
        if (_notEquals_1) {
            _builder.append((Object)"y=\"");
            String _y_1 = element.getY();
            double _parseLength_1 = this.parseLength(_y_1);
            _builder.append((Object)_parseLength_1, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _width = element.getWidth();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_width, null);
        if (_notEquals_2) {
            _builder.append((Object)"width=\"");
            String _width_1 = element.getWidth();
            double _parseLength_2 = this.parseLength(_width_1);
            _builder.append((Object)_parseLength_2, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _height = element.getHeight();
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)_height, null);
        if (_notEquals_3) {
            _builder.append((Object)"height=\"");
            String _height_1 = element.getHeight();
            double _parseLength_3 = this.parseLength(_height_1);
            _builder.append((Object)_parseLength_3, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _rx = element.getRx();
        boolean bl5 = _notEquals_4 = !Objects.equal((Object)_rx, null);
        if (_notEquals_4) {
            _builder.append((Object)"arcWidth=\"");
            String _rx_1 = element.getRx();
            double _parseLength_4 = this.parseLength(_rx_1);
            Double _valueOf = Double.valueOf("2.0");
            double _multiply = _parseLength_4 * _valueOf;
            _builder.append((Object)_multiply, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _ry = element.getRy();
        boolean bl6 = _notEquals_5 = !Objects.equal((Object)_ry, null);
        if (_notEquals_5) {
            _builder.append((Object)"arcHeight=\"");
            String _ry_1 = element.getRy();
            double _parseLength_5 = this.parseLength(_ry_1);
            Double _valueOf_1 = Double.valueOf("2.0");
            double _multiply_1 = _parseLength_5 * _valueOf_1;
            _builder.append((Object)_multiply_1, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _opacity = element.getOpacity();
        boolean bl7 = _notEquals_6 = !Objects.equal((Object)_opacity, null);
        if (_notEquals_6) {
            _builder.append((Object)"opacity=\"");
            String _opacity_1 = element.getOpacity();
            _builder.append((Object)_opacity_1, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _id = element.getId();
        boolean bl8 = _notEquals_7 = !Objects.equal((Object)_id, null);
        if (_notEquals_7) {
            _builder.append((Object)"id=\"");
            String _id_1 = element.getId();
            String _validateId = this.validateId(_id_1);
            _builder.append((Object)_validateId, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _handleShapePresentationAttributes = this.handleShapePresentationAttributes(element);
        _builder.append((Object)_handleShapePresentationAttributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)">");
        _builder.newLine();
        _builder.append((Object)"\t");
        Object _lookupFeature = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__FILL, element);
        Object _lookupFeature_1 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__FILL_OPACITY, element);
        CharSequence _handlePaint = this.handlePaint("fill", (String)_lookupFeature, (String)_lookupFeature_1);
        _builder.append((Object)_handlePaint, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        Object _lookupFeature_2 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE, element);
        Object _lookupFeature_3 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE_OPACITY, element);
        CharSequence _handlePaint_1 = this.handlePaint("stroke", (String)_lookupFeature_2, (String)_lookupFeature_3);
        _builder.append((Object)_handlePaint_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _class_ = element.getClass_();
        CharSequence _handleStyleClassAttributes = this.handleStyleClassAttributes(_class_);
        _builder.append((Object)_handleStyleClassAttributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _transform = element.getTransform();
        boolean bl9 = _notEquals_8 = !Objects.equal((Object)_transform, null);
        if (_notEquals_8) {
            _builder.append((Object)"\t");
            _builder.append((Object)"<transforms>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            String _transform_1 = element.getTransform();
            String _handleTransform = this.handleTransform(_transform_1);
            _builder.append((Object)_handleTransform, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"</transforms>");
            _builder.newLine();
        }
        boolean bl10 = _notEquals_9 = !Objects.equal((Object)(_filter = element.getFilter()), null);
        if (_notEquals_9) {
            boolean _notEquals_10;
            _builder.append((Object)"\t");
            String _filter_1 = element.getFilter();
            String _filter_2 = element.getFilter();
            int _length = _filter_2.length();
            int _minus = _length - 1;
            String _substring = _filter_1.substring(5, _minus);
            String _trim = _substring.trim();
            SvgElement _resolveElement = this.resolveElement(_trim);
            SvgFilterElement e = (SvgFilterElement)_resolveElement;
            _builder.newLineIfNotEmpty();
            boolean bl11 = _notEquals_10 = !Objects.equal((Object)e, null);
            if (_notEquals_10) {
                boolean _equals;
                EList _children = e.getChildren();
                Iterable _filter_3 = Iterables.filter((Iterable)_children, FilterPrimitiveElement.class);
                int _size = IterableExtensions.size((Iterable)_filter_3);
                boolean bl12 = _equals = _size == 1;
                if (_equals) {
                    _builder.append((Object)"\t");
                    EList _children_1 = e.getChildren();
                    Iterable _filter_4 = Iterables.filter((Iterable)_children_1, FilterPrimitiveElement.class);
                    FilterPrimitiveElement _head = (FilterPrimitiveElement)IterableExtensions.head((Iterable)_filter_4);
                    SvgElement fiElement = (SvgElement)((Object)_head);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<effect>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    CharSequence _handleFilter = this.handleFilter(fiElement);
                    _builder.append((Object)_handleFilter, "\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"</effect>");
                    _builder.newLine();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<!-- Multi filter needs different handling -->");
                    _builder.newLine();
                }
            }
        }
        boolean _and = false;
        boolean _and_1 = false;
        String _clip_path = element.getClip_path();
        boolean bl13 = _notEquals_11 = !Objects.equal((Object)_clip_path, null);
        _and_1 = !_notEquals_11 ? false : (_greaterThan = (_length_1 = (_trim_1 = (_clip_path_1 = element.getClip_path()).trim()).length()) > 0);
        _and = !_and_1 ? false : (_not = !(_equals_1 = (_trim_2 = (_clip_path_2 = element.getClip_path()).trim()).equals("none")));
        if (_and) {
            String _clip_path_5;
            boolean _equals_2;
            boolean _not_1;
            String _transform_3;
            String _trim_3;
            int _length_3;
            boolean _greaterThan_1;
            boolean _notEquals_12;
            _builder.append((Object)"\t");
            _builder.append((Object)"<clip>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            String _clip_path_3 = element.getClip_path();
            String _clip_path_4 = element.getClip_path();
            int _length_2 = _clip_path_4.length();
            int _minus_1 = _length_2 - 1;
            String _substring_1 = _clip_path_3.substring(5, _minus_1);
            SvgElement _resolveElement_1 = this.resolveElement(_substring_1);
            SvgClipPathElement clipElement = (SvgClipPathElement)_resolveElement_1;
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"<Group>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"<children>");
            _builder.newLine();
            EList _children_2 = clipElement.getChildren();
            for (SvgElement e_1 : _children_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t\t");
                CharSequence _handle = this.handle(e_1);
                _builder.append((Object)_handle, "\t\t\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"</children>");
            _builder.newLine();
            boolean _and_2 = false;
            boolean _and_3 = false;
            String _transform_2 = clipElement.getTransform();
            boolean bl14 = _notEquals_12 = !Objects.equal((Object)_transform_2, null);
            _and_3 = !_notEquals_12 ? false : (_greaterThan_1 = (_length_3 = (_trim_3 = (_transform_3 = clipElement.getTransform()).trim()).length()) > 0);
            _and_2 = !_and_3 ? false : (_not_1 = !(_equals_2 = (_clip_path_5 = element.getClip_path()).equals("none")));
            if (_and_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"<transforms>");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                String _transform_4 = clipElement.getTransform();
                String _handleTransform_1 = this.handleTransform(_transform_4);
                _builder.append((Object)_handleTransform_1, "\t\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"</transforms>");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"</Group>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"</clip>");
            _builder.newLine();
        }
        _builder.append((Object)"</Rectangle>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _handle(SvgGElement element) {
        String _clip_path_2;
        String _trim_2;
        boolean _equals_1;
        boolean _not;
        String _clip_path_1;
        String _trim_1;
        int _length_1;
        boolean _greaterThan;
        boolean _notEquals_7;
        String _filter;
        boolean _notEquals_5;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<Group");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _x = element.getX();
        boolean bl = _notEquals = !Objects.equal((Object)_x, null);
        if (_notEquals) {
            _builder.append((Object)"translateX=\"");
            String _x_1 = element.getX();
            double _parseCoordinate = this.parseCoordinate(_x_1);
            _builder.append((Object)_parseCoordinate, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _y = element.getY();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_y, null);
        if (_notEquals_1) {
            _builder.append((Object)"translateY=\"");
            String _y_1 = element.getY();
            double _parseCoordinate_1 = this.parseCoordinate(_y_1);
            _builder.append((Object)_parseCoordinate_1, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _opacity = element.getOpacity();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_opacity, null);
        if (_notEquals_2) {
            _builder.append((Object)"opacity=\"");
            String _opacity_1 = element.getOpacity();
            double _parseDouble = this.parseDouble(_opacity_1);
            String _fill_opacity = element.getFill_opacity();
            double _parseDouble_1 = this.parseDouble(_fill_opacity);
            double _multiply = _parseDouble * _parseDouble_1;
            _builder.append((Object)_multiply, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _id = element.getId();
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)_id, null);
        if (_notEquals_3) {
            _builder.append((Object)"id=\"");
            String _id_1 = element.getId();
            String _validateId = this.validateId(_id_1);
            _builder.append((Object)_validateId, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)">");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _class_ = element.getClass_();
        CharSequence _handleStyleClassAttributes = this.handleStyleClassAttributes(_class_);
        _builder.append((Object)_handleStyleClassAttributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<children>");
        _builder.newLine();
        EList _children = element.getChildren();
        for (SvgElement o : _children) {
            _builder.append((Object)"\t\t");
            CharSequence _handle = this.handle(o);
            _builder.append((Object)_handle, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"</children>");
        _builder.newLine();
        String _transform = element.getTransform();
        boolean bl5 = _notEquals_4 = !Objects.equal((Object)_transform, null);
        if (_notEquals_4) {
            _builder.append((Object)"\t");
            _builder.append((Object)"<transforms>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            String _transform_1 = element.getTransform();
            String _handleTransform = this.handleTransform(_transform_1);
            _builder.append((Object)_handleTransform, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"</transforms>");
            _builder.newLine();
        }
        boolean bl6 = _notEquals_5 = !Objects.equal((Object)(_filter = element.getFilter()), null);
        if (_notEquals_5) {
            boolean _notEquals_6;
            _builder.append((Object)"\t");
            String _filter_1 = element.getFilter();
            String _filter_2 = element.getFilter();
            int _length = _filter_2.length();
            int _minus = _length - 1;
            String _substring = _filter_1.substring(5, _minus);
            String _trim = _substring.trim();
            SvgElement _resolveElement = this.resolveElement(_trim);
            SvgFilterElement e = (SvgFilterElement)_resolveElement;
            _builder.newLineIfNotEmpty();
            boolean bl7 = _notEquals_6 = !Objects.equal((Object)e, null);
            if (_notEquals_6) {
                boolean _equals;
                EList _children_1 = e.getChildren();
                Iterable _filter_3 = Iterables.filter((Iterable)_children_1, FilterPrimitiveElement.class);
                int _size = IterableExtensions.size((Iterable)_filter_3);
                boolean bl8 = _equals = _size == 1;
                if (_equals) {
                    _builder.append((Object)"\t");
                    EList _children_2 = e.getChildren();
                    Iterable _filter_4 = Iterables.filter((Iterable)_children_2, FilterPrimitiveElement.class);
                    FilterPrimitiveElement _head = (FilterPrimitiveElement)IterableExtensions.head((Iterable)_filter_4);
                    SvgElement fiElement = (SvgElement)((Object)_head);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<effect>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    CharSequence _handleFilter = this.handleFilter(fiElement);
                    _builder.append((Object)_handleFilter, "\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"</effect>");
                    _builder.newLine();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<!-- Multi filter needs different handling -->");
                    _builder.newLine();
                }
            }
        }
        boolean _and = false;
        boolean _and_1 = false;
        String _clip_path = element.getClip_path();
        boolean bl9 = _notEquals_7 = !Objects.equal((Object)_clip_path, null);
        _and_1 = !_notEquals_7 ? false : (_greaterThan = (_length_1 = (_trim_1 = (_clip_path_1 = element.getClip_path()).trim()).length()) > 0);
        _and = !_and_1 ? false : (_not = !(_equals_1 = (_trim_2 = (_clip_path_2 = element.getClip_path()).trim()).equals("none")));
        if (_and) {
            String _clip_path_5;
            boolean _equals_2;
            boolean _not_1;
            String _transform_3;
            String _trim_3;
            int _length_3;
            boolean _greaterThan_1;
            boolean _notEquals_8;
            _builder.append((Object)"\t");
            _builder.append((Object)"<clip>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            String _clip_path_3 = element.getClip_path();
            String _clip_path_4 = element.getClip_path();
            int _length_2 = _clip_path_4.length();
            int _minus_1 = _length_2 - 1;
            String _substring_1 = _clip_path_3.substring(5, _minus_1);
            SvgElement _resolveElement_1 = this.resolveElement(_substring_1);
            SvgClipPathElement clipElement = (SvgClipPathElement)_resolveElement_1;
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"<Group>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"<children>");
            _builder.newLine();
            EList _children_3 = clipElement.getChildren();
            for (SvgElement e_1 : _children_3) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t\t");
                CharSequence _handle_1 = this.handle(e_1);
                _builder.append((Object)_handle_1, "\t\t\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"</children>");
            _builder.newLine();
            boolean _and_2 = false;
            boolean _and_3 = false;
            String _transform_2 = clipElement.getTransform();
            boolean bl10 = _notEquals_8 = !Objects.equal((Object)_transform_2, null);
            _and_3 = !_notEquals_8 ? false : (_greaterThan_1 = (_length_3 = (_trim_3 = (_transform_3 = clipElement.getTransform()).trim()).length()) > 0);
            _and_2 = !_and_3 ? false : (_not_1 = !(_equals_2 = (_clip_path_5 = element.getClip_path()).equals("none")));
            if (_and_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"<transforms>");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                String _transform_4 = clipElement.getTransform();
                String _handleTransform_1 = this.handleTransform(_transform_4);
                _builder.append((Object)_handleTransform_1, "\t\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"</transforms>");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"</Group>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"</clip>");
            _builder.newLine();
        }
        _builder.append((Object)"</Group>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _handle(SvgUseElement element) {
        String _clip_path_2;
        String _trim_2;
        boolean _equals_1;
        boolean _not;
        String _clip_path_1;
        String _trim_1;
        int _length_1;
        boolean _greaterThan;
        boolean _notEquals_8;
        String _filter;
        boolean _notEquals_6;
        String _transform;
        boolean _notEquals_5;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<Group");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _x = element.getX();
        boolean bl = _notEquals = !Objects.equal((Object)_x, null);
        if (_notEquals) {
            _builder.append((Object)"translateX=\"");
            String _x_1 = element.getX();
            double _parseCoordinate = this.parseCoordinate(_x_1);
            _builder.append((Object)_parseCoordinate, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _y = element.getY();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_y, null);
        if (_notEquals_1) {
            _builder.append((Object)"translateY=\"");
            String _y_1 = element.getY();
            double _parseCoordinate_1 = this.parseCoordinate(_y_1);
            _builder.append((Object)_parseCoordinate_1, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _opacity = element.getOpacity();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_opacity, null);
        if (_notEquals_2) {
            _builder.append((Object)"opacity=\"");
            String _opacity_1 = element.getOpacity();
            double _parseDouble = this.parseDouble(_opacity_1);
            String _fill_opacity = element.getFill_opacity();
            double _parseDouble_1 = this.parseDouble(_fill_opacity);
            double _multiply = _parseDouble * _parseDouble_1;
            _builder.append((Object)_multiply, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _id = element.getId();
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)_id, null);
        if (_notEquals_3) {
            _builder.append((Object)"id=\"");
            String _id_1 = element.getId();
            String _validateId = this.validateId(_id_1);
            _builder.append((Object)_validateId, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)">");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _class_ = element.getClass_();
        CharSequence _handleStyleClassAttributes = this.handleStyleClassAttributes(_class_);
        _builder.append((Object)_handleStyleClassAttributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        SvgElement _resolvedInstance = element.getResolvedInstance();
        boolean bl5 = _notEquals_4 = !Objects.equal((Object)_resolvedInstance, null);
        if (_notEquals_4) {
            _builder.append((Object)"\t");
            _builder.append((Object)"<children>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            SvgElement _resolvedInstance_1 = element.getResolvedInstance();
            CharSequence _handle = this.handle(_resolvedInstance_1);
            _builder.append((Object)_handle, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"</children>");
            _builder.newLine();
        }
        boolean bl6 = _notEquals_5 = !Objects.equal((Object)(_transform = element.getTransform()), null);
        if (_notEquals_5) {
            _builder.append((Object)"\t");
            _builder.append((Object)"<transforms>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            String _transform_1 = element.getTransform();
            String _handleTransform = this.handleTransform(_transform_1);
            _builder.append((Object)_handleTransform, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"</transforms>");
            _builder.newLine();
        }
        boolean bl7 = _notEquals_6 = !Objects.equal((Object)(_filter = element.getFilter()), null);
        if (_notEquals_6) {
            boolean _notEquals_7;
            _builder.append((Object)"\t");
            String _filter_1 = element.getFilter();
            String _filter_2 = element.getFilter();
            int _length = _filter_2.length();
            int _minus = _length - 1;
            String _substring = _filter_1.substring(5, _minus);
            String _trim = _substring.trim();
            SvgElement _resolveElement = this.resolveElement(_trim);
            SvgFilterElement e = (SvgFilterElement)_resolveElement;
            _builder.newLineIfNotEmpty();
            boolean bl8 = _notEquals_7 = !Objects.equal((Object)e, null);
            if (_notEquals_7) {
                boolean _equals;
                EList _children = e.getChildren();
                Iterable _filter_3 = Iterables.filter((Iterable)_children, FilterPrimitiveElement.class);
                int _size = IterableExtensions.size((Iterable)_filter_3);
                boolean bl9 = _equals = _size == 1;
                if (_equals) {
                    _builder.append((Object)"\t");
                    EList _children_1 = e.getChildren();
                    Iterable _filter_4 = Iterables.filter((Iterable)_children_1, FilterPrimitiveElement.class);
                    FilterPrimitiveElement _head = (FilterPrimitiveElement)IterableExtensions.head((Iterable)_filter_4);
                    SvgElement fiElement = (SvgElement)((Object)_head);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<effect>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    CharSequence _handleFilter = this.handleFilter(fiElement);
                    _builder.append((Object)_handleFilter, "\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"</effect>");
                    _builder.newLine();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<!-- Multi filter needs different handling -->");
                    _builder.newLine();
                }
            }
        }
        boolean _and = false;
        boolean _and_1 = false;
        String _clip_path = element.getClip_path();
        boolean bl10 = _notEquals_8 = !Objects.equal((Object)_clip_path, null);
        _and_1 = !_notEquals_8 ? false : (_greaterThan = (_length_1 = (_trim_1 = (_clip_path_1 = element.getClip_path()).trim()).length()) > 0);
        _and = !_and_1 ? false : (_not = !(_equals_1 = (_trim_2 = (_clip_path_2 = element.getClip_path()).trim()).equals("none")));
        if (_and) {
            String _clip_path_5;
            boolean _equals_2;
            boolean _not_1;
            String _transform_3;
            String _trim_3;
            int _length_3;
            boolean _greaterThan_1;
            boolean _notEquals_9;
            _builder.append((Object)"\t");
            _builder.append((Object)"<clip>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            String _clip_path_3 = element.getClip_path();
            String _clip_path_4 = element.getClip_path();
            int _length_2 = _clip_path_4.length();
            int _minus_1 = _length_2 - 1;
            String _substring_1 = _clip_path_3.substring(5, _minus_1);
            SvgElement _resolveElement_1 = this.resolveElement(_substring_1);
            SvgClipPathElement clipElement = (SvgClipPathElement)_resolveElement_1;
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"<Group>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"<children>");
            _builder.newLine();
            EList _children_2 = clipElement.getChildren();
            for (SvgElement e_1 : _children_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t\t");
                CharSequence _handle_1 = this.handle(e_1);
                _builder.append((Object)_handle_1, "\t\t\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"</children>");
            _builder.newLine();
            boolean _and_2 = false;
            boolean _and_3 = false;
            String _transform_2 = clipElement.getTransform();
            boolean bl11 = _notEquals_9 = !Objects.equal((Object)_transform_2, null);
            _and_3 = !_notEquals_9 ? false : (_greaterThan_1 = (_length_3 = (_trim_3 = (_transform_3 = clipElement.getTransform()).trim()).length()) > 0);
            _and_2 = !_and_3 ? false : (_not_1 = !(_equals_2 = (_clip_path_5 = element.getClip_path()).equals("none")));
            if (_and_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"<transforms>");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                String _transform_4 = clipElement.getTransform();
                String _handleTransform_1 = this.handleTransform(_transform_4);
                _builder.append((Object)_handleTransform_1, "\t\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"</transforms>");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"</Group>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"</clip>");
            _builder.newLine();
        }
        _builder.append((Object)"</Group>");
        _builder.newLine();
        return _builder;
    }

    public Object lookupFeature(EStructuralFeature feature, EObject object) {
        EObject _eContainer;
        EObject eo = object;
        do {
            boolean _eIsSet;
            EClass _eClass;
            EList _eAllStructuralFeatures;
            boolean _contains;
            if (!(_contains = (_eAllStructuralFeatures = (_eClass = eo.eClass()).getEAllStructuralFeatures()).contains((Object)feature)) || !(_eIsSet = eo.eIsSet(feature))) continue;
            return eo.eGet(feature);
        } while (!Objects.equal((Object)(eo = (_eContainer = eo.eContainer())), null));
        return null;
    }

    public CharSequence handleShapePresentationAttributes(PresentationAttributes element) {
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        Object _lookupFeature = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE_DASHOFFSET, element);
        boolean bl = _notEquals = !Objects.equal((Object)_lookupFeature, null);
        if (_notEquals) {
            _builder.append((Object)"strokeDashOffset=\"");
            Object _lookupFeature_1 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE_DASHOFFSET, element);
            double _parseLength = this.parseLength((String)_lookupFeature_1);
            _builder.append((Object)_parseLength, "");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        Object _lookupFeature_2 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE_LINECAP, element);
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_lookupFeature_2, null);
        if (_notEquals_1) {
            _builder.append((Object)"strokeLineCap=\"");
            Object _lookupFeature_3 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE_LINECAP, element);
            String _fx = this.toFx((Stroke_linecap)((Object)_lookupFeature_3));
            _builder.append((Object)_fx, "");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        Object _lookupFeature_4 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE_LINEJOIN, element);
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_lookupFeature_4, null);
        if (_notEquals_2) {
            _builder.append((Object)"strokeLineJoin=\"");
            Object _lookupFeature_5 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE_LINEJOIN, element);
            String _fx_1 = this.toFx((Stroke_linejoin)((Object)_lookupFeature_5));
            _builder.append((Object)_fx_1, "");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        Object _lookupFeature_6 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE_MITERLIMIT, element);
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)_lookupFeature_6, null);
        if (_notEquals_3) {
            _builder.append((Object)"strokeMiterLimit=\"");
            Object _lookupFeature_7 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE_MITERLIMIT, element);
            double _parseLength_1 = this.parseLength((String)_lookupFeature_7);
            _builder.append((Object)_parseLength_1, "");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        Object _lookupFeature_8 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE_WIDTH, element);
        boolean bl5 = _notEquals_4 = !Objects.equal((Object)_lookupFeature_8, null);
        if (_notEquals_4) {
            _builder.append((Object)"strokeWidth=\"");
            Object _lookupFeature_9 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE_WIDTH, element);
            double _parseLength_2 = this.parseLength((String)_lookupFeature_9);
            _builder.append((Object)_parseLength_2, "");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence handleStyleClassAttributes(String styleClass) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _notEquals = !Objects.equal((Object)styleClass, null);
        if (_notEquals) {
            String[] _split;
            _builder.append((Object)"<styleClass>");
            _builder.newLine();
            String[] stringArray = _split = styleClass.split(" ");
            int n = _split.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                _builder.append((Object)"\t");
                _builder.append((Object)"<String fx:value=\"");
                String _trim = c.trim();
                _builder.append((Object)_trim, "\t");
                _builder.append((Object)"\"/>");
                _builder.newLineIfNotEmpty();
                ++n2;
            }
            _builder.append((Object)"</styleClass>");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _handle(SvgPathElement element) {
        String _clip_path_2;
        String _trim_2;
        boolean _equals_1;
        boolean _not;
        String _clip_path_1;
        String _trim_1;
        int _length_1;
        boolean _greaterThan;
        boolean _notEquals_7;
        String _filter;
        boolean _notEquals_5;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<SVGPath");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _d = element.getD();
        boolean bl = _notEquals = !Objects.equal((Object)_d, null);
        if (_notEquals) {
            _builder.append((Object)"content=\"");
            String _d_1 = element.getD();
            _builder.append((Object)_d_1, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _opacity = element.getOpacity();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_opacity, null);
        if (_notEquals_1) {
            _builder.append((Object)"opacity=\"");
            String _opacity_1 = element.getOpacity();
            _builder.append((Object)_opacity_1, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        Fill_rule _fill_rule = element.getFill_rule();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)((Object)_fill_rule), (Object)((Object)Fill_rule.NONZERO));
        if (_notEquals_2) {
            _builder.append((Object)"fillRule=\"EVEN_ODD\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _handleShapePresentationAttributes = this.handleShapePresentationAttributes(element);
        _builder.append((Object)_handleShapePresentationAttributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _id = element.getId();
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)_id, null);
        if (_notEquals_3) {
            _builder.append((Object)"id=\"");
            String _id_1 = element.getId();
            String _validateId = this.validateId(_id_1);
            _builder.append((Object)_validateId, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)">");
        _builder.newLine();
        _builder.append((Object)"\t");
        Object _lookupFeature = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__FILL, element);
        Object _lookupFeature_1 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__FILL_OPACITY, element);
        CharSequence _handlePaint = this.handlePaint("fill", (String)_lookupFeature, (String)_lookupFeature_1);
        _builder.append((Object)_handlePaint, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        Object _lookupFeature_2 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE, element);
        Object _lookupFeature_3 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE_OPACITY, element);
        CharSequence _handlePaint_1 = this.handlePaint("stroke", (String)_lookupFeature_2, (String)_lookupFeature_3);
        _builder.append((Object)_handlePaint_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _class_ = element.getClass_();
        CharSequence _handleStyleClassAttributes = this.handleStyleClassAttributes(_class_);
        _builder.append((Object)_handleStyleClassAttributes, "\t");
        _builder.newLineIfNotEmpty();
        String _transform = element.getTransform();
        boolean bl5 = _notEquals_4 = !Objects.equal((Object)_transform, null);
        if (_notEquals_4) {
            _builder.append((Object)"\t");
            _builder.append((Object)"<transforms>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            String _transform_1 = element.getTransform();
            String _handleTransform = this.handleTransform(_transform_1);
            _builder.append((Object)_handleTransform, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"</transforms>");
            _builder.newLine();
        }
        boolean bl6 = _notEquals_5 = !Objects.equal((Object)(_filter = element.getFilter()), null);
        if (_notEquals_5) {
            boolean _notEquals_6;
            _builder.append((Object)"\t");
            String _filter_1 = element.getFilter();
            String _filter_2 = element.getFilter();
            int _length = _filter_2.length();
            int _minus = _length - 1;
            String _substring = _filter_1.substring(5, _minus);
            String _trim = _substring.trim();
            SvgElement _resolveElement = this.resolveElement(_trim);
            SvgFilterElement e = (SvgFilterElement)_resolveElement;
            _builder.newLineIfNotEmpty();
            boolean bl7 = _notEquals_6 = !Objects.equal((Object)e, null);
            if (_notEquals_6) {
                boolean _equals;
                EList _children = e.getChildren();
                Iterable _filter_3 = Iterables.filter((Iterable)_children, FilterPrimitiveElement.class);
                int _size = IterableExtensions.size((Iterable)_filter_3);
                boolean bl8 = _equals = _size == 1;
                if (_equals) {
                    _builder.append((Object)"\t");
                    EList _children_1 = e.getChildren();
                    Iterable _filter_4 = Iterables.filter((Iterable)_children_1, FilterPrimitiveElement.class);
                    FilterPrimitiveElement _head = (FilterPrimitiveElement)IterableExtensions.head((Iterable)_filter_4);
                    SvgElement fiElement = (SvgElement)((Object)_head);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<effect>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    CharSequence _handleFilter = this.handleFilter(fiElement);
                    _builder.append((Object)_handleFilter, "\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"</effect>");
                    _builder.newLine();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<!-- Multi filter needs different handling -->");
                    _builder.newLine();
                }
            }
        }
        boolean _and = false;
        boolean _and_1 = false;
        String _clip_path = element.getClip_path();
        boolean bl9 = _notEquals_7 = !Objects.equal((Object)_clip_path, null);
        _and_1 = !_notEquals_7 ? false : (_greaterThan = (_length_1 = (_trim_1 = (_clip_path_1 = element.getClip_path()).trim()).length()) > 0);
        _and = !_and_1 ? false : (_not = !(_equals_1 = (_trim_2 = (_clip_path_2 = element.getClip_path()).trim()).equals("none")));
        if (_and) {
            String _clip_path_5;
            boolean _equals_2;
            boolean _not_1;
            String _transform_3;
            String _trim_3;
            int _length_3;
            boolean _greaterThan_1;
            boolean _notEquals_8;
            _builder.append((Object)"\t");
            _builder.append((Object)"<clip>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            String _clip_path_3 = element.getClip_path();
            String _clip_path_4 = element.getClip_path();
            int _length_2 = _clip_path_4.length();
            int _minus_1 = _length_2 - 1;
            String _substring_1 = _clip_path_3.substring(5, _minus_1);
            SvgElement _resolveElement_1 = this.resolveElement(_substring_1);
            SvgClipPathElement clipElement = (SvgClipPathElement)_resolveElement_1;
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"<Group>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"<children>");
            _builder.newLine();
            EList _children_2 = clipElement.getChildren();
            for (SvgElement e_1 : _children_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t\t");
                CharSequence _handle = this.handle(e_1);
                _builder.append((Object)_handle, "\t\t\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"</children>");
            _builder.newLine();
            boolean _and_2 = false;
            boolean _and_3 = false;
            String _transform_2 = clipElement.getTransform();
            boolean bl10 = _notEquals_8 = !Objects.equal((Object)_transform_2, null);
            _and_3 = !_notEquals_8 ? false : (_greaterThan_1 = (_length_3 = (_trim_3 = (_transform_3 = clipElement.getTransform()).trim()).length()) > 0);
            _and_2 = !_and_3 ? false : (_not_1 = !(_equals_2 = (_clip_path_5 = element.getClip_path()).equals("none")));
            if (_and_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"<transforms>");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                String _transform_4 = clipElement.getTransform();
                String _handleTransform_1 = this.handleTransform(_transform_4);
                _builder.append((Object)_handleTransform_1, "\t\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"</transforms>");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"</Group>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"</clip>");
            _builder.newLine();
        }
        _builder.append((Object)"</SVGPath>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _handleFilter(EObject o) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<!-- Unsupported filter type -->");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _handleFilter(SvgFeGaussianBlurElement blur) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<GaussianBlur");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _stdDeviation = blur.getStdDeviation();
        boolean bl = _notEquals = !Objects.equal((Object)_stdDeviation, null);
        if (_notEquals) {
            _builder.append((Object)"radius=\"");
            String _stdDeviation_1 = blur.getStdDeviation();
            double _parseDouble = this.parseDouble(_stdDeviation_1);
            double _multiply = _parseDouble * 2.0;
            _builder.append((Object)_multiply, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"/>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence handlePaint(String type, String fillDefinition, String typeOpacity) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _notEquals = !Objects.equal((Object)fillDefinition, null);
        if (_notEquals) {
            _builder.append((Object)"<");
            _builder.append((Object)type, "");
            _builder.append((Object)">");
            _builder.newLineIfNotEmpty();
            boolean _equals = fillDefinition.equals("none");
            if (_equals) {
                _builder.append((Object)"\t");
                _builder.append((Object)"TRANSPARENT");
                _builder.newLine();
            } else {
                Double _valueOf;
                double _parseDouble;
                boolean _notEquals_2;
                boolean _notEquals_1;
                boolean _and = false;
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)typeOpacity, null);
                _and = !_notEquals_1 ? false : (_notEquals_2 = (_parseDouble = Double.parseDouble(typeOpacity)) != (_valueOf = Double.valueOf("1.0")));
                if (_and) {
                    _builder.append((Object)"\t");
                    double _parseDouble_1 = Double.parseDouble(typeOpacity);
                    CharSequence _fillPaint = this.fillPaint(fillDefinition, _parseDouble_1);
                    _builder.append((Object)_fillPaint, "\t");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"\t");
                    CharSequence _fillPaint_1 = this.fillPaint(fillDefinition);
                    _builder.append((Object)_fillPaint_1, "\t");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append((Object)"</");
            _builder.append((Object)type, "");
            _builder.append((Object)">");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _handle(SvgClipPathElement element) {
        return null;
    }

    protected CharSequence _handle(SvgEllipseElement element) {
        String _clip_path_2;
        String _trim_2;
        boolean _equals_1;
        boolean _not;
        String _clip_path_1;
        String _trim_1;
        int _length_1;
        boolean _greaterThan;
        boolean _notEquals_9;
        String _filter;
        boolean _notEquals_7;
        boolean _notEquals_6;
        boolean _notEquals_5;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<Ellipse");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _rx = element.getRx();
        boolean bl = _notEquals = !Objects.equal((Object)_rx, null);
        if (_notEquals) {
            _builder.append((Object)"radiusX=\"");
            String _rx_1 = element.getRx();
            double _parseLength = this.parseLength(_rx_1);
            _builder.append((Object)_parseLength, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _ry = element.getRy();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_ry, null);
        if (_notEquals_1) {
            _builder.append((Object)"radiusY=\"");
            String _ry_1 = element.getRy();
            double _parseLength_1 = this.parseLength(_ry_1);
            _builder.append((Object)_parseLength_1, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _cx = element.getCx();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_cx, null);
        if (_notEquals_2) {
            _builder.append((Object)"centerX=\"");
            String _cx_1 = element.getCx();
            double _parseCoordinate = this.parseCoordinate(_cx_1);
            _builder.append((Object)_parseCoordinate, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _cy = element.getCy();
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)_cy, null);
        if (_notEquals_3) {
            _builder.append((Object)"centerY=\"");
            String _cy_1 = element.getCy();
            double _parseCoordinate_1 = this.parseCoordinate(_cy_1);
            _builder.append((Object)_parseCoordinate_1, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _opacity = element.getOpacity();
        boolean bl5 = _notEquals_4 = !Objects.equal((Object)_opacity, null);
        if (_notEquals_4) {
            _builder.append((Object)"opacity=\"");
            String _opacity_1 = element.getOpacity();
            _builder.append((Object)_opacity_1, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _id = element.getId();
        boolean bl6 = _notEquals_5 = !Objects.equal((Object)_id, null);
        if (_notEquals_5) {
            _builder.append((Object)"id=\"");
            String _id_1 = element.getId();
            String _validateId = this.validateId(_id_1);
            _builder.append((Object)_validateId, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _handleShapePresentationAttributes = this.handleShapePresentationAttributes(element);
        _builder.append((Object)_handleShapePresentationAttributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)">");
        _builder.newLine();
        _builder.append((Object)"\t");
        Object _lookupFeature = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__FILL, element);
        Object _lookupFeature_1 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__FILL_OPACITY, element);
        CharSequence _handlePaint = this.handlePaint("fill", (String)_lookupFeature, (String)_lookupFeature_1);
        _builder.append((Object)_handlePaint, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        Object _lookupFeature_2 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE, element);
        Object _lookupFeature_3 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE_OPACITY, element);
        CharSequence _handlePaint_1 = this.handlePaint("stroke", (String)_lookupFeature_2, (String)_lookupFeature_3);
        _builder.append((Object)_handlePaint_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _class_ = element.getClass_();
        CharSequence _handleStyleClassAttributes = this.handleStyleClassAttributes(_class_);
        _builder.append((Object)_handleStyleClassAttributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _transform = element.getTransform();
        boolean bl7 = _notEquals_6 = !Objects.equal((Object)_transform, null);
        if (_notEquals_6) {
            _builder.append((Object)"\t");
            _builder.append((Object)"<transforms>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            String _transform_1 = element.getTransform();
            String _handleTransform = this.handleTransform(_transform_1);
            _builder.append((Object)_handleTransform, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"</transforms>");
            _builder.newLine();
        }
        boolean bl8 = _notEquals_7 = !Objects.equal((Object)(_filter = element.getFilter()), null);
        if (_notEquals_7) {
            boolean _notEquals_8;
            _builder.append((Object)"\t");
            String _filter_1 = element.getFilter();
            String _filter_2 = element.getFilter();
            int _length = _filter_2.length();
            int _minus = _length - 1;
            String _substring = _filter_1.substring(5, _minus);
            String _trim = _substring.trim();
            SvgElement _resolveElement = this.resolveElement(_trim);
            SvgFilterElement e = (SvgFilterElement)_resolveElement;
            _builder.newLineIfNotEmpty();
            boolean bl9 = _notEquals_8 = !Objects.equal((Object)e, null);
            if (_notEquals_8) {
                boolean _equals;
                EList _children = e.getChildren();
                Iterable _filter_3 = Iterables.filter((Iterable)_children, FilterPrimitiveElement.class);
                int _size = IterableExtensions.size((Iterable)_filter_3);
                boolean bl10 = _equals = _size == 1;
                if (_equals) {
                    _builder.append((Object)"\t");
                    EList _children_1 = e.getChildren();
                    Iterable _filter_4 = Iterables.filter((Iterable)_children_1, FilterPrimitiveElement.class);
                    FilterPrimitiveElement _head = (FilterPrimitiveElement)IterableExtensions.head((Iterable)_filter_4);
                    SvgElement fiElement = (SvgElement)((Object)_head);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<effect>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    CharSequence _handleFilter = this.handleFilter(fiElement);
                    _builder.append((Object)_handleFilter, "\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"</effect>");
                    _builder.newLine();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<!-- Multi filter needs different handling -->");
                    _builder.newLine();
                }
            }
        }
        boolean _and = false;
        boolean _and_1 = false;
        String _clip_path = element.getClip_path();
        boolean bl11 = _notEquals_9 = !Objects.equal((Object)_clip_path, null);
        _and_1 = !_notEquals_9 ? false : (_greaterThan = (_length_1 = (_trim_1 = (_clip_path_1 = element.getClip_path()).trim()).length()) > 0);
        _and = !_and_1 ? false : (_not = !(_equals_1 = (_trim_2 = (_clip_path_2 = element.getClip_path()).trim()).equals("none")));
        if (_and) {
            String _clip_path_5;
            boolean _equals_2;
            boolean _not_1;
            String _transform_3;
            String _trim_3;
            int _length_3;
            boolean _greaterThan_1;
            boolean _notEquals_10;
            _builder.append((Object)"\t");
            _builder.append((Object)"<clip>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            String _clip_path_3 = element.getClip_path();
            String _clip_path_4 = element.getClip_path();
            int _length_2 = _clip_path_4.length();
            int _minus_1 = _length_2 - 1;
            String _substring_1 = _clip_path_3.substring(5, _minus_1);
            SvgElement _resolveElement_1 = this.resolveElement(_substring_1);
            SvgClipPathElement clipElement = (SvgClipPathElement)_resolveElement_1;
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"<Group>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"<children>");
            _builder.newLine();
            EList _children_2 = clipElement.getChildren();
            for (SvgElement e_1 : _children_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t\t");
                CharSequence _handle = this.handle(e_1);
                _builder.append((Object)_handle, "\t\t\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"</children>");
            _builder.newLine();
            boolean _and_2 = false;
            boolean _and_3 = false;
            String _transform_2 = clipElement.getTransform();
            boolean bl12 = _notEquals_10 = !Objects.equal((Object)_transform_2, null);
            _and_3 = !_notEquals_10 ? false : (_greaterThan_1 = (_length_3 = (_trim_3 = (_transform_3 = clipElement.getTransform()).trim()).length()) > 0);
            _and_2 = !_and_3 ? false : (_not_1 = !(_equals_2 = (_clip_path_5 = element.getClip_path()).equals("none")));
            if (_and_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"<transforms>");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                String _transform_4 = clipElement.getTransform();
                String _handleTransform_1 = this.handleTransform(_transform_4);
                _builder.append((Object)_handleTransform_1, "\t\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"</transforms>");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"</Group>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"</clip>");
            _builder.newLine();
        }
        _builder.append((Object)"</Ellipse>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _handle(SvgCircleElement element) {
        String _clip_path_2;
        String _trim_2;
        boolean _equals_1;
        boolean _not;
        String _clip_path_1;
        String _trim_1;
        int _length_1;
        boolean _greaterThan;
        boolean _notEquals_8;
        String _filter;
        boolean _notEquals_6;
        boolean _notEquals_5;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<Circle");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _r = element.getR();
        boolean bl = _notEquals = !Objects.equal((Object)_r, null);
        if (_notEquals) {
            _builder.append((Object)"radius=\"");
            String _r_1 = element.getR();
            double _parseLength = this.parseLength(_r_1);
            _builder.append((Object)_parseLength, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _cx = element.getCx();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_cx, null);
        if (_notEquals_1) {
            _builder.append((Object)"centerX=\"");
            String _cx_1 = element.getCx();
            double _parseCoordinate = this.parseCoordinate(_cx_1);
            _builder.append((Object)_parseCoordinate, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _cy = element.getCy();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_cy, null);
        if (_notEquals_2) {
            _builder.append((Object)"centerY=\"");
            String _cy_1 = element.getCy();
            double _parseCoordinate_1 = this.parseCoordinate(_cy_1);
            _builder.append((Object)_parseCoordinate_1, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _opacity = element.getOpacity();
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)_opacity, null);
        if (_notEquals_3) {
            _builder.append((Object)"opacity=\"");
            String _opacity_1 = element.getOpacity();
            _builder.append((Object)_opacity_1, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _id = element.getId();
        boolean bl5 = _notEquals_4 = !Objects.equal((Object)_id, null);
        if (_notEquals_4) {
            _builder.append((Object)"id=\"");
            String _id_1 = element.getId();
            String _validateId = this.validateId(_id_1);
            _builder.append((Object)_validateId, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _handleShapePresentationAttributes = this.handleShapePresentationAttributes(element);
        _builder.append((Object)_handleShapePresentationAttributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)">");
        _builder.newLine();
        _builder.append((Object)"\t");
        Object _lookupFeature = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__FILL, element);
        Object _lookupFeature_1 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__FILL_OPACITY, element);
        CharSequence _handlePaint = this.handlePaint("fill", (String)_lookupFeature, (String)_lookupFeature_1);
        _builder.append((Object)_handlePaint, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        Object _lookupFeature_2 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE, element);
        Object _lookupFeature_3 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE_OPACITY, element);
        CharSequence _handlePaint_1 = this.handlePaint("stroke", (String)_lookupFeature_2, (String)_lookupFeature_3);
        _builder.append((Object)_handlePaint_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _class_ = element.getClass_();
        CharSequence _handleStyleClassAttributes = this.handleStyleClassAttributes(_class_);
        _builder.append((Object)_handleStyleClassAttributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _transform = element.getTransform();
        boolean bl6 = _notEquals_5 = !Objects.equal((Object)_transform, null);
        if (_notEquals_5) {
            _builder.append((Object)"\t");
            _builder.append((Object)"<transforms>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            String _transform_1 = element.getTransform();
            String _handleTransform = this.handleTransform(_transform_1);
            _builder.append((Object)_handleTransform, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"</transforms>");
            _builder.newLine();
        }
        boolean bl7 = _notEquals_6 = !Objects.equal((Object)(_filter = element.getFilter()), null);
        if (_notEquals_6) {
            boolean _notEquals_7;
            _builder.append((Object)"\t");
            String _filter_1 = element.getFilter();
            String _filter_2 = element.getFilter();
            int _length = _filter_2.length();
            int _minus = _length - 1;
            String _substring = _filter_1.substring(5, _minus);
            String _trim = _substring.trim();
            SvgElement _resolveElement = this.resolveElement(_trim);
            SvgFilterElement e = (SvgFilterElement)_resolveElement;
            _builder.newLineIfNotEmpty();
            boolean bl8 = _notEquals_7 = !Objects.equal((Object)e, null);
            if (_notEquals_7) {
                boolean _equals;
                EList _children = e.getChildren();
                Iterable _filter_3 = Iterables.filter((Iterable)_children, FilterPrimitiveElement.class);
                int _size = IterableExtensions.size((Iterable)_filter_3);
                boolean bl9 = _equals = _size == 1;
                if (_equals) {
                    _builder.append((Object)"\t");
                    EList _children_1 = e.getChildren();
                    Iterable _filter_4 = Iterables.filter((Iterable)_children_1, FilterPrimitiveElement.class);
                    FilterPrimitiveElement _head = (FilterPrimitiveElement)IterableExtensions.head((Iterable)_filter_4);
                    SvgElement fiElement = (SvgElement)((Object)_head);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<effect>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    CharSequence _handleFilter = this.handleFilter(fiElement);
                    _builder.append((Object)_handleFilter, "\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"</effect>");
                    _builder.newLine();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<!-- Multi filter needs different handling -->");
                    _builder.newLine();
                }
            }
        }
        boolean _and = false;
        boolean _and_1 = false;
        String _clip_path = element.getClip_path();
        boolean bl10 = _notEquals_8 = !Objects.equal((Object)_clip_path, null);
        _and_1 = !_notEquals_8 ? false : (_greaterThan = (_length_1 = (_trim_1 = (_clip_path_1 = element.getClip_path()).trim()).length()) > 0);
        _and = !_and_1 ? false : (_not = !(_equals_1 = (_trim_2 = (_clip_path_2 = element.getClip_path()).trim()).equals("none")));
        if (_and) {
            String _clip_path_5;
            boolean _equals_2;
            boolean _not_1;
            String _transform_3;
            String _trim_3;
            int _length_3;
            boolean _greaterThan_1;
            boolean _notEquals_9;
            _builder.append((Object)"\t");
            _builder.append((Object)"<clip>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            String _clip_path_3 = element.getClip_path();
            String _clip_path_4 = element.getClip_path();
            int _length_2 = _clip_path_4.length();
            int _minus_1 = _length_2 - 1;
            String _substring_1 = _clip_path_3.substring(5, _minus_1);
            SvgElement _resolveElement_1 = this.resolveElement(_substring_1);
            SvgClipPathElement clipElement = (SvgClipPathElement)_resolveElement_1;
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"<Group>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"<children>");
            _builder.newLine();
            EList _children_2 = clipElement.getChildren();
            for (SvgElement e_1 : _children_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t\t");
                CharSequence _handle = this.handle(e_1);
                _builder.append((Object)_handle, "\t\t\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"</children>");
            _builder.newLine();
            boolean _and_2 = false;
            boolean _and_3 = false;
            String _transform_2 = clipElement.getTransform();
            boolean bl11 = _notEquals_9 = !Objects.equal((Object)_transform_2, null);
            _and_3 = !_notEquals_9 ? false : (_greaterThan_1 = (_length_3 = (_trim_3 = (_transform_3 = clipElement.getTransform()).trim()).length()) > 0);
            _and_2 = !_and_3 ? false : (_not_1 = !(_equals_2 = (_clip_path_5 = element.getClip_path()).equals("none")));
            if (_and_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"<transforms>");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                String _transform_4 = clipElement.getTransform();
                String _handleTransform_1 = this.handleTransform(_transform_4);
                _builder.append((Object)_handleTransform_1, "\t\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"</transforms>");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"</Group>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"</clip>");
            _builder.newLine();
        }
        _builder.append((Object)"</Circle>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _handle(SvgPolylineElement element) {
        String _clip_path_2;
        String _trim_2;
        boolean _equals_1;
        boolean _not;
        String _clip_path_1;
        String _trim_1;
        int _length_1;
        boolean _greaterThan;
        boolean _notEquals_6;
        String _filter;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<Polyline");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _points = element.getPoints();
        boolean bl = _notEquals = !Objects.equal((Object)_points, null);
        if (_notEquals) {
            _builder.append((Object)"points=\"");
            String _points_1 = element.getPoints();
            String _replaceAll = _points_1.replaceAll("\\s+", ",");
            _builder.append((Object)_replaceAll, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _opacity = element.getOpacity();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_opacity, null);
        if (_notEquals_1) {
            _builder.append((Object)"opacity=\"");
            String _opacity_1 = element.getOpacity();
            _builder.append((Object)_opacity_1, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _handleShapePresentationAttributes = this.handleShapePresentationAttributes(element);
        _builder.append((Object)_handleShapePresentationAttributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _id = element.getId();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_id, null);
        if (_notEquals_2) {
            _builder.append((Object)"id=\"");
            String _id_1 = element.getId();
            String _validateId = this.validateId(_id_1);
            _builder.append((Object)_validateId, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)">");
        _builder.newLine();
        Object _lookupFeature = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__FILL, element);
        Object _lookupFeature_1 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__FILL_OPACITY, element);
        CharSequence _handlePaint = this.handlePaint("fill", (String)_lookupFeature, (String)_lookupFeature_1);
        _builder.append((Object)_handlePaint, "");
        _builder.newLineIfNotEmpty();
        Object _lookupFeature_2 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE, element);
        Object _lookupFeature_3 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE_OPACITY, element);
        CharSequence _handlePaint_1 = this.handlePaint("stroke", (String)_lookupFeature_2, (String)_lookupFeature_3);
        _builder.append((Object)_handlePaint_1, "");
        _builder.newLineIfNotEmpty();
        String _class_ = element.getClass_();
        CharSequence _handleStyleClassAttributes = this.handleStyleClassAttributes(_class_);
        _builder.append((Object)_handleStyleClassAttributes, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _transform = element.getTransform();
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)_transform, null);
        if (_notEquals_3) {
            _builder.append((Object)"<transforms>");
            _builder.newLine();
            _builder.append((Object)"\t");
            String _transform_1 = element.getTransform();
            String _handleTransform = this.handleTransform(_transform_1);
            _builder.append((Object)_handleTransform, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"</transforms>");
            _builder.newLine();
        }
        boolean bl5 = _notEquals_4 = !Objects.equal((Object)(_filter = element.getFilter()), null);
        if (_notEquals_4) {
            boolean _notEquals_5;
            _builder.append((Object)"\t");
            String _filter_1 = element.getFilter();
            String _filter_2 = element.getFilter();
            int _length = _filter_2.length();
            int _minus = _length - 1;
            String _substring = _filter_1.substring(5, _minus);
            String _trim = _substring.trim();
            SvgElement _resolveElement = this.resolveElement(_trim);
            SvgFilterElement e = (SvgFilterElement)_resolveElement;
            _builder.newLineIfNotEmpty();
            boolean bl6 = _notEquals_5 = !Objects.equal((Object)e, null);
            if (_notEquals_5) {
                boolean _equals;
                EList _children = e.getChildren();
                Iterable _filter_3 = Iterables.filter((Iterable)_children, FilterPrimitiveElement.class);
                int _size = IterableExtensions.size((Iterable)_filter_3);
                boolean bl7 = _equals = _size == 1;
                if (_equals) {
                    _builder.append((Object)"\t");
                    EList _children_1 = e.getChildren();
                    Iterable _filter_4 = Iterables.filter((Iterable)_children_1, FilterPrimitiveElement.class);
                    FilterPrimitiveElement _head = (FilterPrimitiveElement)IterableExtensions.head((Iterable)_filter_4);
                    SvgElement fiElement = (SvgElement)((Object)_head);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<effect>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    CharSequence _handleFilter = this.handleFilter(fiElement);
                    _builder.append((Object)_handleFilter, "\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"</effect>");
                    _builder.newLine();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<!-- Multi filter needs different handling -->");
                    _builder.newLine();
                }
            }
        }
        boolean _and = false;
        boolean _and_1 = false;
        String _clip_path = element.getClip_path();
        boolean bl8 = _notEquals_6 = !Objects.equal((Object)_clip_path, null);
        _and_1 = !_notEquals_6 ? false : (_greaterThan = (_length_1 = (_trim_1 = (_clip_path_1 = element.getClip_path()).trim()).length()) > 0);
        _and = !_and_1 ? false : (_not = !(_equals_1 = (_trim_2 = (_clip_path_2 = element.getClip_path()).trim()).equals("none")));
        if (_and) {
            String _clip_path_5;
            boolean _equals_2;
            boolean _not_1;
            String _transform_3;
            String _trim_3;
            int _length_3;
            boolean _greaterThan_1;
            boolean _notEquals_7;
            _builder.append((Object)"<clip>");
            _builder.newLine();
            _builder.append((Object)"\t");
            String _clip_path_3 = element.getClip_path();
            String _clip_path_4 = element.getClip_path();
            int _length_2 = _clip_path_4.length();
            int _minus_1 = _length_2 - 1;
            String _substring_1 = _clip_path_3.substring(5, _minus_1);
            SvgElement _resolveElement_1 = this.resolveElement(_substring_1);
            SvgClipPathElement clipElement = (SvgClipPathElement)_resolveElement_1;
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"<Group>");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"<children>");
            _builder.newLine();
            EList _children_2 = clipElement.getChildren();
            for (SvgElement e_1 : _children_2) {
                _builder.append((Object)"\t\t\t");
                CharSequence _handle = this.handle(e_1);
                _builder.append((Object)_handle, "\t\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"</children>");
            _builder.newLine();
            boolean _and_2 = false;
            boolean _and_3 = false;
            String _transform_2 = clipElement.getTransform();
            boolean bl9 = _notEquals_7 = !Objects.equal((Object)_transform_2, null);
            _and_3 = !_notEquals_7 ? false : (_greaterThan_1 = (_length_3 = (_trim_3 = (_transform_3 = clipElement.getTransform()).trim()).length()) > 0);
            _and_2 = !_and_3 ? false : (_not_1 = !(_equals_2 = (_clip_path_5 = element.getClip_path()).equals("none")));
            if (_and_2) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"<transforms>");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                String _transform_4 = clipElement.getTransform();
                String _handleTransform_1 = this.handleTransform(_transform_4);
                _builder.append((Object)_handleTransform_1, "\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"</transforms>");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"</Group>");
            _builder.newLine();
            _builder.append((Object)"</clip>");
            _builder.newLine();
        }
        _builder.append((Object)"</Polyline>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _handle(SvgPolygonElement element) {
        String _clip_path_2;
        String _trim_2;
        boolean _equals_1;
        boolean _not;
        String _clip_path_1;
        String _trim_1;
        int _length_1;
        boolean _greaterThan;
        boolean _notEquals_6;
        String _filter;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<Polygon");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _points = element.getPoints();
        boolean bl = _notEquals = !Objects.equal((Object)_points, null);
        if (_notEquals) {
            _builder.append((Object)"points=\"");
            String _points_1 = element.getPoints();
            String _replaceAll = _points_1.replaceAll("\\s+", ",");
            _builder.append((Object)_replaceAll, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _opacity = element.getOpacity();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_opacity, null);
        if (_notEquals_1) {
            _builder.append((Object)"opacity=\"");
            String _opacity_1 = element.getOpacity();
            _builder.append((Object)_opacity_1, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _handleShapePresentationAttributes = this.handleShapePresentationAttributes(element);
        _builder.append((Object)_handleShapePresentationAttributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _id = element.getId();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_id, null);
        if (_notEquals_2) {
            _builder.append((Object)"id=\"");
            String _id_1 = element.getId();
            String _validateId = this.validateId(_id_1);
            _builder.append((Object)_validateId, "\t");
            _builder.append((Object)"\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)">");
        _builder.newLine();
        Object _lookupFeature = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__FILL, element);
        Object _lookupFeature_1 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__FILL_OPACITY, element);
        CharSequence _handlePaint = this.handlePaint("fill", (String)_lookupFeature, (String)_lookupFeature_1);
        _builder.append((Object)_handlePaint, "");
        _builder.newLineIfNotEmpty();
        Object _lookupFeature_2 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE, element);
        Object _lookupFeature_3 = this.lookupFeature((EStructuralFeature)SvgPackage.Literals.PRESENTATION_ATTRIBUTES__STROKE_OPACITY, element);
        CharSequence _handlePaint_1 = this.handlePaint("stroke", (String)_lookupFeature_2, (String)_lookupFeature_3);
        _builder.append((Object)_handlePaint_1, "");
        _builder.newLineIfNotEmpty();
        String _class_ = element.getClass_();
        CharSequence _handleStyleClassAttributes = this.handleStyleClassAttributes(_class_);
        _builder.append((Object)_handleStyleClassAttributes, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _transform = element.getTransform();
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)_transform, null);
        if (_notEquals_3) {
            _builder.append((Object)"<transforms>");
            _builder.newLine();
            _builder.append((Object)"\t");
            String _transform_1 = element.getTransform();
            String _handleTransform = this.handleTransform(_transform_1);
            _builder.append((Object)_handleTransform, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"</transforms>");
            _builder.newLine();
        }
        boolean bl5 = _notEquals_4 = !Objects.equal((Object)(_filter = element.getFilter()), null);
        if (_notEquals_4) {
            boolean _notEquals_5;
            _builder.append((Object)"\t");
            String _filter_1 = element.getFilter();
            String _filter_2 = element.getFilter();
            int _length = _filter_2.length();
            int _minus = _length - 1;
            String _substring = _filter_1.substring(5, _minus);
            String _trim = _substring.trim();
            SvgElement _resolveElement = this.resolveElement(_trim);
            SvgFilterElement e = (SvgFilterElement)_resolveElement;
            _builder.newLineIfNotEmpty();
            boolean bl6 = _notEquals_5 = !Objects.equal((Object)e, null);
            if (_notEquals_5) {
                boolean _equals;
                EList _children = e.getChildren();
                Iterable _filter_3 = Iterables.filter((Iterable)_children, FilterPrimitiveElement.class);
                int _size = IterableExtensions.size((Iterable)_filter_3);
                boolean bl7 = _equals = _size == 1;
                if (_equals) {
                    _builder.append((Object)"\t");
                    EList _children_1 = e.getChildren();
                    Iterable _filter_4 = Iterables.filter((Iterable)_children_1, FilterPrimitiveElement.class);
                    FilterPrimitiveElement _head = (FilterPrimitiveElement)IterableExtensions.head((Iterable)_filter_4);
                    SvgElement fiElement = (SvgElement)((Object)_head);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<effect>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    CharSequence _handleFilter = this.handleFilter(fiElement);
                    _builder.append((Object)_handleFilter, "\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"</effect>");
                    _builder.newLine();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<!-- Multi filter needs different handling -->");
                    _builder.newLine();
                }
            }
        }
        boolean _and = false;
        boolean _and_1 = false;
        String _clip_path = element.getClip_path();
        boolean bl8 = _notEquals_6 = !Objects.equal((Object)_clip_path, null);
        _and_1 = !_notEquals_6 ? false : (_greaterThan = (_length_1 = (_trim_1 = (_clip_path_1 = element.getClip_path()).trim()).length()) > 0);
        _and = !_and_1 ? false : (_not = !(_equals_1 = (_trim_2 = (_clip_path_2 = element.getClip_path()).trim()).equals("none")));
        if (_and) {
            String _clip_path_5;
            boolean _equals_2;
            boolean _not_1;
            String _transform_3;
            String _trim_3;
            int _length_3;
            boolean _greaterThan_1;
            boolean _notEquals_7;
            _builder.append((Object)"<clip>");
            _builder.newLine();
            _builder.append((Object)"\t");
            String _clip_path_3 = element.getClip_path();
            String _clip_path_4 = element.getClip_path();
            int _length_2 = _clip_path_4.length();
            int _minus_1 = _length_2 - 1;
            String _substring_1 = _clip_path_3.substring(5, _minus_1);
            SvgElement _resolveElement_1 = this.resolveElement(_substring_1);
            SvgClipPathElement clipElement = (SvgClipPathElement)_resolveElement_1;
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"<Group>");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"<children>");
            _builder.newLine();
            EList _children_2 = clipElement.getChildren();
            for (SvgElement e_1 : _children_2) {
                _builder.append((Object)"\t\t\t");
                CharSequence _handle = this.handle(e_1);
                _builder.append((Object)_handle, "\t\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"</children>");
            _builder.newLine();
            boolean _and_2 = false;
            boolean _and_3 = false;
            String _transform_2 = clipElement.getTransform();
            boolean bl9 = _notEquals_7 = !Objects.equal((Object)_transform_2, null);
            _and_3 = !_notEquals_7 ? false : (_greaterThan_1 = (_length_3 = (_trim_3 = (_transform_3 = clipElement.getTransform()).trim()).length()) > 0);
            _and_2 = !_and_3 ? false : (_not_1 = !(_equals_2 = (_clip_path_5 = element.getClip_path()).equals("none")));
            if (_and_2) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"<transforms>");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                String _transform_4 = clipElement.getTransform();
                String _handleTransform_1 = this.handleTransform(_transform_4);
                _builder.append((Object)_handleTransform_1, "\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"</transforms>");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"</Group>");
            _builder.newLine();
            _builder.append((Object)"</clip>");
            _builder.newLine();
        }
        _builder.append((Object)"</Polygon>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence fillPaint(String fill) {
        Object _xifexpression = null;
        boolean _startsWith = fill.startsWith("#");
        if (_startsWith) {
            return this.hexColor(fill);
        }
        Object _xifexpression_1 = null;
        boolean _startsWith_1 = fill.startsWith("rgb");
        if (_startsWith_1) {
            int _indexOf = fill.indexOf("(");
            int _plus = _indexOf + 1;
            int _indexOf_1 = fill.indexOf(")");
            String c = fill.substring(_plus, _indexOf_1);
            return this.rgbColor(c);
        }
        Object _xifexpression_2 = null;
        boolean _startsWith_2 = fill.startsWith("argb");
        if (_startsWith_2) {
            _xifexpression_2 = null;
        } else {
            boolean _startsWith_3 = fill.startsWith("url");
            if (_startsWith_3) {
                int _length = fill.length();
                int _minus = _length - 1;
                String _substring = fill.substring(5, _minus);
                SvgElement e = this.resolveElement(_substring);
                if (e instanceof SvgLinearGradientElement) {
                    return this.handleGradient((SvgLinearGradientElement)e, null);
                }
                if (e instanceof SvgRadialGradientElement) {
                    return this.handleGradient((SvgRadialGradientElement)e, null);
                }
            } else {
                return fill.toUpperCase();
            }
        }
        _xifexpression = _xifexpression_1 = _xifexpression_2;
        return _xifexpression;
    }

    public CharSequence fillPaint(String fill, Double opacity) {
        Object _xifexpression = null;
        boolean _startsWith = fill.startsWith("#");
        if (_startsWith) {
            return this.hexColor(fill, opacity);
        }
        Object _xifexpression_1 = null;
        String _lowerCase = fill.toLowerCase();
        boolean _startsWith_1 = _lowerCase.startsWith("rgb");
        if (_startsWith_1) {
            int _indexOf = fill.indexOf("(");
            int _plus = _indexOf + 1;
            int _indexOf_1 = fill.indexOf(")");
            String c = fill.substring(_plus, _indexOf_1);
            return this.rgbColor(c);
        }
        Object _xifexpression_2 = null;
        boolean _startsWith_2 = fill.startsWith("argb");
        if (_startsWith_2) {
            _xifexpression_2 = null;
        } else {
            boolean _startsWith_3 = fill.startsWith("url");
            if (_startsWith_3) {
                int _length = fill.length();
                int _minus = _length - 1;
                String _substring = fill.substring(5, _minus);
                SvgElement e = this.resolveElement(_substring);
                if (e instanceof SvgLinearGradientElement) {
                    return this.handleGradient((SvgLinearGradientElement)e, opacity);
                }
                if (e instanceof SvgRadialGradientElement) {
                    return this.handleGradient((SvgRadialGradientElement)e, opacity);
                }
            } else {
                boolean _notEquals;
                Colors c_1 = Colors.findColorByName(fill);
                boolean bl = _notEquals = !Objects.equal((Object)((Object)c_1), null);
                if (_notEquals) {
                    return this.hexColor(c_1.hexvalue, opacity);
                }
                return fill.toUpperCase();
            }
        }
        _xifexpression = _xifexpression_1 = _xifexpression_2;
        return _xifexpression;
    }

    public CharSequence rgbColor(String fill) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<Color>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<red>");
        double _rgbRed = this.rgbRed(fill);
        _builder.append((Object)_rgbRed, "\t");
        _builder.append((Object)"</red>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<green>");
        double _rgbGreen = this.rgbGreen(fill);
        _builder.append((Object)_rgbGreen, "\t");
        _builder.append((Object)"</green>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<blue>");
        double _rgbBlue = this.rgbBlue(fill);
        _builder.append((Object)_rgbBlue, "\t");
        _builder.append((Object)"</blue>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</Color>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence rgbColor(String fill, Double opacity) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<Color>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<red>");
        double _rgbRed = this.rgbRed(fill);
        _builder.append((Object)_rgbRed, "\t");
        _builder.append((Object)"</red>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<green>");
        double _rgbGreen = this.rgbGreen(fill);
        _builder.append((Object)_rgbGreen, "\t");
        _builder.append((Object)"</green>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<blue>");
        double _rgbBlue = this.rgbBlue(fill);
        _builder.append((Object)_rgbBlue, "\t");
        _builder.append((Object)"</blue>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<opacity>");
        _builder.append((Object)opacity, "\t");
        _builder.append((Object)"</opacity>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</Color>");
        _builder.newLine();
        return _builder;
    }

    public double rgbRed(String color) {
        String[] _split = color.split(",");
        String _get = _split[0];
        int _parseInt = Integer.parseInt(_get);
        double _parseDouble = Double.parseDouble("255");
        return (double)_parseInt / _parseDouble;
    }

    public double rgbGreen(String color) {
        String[] _split = color.split(",");
        String _get = _split[1];
        int _parseInt = Integer.parseInt(_get);
        double _parseDouble = Double.parseDouble("255");
        return (double)_parseInt / _parseDouble;
    }

    public double rgbBlue(String color) {
        String[] _split = color.split(",");
        String _get = _split[2];
        int _parseInt = Integer.parseInt(_get);
        double _parseDouble = Double.parseDouble("255");
        return (double)_parseInt / _parseDouble;
    }

    public CharSequence hexColor(String fill) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<Color>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<red>");
        double _hexRed = this.hexRed(fill);
        _builder.append((Object)_hexRed, "\t");
        _builder.append((Object)"</red>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<green>");
        double _hexGreen = this.hexGreen(fill);
        _builder.append((Object)_hexGreen, "\t");
        _builder.append((Object)"</green>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<blue>");
        double _hexBlue = this.hexBlue(fill);
        _builder.append((Object)_hexBlue, "\t");
        _builder.append((Object)"</blue>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</Color>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence hexColor(String fill, Double opacity) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<Color>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<red>");
        double _hexRed = this.hexRed(fill);
        _builder.append((Object)_hexRed, "\t");
        _builder.append((Object)"</red>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<green>");
        double _hexGreen = this.hexGreen(fill);
        _builder.append((Object)_hexGreen, "\t");
        _builder.append((Object)"</green>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<blue>");
        double _hexBlue = this.hexBlue(fill);
        _builder.append((Object)_hexBlue, "\t");
        _builder.append((Object)"</blue>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<opacity>");
        _builder.append((Object)opacity, "\t");
        _builder.append((Object)"</opacity>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</Color>");
        _builder.newLine();
        return _builder;
    }

    public double hexRed(String color) {
        return Colors.hexRed(color);
    }

    public double hexGreen(String color) {
        return Colors.hexGreen(color);
    }

    public double hexBlue(String color) {
        return Colors.hexBlue(color);
    }

    public CharSequence transformElement(String transform) {
        StringConcatenation _builder = new StringConcatenation();
        int _indexOf = transform.indexOf("(");
        int _plus = _indexOf + 1;
        int _indexOf_1 = transform.indexOf(")");
        String params = transform.substring(_plus, _indexOf_1);
        _builder.newLineIfNotEmpty();
        boolean _startsWith = transform.startsWith("translate");
        if (_startsWith) {
            boolean _notEquals;
            _builder.append((Object)"<Translate");
            _builder.newLine();
            int _indexOf_2 = params.indexOf(",");
            boolean bl = _notEquals = _indexOf_2 != -1;
            if (_notEquals) {
                _builder.append((Object)"\t");
                String[] parts = params.split(",");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"x=\"");
                String _get = parts[0];
                _builder.append((Object)_get, "\t");
                _builder.append((Object)"\"");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"y=\"");
                String _get_1 = parts[1];
                _builder.append((Object)_get_1, "\t");
                _builder.append((Object)"\"");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"x=\"");
                _builder.append((Object)params, "\t");
                _builder.append((Object)"\"");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"y=\"");
                _builder.append((Object)params, "\t");
                _builder.append((Object)"\"");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)">");
            _builder.newLine();
            _builder.append((Object)"</Translate>");
            _builder.newLine();
        } else {
            boolean _startsWith_1 = transform.startsWith("scale");
            if (_startsWith_1) {
                boolean _notEquals_1;
                _builder.append((Object)"<Scale");
                _builder.newLine();
                int _indexOf_3 = params.indexOf(",");
                boolean bl = _notEquals_1 = _indexOf_3 != -1;
                if (_notEquals_1) {
                    _builder.append((Object)"\t");
                    String[] parts_1 = params.split(",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"x=\"");
                    String _get_2 = parts_1[0];
                    _builder.append((Object)_get_2, "\t");
                    _builder.append((Object)"\"");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"y=\"");
                    String _get_3 = parts_1[1];
                    _builder.append((Object)_get_3, "\t");
                    _builder.append((Object)"\"");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"x=\"");
                    _builder.append((Object)params, "\t");
                    _builder.append((Object)"\"");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"y=\"");
                    _builder.append((Object)params, "\t");
                    _builder.append((Object)"\"");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)">");
                _builder.newLine();
                _builder.append((Object)"</Scale>");
                _builder.newLine();
            } else {
                boolean _startsWith_2 = transform.startsWith("rotate");
                if (_startsWith_2) {
                    boolean _notEquals_2;
                    _builder.append((Object)"<Rotate");
                    _builder.newLine();
                    int _indexOf_4 = params.indexOf(",");
                    boolean bl = _notEquals_2 = _indexOf_4 != -1;
                    if (_notEquals_2) {
                        boolean _equals;
                        _builder.append((Object)"\t");
                        String[] parts_2 = params.split(",");
                        _builder.newLineIfNotEmpty();
                        int _size = ((List)Conversions.doWrapArray((Object)parts_2)).size();
                        boolean bl2 = _equals = _size == 2;
                        if (_equals) {
                            _builder.append((Object)"\t");
                            _builder.append((Object)"angle=\"");
                            String _get_4 = parts_2[0];
                            _builder.append((Object)_get_4, "\t");
                            _builder.append((Object)"\"");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"pivotX=\"");
                            String _get_5 = parts_2[1];
                            _builder.append((Object)_get_5, "\t");
                            _builder.append((Object)"\"");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"pivotY=\"");
                            String _get_6 = parts_2[1];
                            _builder.append((Object)_get_6, "\t");
                            _builder.append((Object)"\"");
                            _builder.newLineIfNotEmpty();
                        } else {
                            boolean _equals_1;
                            int _size_1 = ((List)Conversions.doWrapArray((Object)parts_2)).size();
                            boolean bl3 = _equals_1 = _size_1 == 3;
                            if (_equals_1) {
                                _builder.append((Object)"\t");
                                _builder.append((Object)"angle=\"");
                                String _get_7 = parts_2[0];
                                _builder.append((Object)_get_7, "\t");
                                _builder.append((Object)"\"");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"\t");
                                _builder.append((Object)"pivotX=\"");
                                String _get_8 = parts_2[1];
                                _builder.append((Object)_get_8, "\t");
                                _builder.append((Object)"\"");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"\t");
                                _builder.append((Object)"pivotY=\"");
                                String _get_9 = parts_2[2];
                                _builder.append((Object)_get_9, "\t");
                                _builder.append((Object)"\"");
                                _builder.newLineIfNotEmpty();
                            }
                        }
                    } else {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"angle=\"");
                        _builder.append((Object)params, "\t");
                        _builder.append((Object)"\"");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)">");
                    _builder.newLine();
                    _builder.append((Object)"</Rotate>");
                    _builder.newLine();
                } else {
                    boolean _startsWith_3 = transform.startsWith("matrix");
                    if (_startsWith_3) {
                        String[] parts_3 = params.split("[,\\s+]");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"<Affine");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"mxx=\"");
                        String _get_10 = parts_3[0];
                        _builder.append((Object)_get_10, "\t");
                        _builder.append((Object)"\"");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"myx=\"");
                        String _get_11 = parts_3[1];
                        _builder.append((Object)_get_11, "\t");
                        _builder.append((Object)"\"");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"mxy=\"");
                        String _get_12 = parts_3[2];
                        _builder.append((Object)_get_12, "\t");
                        _builder.append((Object)"\"");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"myy=\"");
                        String _get_13 = parts_3[3];
                        _builder.append((Object)_get_13, "\t");
                        _builder.append((Object)"\"");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"tx=\"");
                        String _get_14 = parts_3[4];
                        _builder.append((Object)_get_14, "\t");
                        _builder.append((Object)"\"");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"ty=\"");
                        String _get_15 = parts_3[5];
                        _builder.append((Object)_get_15, "\t");
                        _builder.append((Object)"\"");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)">");
                        _builder.newLine();
                        _builder.append((Object)"</Affine>");
                        _builder.newLine();
                    }
                }
            }
        }
        return _builder;
    }

    public String handleTransform(String t) {
        String transform = t;
        int endIdx = 0;
        StringBuilder builder = new StringBuilder();
        while ((endIdx = transform.indexOf(")")) != -1) {
            String _trim;
            boolean _greaterThan;
            String _substring = transform.substring(0, endIdx + 1);
            CharSequence _transformElement = this.transformElement(_substring);
            builder.append(_transformElement);
            int _length = transform.length();
            boolean bl = _greaterThan = endIdx + 1 > _length;
            if (_greaterThan) {
                return builder.toString();
            }
            String _substring_1 = transform.substring(endIdx + 1);
            transform = _trim = _substring_1.trim();
        }
        return builder.toString();
    }

    protected CharSequence _handle(SvgFilterElement filter) {
        return null;
    }

    protected CharSequence _handle(SvgFeGaussianBlurElement f) {
        return null;
    }

    public String toFx(SpreadMethod m) {
        if (m != null) {
            switch (m) {
                case PAD: {
                    return "NO_CYCLE";
                }
                case REFLECT: {
                    return "REFLECT";
                }
                case REPEAT: {
                    return "REPEAT";
                }
            }
        }
        return "NO_CYCLE";
    }

    public String toFx(Stroke_linecap m) {
        if (m != null) {
            switch (m) {
                case BUTT: {
                    return "BUTT";
                }
                case ROUND: {
                    return "ROUND";
                }
                case SQUARE: {
                    return "SQUARE";
                }
                case INHERIT: {
                    return "INHERIT";
                }
            }
        }
        return "BUTT";
    }

    public String toFx(Stroke_linejoin m) {
        if (m != null) {
            switch (m) {
                case BEVEL: {
                    return "BEVEL";
                }
                case MITER: {
                    return "MITER";
                }
                case ROUND: {
                    return "ROUND";
                }
                case INHERIT: {
                    return "INHERIT";
                }
            }
        }
        return "BEVEL";
    }

    public double parseLength(String length) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal((Object)length, null);
        if (_notEquals) {
            boolean _endsWith = length.endsWith("px");
            if (_endsWith) {
                int _length = length.length();
                int _minus = _length - 2;
                String _substring = length.substring(0, _minus);
                return Double.parseDouble(_substring);
            }
            return Double.parseDouble(length);
        }
        return 0.0;
    }

    public double parseCoordinate(String coordinate) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal((Object)coordinate, null);
        if (_notEquals) {
            return Double.parseDouble(coordinate);
        }
        return 0.0;
    }

    public double parsePercentage(String percentage) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal((Object)percentage, null);
        if (_notEquals) {
            return Double.parseDouble(percentage);
        }
        return 0.0;
    }

    public double parseDouble(String value) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal((Object)value, null);
        if (_notEquals) {
            return Double.parseDouble(value);
        }
        return 0.0;
    }

    public String validateId(String value) {
        String _replaceAll = value.replaceAll("\\.", "_dot");
        String _replaceAll_1 = _replaceAll.replaceAll(" ", "_space");
        return _replaceAll_1.replaceAll(":", "_colon");
    }

    public CharSequence handle(EObject element) {
        if (element instanceof SvgDefsElement) {
            return this._handle((SvgDefsElement)element);
        }
        if (element instanceof SvgGElement) {
            return this._handle((SvgGElement)element);
        }
        if (element instanceof SvgSvgElement) {
            return this._handle((SvgSvgElement)element);
        }
        if (element instanceof SvgCircleElement) {
            return this._handle((SvgCircleElement)element);
        }
        if (element instanceof SvgClipPathElement) {
            return this._handle((SvgClipPathElement)element);
        }
        if (element instanceof SvgEllipseElement) {
            return this._handle((SvgEllipseElement)element);
        }
        if (element instanceof SvgFeGaussianBlurElement) {
            return this._handle((SvgFeGaussianBlurElement)element);
        }
        if (element instanceof SvgFilterElement) {
            return this._handle((SvgFilterElement)element);
        }
        if (element instanceof SvgImageElement) {
            return this._handle((SvgImageElement)element);
        }
        if (element instanceof SvgLinearGradientElement) {
            return this._handle((SvgLinearGradientElement)element);
        }
        if (element instanceof SvgPathElement) {
            return this._handle((SvgPathElement)element);
        }
        if (element instanceof SvgPolygonElement) {
            return this._handle((SvgPolygonElement)element);
        }
        if (element instanceof SvgPolylineElement) {
            return this._handle((SvgPolylineElement)element);
        }
        if (element instanceof SvgRadialGradientElement) {
            return this._handle((SvgRadialGradientElement)element);
        }
        if (element instanceof SvgRectElement) {
            return this._handle((SvgRectElement)element);
        }
        if (element instanceof SvgUseElement) {
            return this._handle((SvgUseElement)element);
        }
        if (element != null) {
            return this._handle(element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }

    public CharSequence handleFilter(EObject blur) {
        if (blur instanceof SvgFeGaussianBlurElement) {
            return this._handleFilter((SvgFeGaussianBlurElement)blur);
        }
        if (blur != null) {
            return this._handleFilter(blur);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(blur).toString());
    }
}

