/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.observable;

import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.observable.BaseValueObservable;
import org.eclipse.fx.core.observable.StringValueObservable;

public interface ValueObservable<T> {
    public void setValue(T var1);

    public T getValue();

    public Subscription onValueChange(ChangeSubscription<T> var1);

    public void dispose();

    public boolean isDisposed();

    public static <T> ValueObservable<T> createObservableObject() {
        return new BaseValueObservable.NullBaseValueObservable();
    }

    public static <T> ValueObservable<T> createObservableObject(T value) {
        return new BaseValueObservable<T>(value);
    }

    public static StringValueObservable createObservableString() {
        return new StringValueObservable();
    }

    public static StringValueObservable createObservableString(String value) {
        return new StringValueObservable(value);
    }

    public static interface ChangeSubscription<T> {
        public void handle(ValueObservable<T> var1, T var2, T var3);
    }

    public static interface OString
    extends ValueObservable<String> {
    }
}

