/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.set;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.set.AbstractObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetDiff;

public abstract class ComputedSet<E>
extends AbstractObservableSet<E> {
    private Set<E> cachedSet = new HashSet();
    private boolean dirty = true;
    private boolean stale = false;
    private IObservable[] dependencies = new IObservable[0];
    private PrivateInterface privateInterface = new PrivateInterface();
    private Object elementType;

    public ComputedSet() {
        this(Realm.getDefault(), null);
    }

    public ComputedSet(Object elementType) {
        this(Realm.getDefault(), elementType);
    }

    public ComputedSet(Realm realm) {
        this(realm, null);
    }

    public ComputedSet(Realm realm, Object elementType) {
        super(realm);
        this.elementType = elementType;
    }

    protected int doGetSize() {
        return this.doGetSet().size();
    }

    private final Set<E> getSet() {
        this.getterCalled();
        return this.doGetSet();
    }

    @Override
    protected Set<E> getWrappedSet() {
        return this.doGetSet();
    }

    final Set<E> doGetSet() {
        if (this.dirty) {
            IObservable[] newDependencies = ObservableTracker.runAndMonitor(this.privateInterface, this.privateInterface, null);
            this.stale = false;
            int i = 0;
            while (i < newDependencies.length) {
                if (newDependencies[i].isStale()) {
                    this.makeStale();
                    break;
                }
                ++i;
            }
            if (!this.stale) {
                i = 0;
                while (i < newDependencies.length) {
                    newDependencies[i].addStaleListener(this.privateInterface);
                    ++i;
                }
            }
            this.dependencies = newDependencies;
            this.dirty = false;
        }
        return this.cachedSet;
    }

    protected abstract Set<E> calculate();

    private void makeDirty() {
        if (!this.dirty) {
            this.dirty = true;
            final HashSet<E> oldSet = new HashSet<E>(this.cachedSet);
            this.makeStale();
            this.stopListening();
            this.fireSetChange(new SetDiff<E>(){
                SetDiff<E> delegate;

                private SetDiff<E> getDelegate() {
                    if (this.delegate == null) {
                        this.delegate = Diffs.computeSetDiff(oldSet, ComputedSet.this.getSet());
                    }
                    return this.delegate;
                }

                @Override
                public Set<E> getAdditions() {
                    return this.getDelegate().getAdditions();
                }

                @Override
                public Set<E> getRemovals() {
                    return this.getDelegate().getRemovals();
                }
            });
        }
    }

    private void stopListening() {
        if (this.dependencies != null) {
            int i = 0;
            while (i < this.dependencies.length) {
                IObservable observable = this.dependencies[i];
                observable.removeChangeListener(this.privateInterface);
                observable.removeStaleListener(this.privateInterface);
                ++i;
            }
            this.dependencies = null;
        }
    }

    private void makeStale() {
        if (!this.stale) {
            this.stale = true;
            this.fireStale();
        }
    }

    @Override
    public boolean isStale() {
        this.getSet();
        return this.stale;
    }

    @Override
    public Object getElementType() {
        return this.elementType;
    }

    @Override
    public synchronized void addChangeListener(IChangeListener listener) {
        super.addChangeListener(listener);
        this.computeSetForListeners();
    }

    @Override
    public synchronized void addSetChangeListener(ISetChangeListener<? super E> listener) {
        super.addSetChangeListener(listener);
        this.computeSetForListeners();
    }

    private void computeSetForListeners() {
        this.getRealm().exec(new Runnable(){

            @Override
            public void run() {
                if (ComputedSet.this.dependencies == null) {
                    ComputedSet.this.getSet();
                }
            }
        });
    }

    @Override
    public synchronized void dispose() {
        this.stopListening();
        super.dispose();
    }

    private class PrivateInterface
    implements Runnable,
    IChangeListener,
    IStaleListener {
        private PrivateInterface() {
        }

        @Override
        public void run() {
            ComputedSet.this.cachedSet = ComputedSet.this.calculate();
            if (ComputedSet.this.cachedSet == null) {
                ComputedSet.this.cachedSet = Collections.EMPTY_SET;
            }
        }

        @Override
        public void handleStale(StaleEvent event) {
            if (!ComputedSet.this.dirty) {
                ComputedSet.this.makeStale();
            }
        }

        @Override
        public void handleChange(ChangeEvent event) {
            ComputedSet.this.makeDirty();
        }
    }
}

