/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base.addons;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.fx.ui.services.sync.UISynchronize;
import org.osgi.service.event.Event;

public class CleanUpAddon {
    @Inject
    UISynchronize synchronize;

    @PostConstruct
    void init(IEventBroker broker) {
        broker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this::handleChildrenModified);
    }

    private void handleChildrenModified(Event event) {
        Object changedObj = event.getProperty("ChangedElement");
        if (UIEvents.isREMOVE((Event)event)) {
            MElementContainer container = (MElementContainer)changedObj;
            MElementContainer containerParent = container.getParent();
            if (container instanceof MApplication || container instanceof MPerspectiveStack || container instanceof MMenuElement || container instanceof MTrimBar || container instanceof MToolBar || container instanceof MArea || container.getTags().contains("NoAutoCollapse")) {
                return;
            }
            if (container instanceof MWindow && containerParent instanceof MApplication) {
                return;
            }
            this.synchronize.scheduleExecution(200L, () -> {
                if (container.getChildren().isEmpty()) {
                    container.setParent(null);
                } else if (container instanceof MGenericTile && container.getChildren().size() == 1) {
                    MGenericTile tile = (MGenericTile)container;
                    int idx = container.getParent().getChildren().indexOf(container);
                    String containerData = tile.getContainerData();
                    MUIElement child = (MUIElement)container.getChildren().remove(0);
                    child.setContainerData(containerData);
                    container.getParent().getChildren().add(idx, child);
                    container.setParent(null);
                }
            });
        }
    }
}

