/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class BaseItemRenderer<M extends MUIElement, W extends WWidget<M>>
extends BaseRenderer<M, W> {
    public static final String VISIBLE_WHEN_RESULT = "VISIBLE_WHEN_RESULT";

    @PostConstruct
    void init(@NonNull IEventBroker broker) {
        this.registerEventListener(broker, "org/eclipse/e4/ui/model/ui/UILabel/iconURI/*");
        this.registerEventListener(broker, "org/eclipse/e4/ui/model/ui/UILabel/label/*");
        this.registerEventListener(broker, "org/eclipse/e4/ui/model/ui/UILabel/tooltip/*");
    }

    protected @Nullable ParameterizedCommand generateParameterizedCommand(MHandledItem item, IEclipseContext lclContext) {
        if (item.getCommand() == null) {
            this.getLogger().error("No command assigned to " + item);
            return null;
        }
        if (item.getCommand().getElementId() == null || item.getCommand().getElementId().trim().isEmpty()) {
            this.getLogger().error("No command id assigned to " + item.getCommand().getElementId());
            return null;
        }
        ECommandService cmdService = (ECommandService)lclContext.get(ECommandService.class.getName());
        HashMap<String, String> parameters = null;
        List modelParms = item.getParameters();
        if (modelParms != null && !modelParms.isEmpty()) {
            parameters = new HashMap<String, String>();
            for (MParameter mParm : modelParms) {
                parameters.put(mParm.getName(), mParm.getValue());
            }
        }
        ParameterizedCommand cmd = cmdService.createCommand(item.getCommand().getElementId(), parameters);
        return cmd;
    }

    protected boolean canExecute(M item, IEclipseContext context) {
        if (item instanceof MContribution) {
            MContribution contribution = (MContribution)item;
            Object object = this.getContributionObject(context, contribution);
            if (object == null) {
                return false;
            }
            IEclipseContext runContext = context.createChild("DI-ToolItem");
            try {
                ContributionsAnalyzer.populateModelInterfaces(item, (IEclipseContext)runContext, (Class[])item.getClass().getInterfaces());
                runContext.set(MItem.class.getName(), item);
                boolean bl = Boolean.TRUE.equals(ContextInjectionFactory.invoke((Object)object, CanExecute.class, (IEclipseContext)context.getActiveLeaf(), (IEclipseContext)runContext, (Object)Boolean.TRUE));
                return bl;
            }
            finally {
                runContext.dispose();
            }
        }
        if (item instanceof MHandledItem) {
            MHandledItem handledItem = (MHandledItem)item;
            EHandlerService service = (EHandlerService)context.get(EHandlerService.class.getName());
            if (service == null) {
                return false;
            }
            ParameterizedCommand cmd = handledItem.getWbCommand();
            if (cmd == null) {
                cmd = this.generateParameterizedCommand(handledItem, context);
                handledItem.setWbCommand(cmd);
            }
            if (cmd == null) {
                return false;
            }
            IEclipseContext runContext = context.createChild("HI-ToolItem");
            try {
                ContributionsAnalyzer.populateModelInterfaces(item, (IEclipseContext)runContext, (Class[])item.getClass().getInterfaces());
                boolean bl = service.canExecute(cmd, runContext);
                return bl;
            }
            finally {
                runContext.dispose();
            }
        }
        return false;
    }

    protected void executeAction(M item, IEclipseContext context) {
        if (item instanceof MContribution) {
            MContribution contribution = (MContribution)item;
            Object object = this.getContributionObject(context, contribution);
            if (object == null) {
                return;
            }
            IEclipseContext runContext = context.createChild("DI-ToolItem");
            try {
                ContributionsAnalyzer.populateModelInterfaces(item, (IEclipseContext)runContext, (Class[])item.getClass().getInterfaces());
                runContext.set(MItem.class.getName(), item);
                ContextInjectionFactory.invoke((Object)object, Execute.class, (IEclipseContext)context.getActiveLeaf(), (IEclipseContext)runContext, (Object)new Object());
            }
            finally {
                runContext.dispose();
            }
        }
        if (item instanceof MHandledItem) {
            MHandledItem handledItem = (MHandledItem)item;
            EHandlerService service = (EHandlerService)context.get(EHandlerService.class.getName());
            ParameterizedCommand cmd = handledItem.getWbCommand();
            if (cmd == null) {
                cmd = this.generateParameterizedCommand(handledItem, context);
                handledItem.setWbCommand(cmd);
            }
            if (cmd == null) {
                this.getLogger().error("Failed to execute: " + handledItem.getCommand());
                return;
            }
            IEclipseContext runContext = context.createChild("HI-ToolItem");
            try {
                ContributionsAnalyzer.populateModelInterfaces(item, (IEclipseContext)runContext, (Class[])item.getClass().getInterfaces());
                runContext.set(MItem.class.getName(), item);
                service.executeHandler(cmd, runContext);
            }
            finally {
                runContext.dispose();
            }
        }
    }

    private Object getContributionObject(IEclipseContext context, MContribution contribution) {
        Object rv = contribution.getObject();
        if (rv == null) {
            if (contribution.getContributionURI() == null) {
                this.getLogger().error("No contribution uri defined for " + contribution);
                return null;
            }
            IContributionFactory cf = (IContributionFactory)context.get(IContributionFactory.class.getName());
            rv = cf.create(contribution.getContributionURI(), context);
            contribution.setObject(rv);
        }
        return rv;
    }

    public abstract void checkEnablement(M var1);
}

