/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.srlistener;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import servlet.tck.common.servlets.HttpTCKServlet;
import servlet.tck.common.util.ServletTestUtil;

public class TestServlet
extends HttpTCKServlet {
    public void includes(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/include/IncludedServlet?testname=simple";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        this.logger.info("In method includes");
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.include((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void multipleincludes(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/include/IncludedServlet?testname=includeagain";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        this.logger.debug("In method multipleincludes");
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.include((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void includeforward(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/include/IncludedServlet?testname=forward";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        this.logger.debug("In method includeforward");
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.include((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void includeerror(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/include/IncludedServlet?testname=error";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        this.logger.debug("In method includeerror");
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            pw.println("In method includeerror");
            rd.include((ServletRequest)request, (ServletResponse)response);
        }
        if (!((String)request.getAttribute("ERROR_TEST_INCLUDE")).equals("403")) {
            pw.println("Test Failed");
        } else {
            response.sendError(403);
        }
    }

    public void forward(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/forward/ForwardedServlet?testname=simple";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        this.logger.debug("In method forward");
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void multipleforwards(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/forward/ForwardedServlet?testname=forwardagain";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        this.logger.debug("In method multipleforward");
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void forwardinclude(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/forward/ForwardedServlet?testname=include";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        this.logger.debug("In method forwardinclude");
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void forwarderror(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/forward/ForwardedServlet?testname=error";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        this.logger.debug("In method forwarderror");
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void async(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        pw.println("TestServlet Invoked");
        pw.println("In method async");
        this.logger.debug("In method async");
        try {
            AsyncContext asyncc = request.startAsync();
            response.getWriter().println("TestServlet_Async=STARTED");
            asyncc.complete();
        }
        catch (IllegalStateException ilex) {
            pw.println("TestServlet_Async=NOT_STARTED");
        }
        catch (Exception ex) {
            pw.println("TestServlet_Async=FAILED: " + ex.getMessage());
        }
    }

    public void simpleasyncinclude(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        pw.println("TestServlet Invoked");
        pw.println("In method simpleasyncinclude");
        this.logger.debug("In method simpleasyncinclude");
        try {
            AsyncContext asyncc = request.startAsync();
            response.getWriter().println("TestServlet_Async=STARTED");
            String path = "/include/IncludedServlet?testname=simple";
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            if (rd == null) {
                pw.println("Null RequestDispatcher got for path=" + path);
            } else {
                rd.include((ServletRequest)request, (ServletResponse)response);
            }
            asyncc.complete();
        }
        catch (IllegalStateException ilex) {
            pw.println("TestServlet_Async=NOT_STARTED");
        }
        catch (Exception ex) {
            pw.println("TestServlet_Async=FAILED: " + ex.getMessage());
        }
    }

    public void simpleasyncforward(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        pw.println("TestServlet Invoked");
        pw.println("In method simpleasyncforward");
        this.logger.debug("In method simpleasyncforward");
        try {
            AsyncContext asyncc = request.startAsync();
            response.getWriter().println("TestServlet_Async=STARTED");
            String path = "/forward/ForwardedServlet?testname=simple";
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            if (rd == null) {
                pw.println("Null RequestDispatcher got for path=" + path);
            } else {
                rd.forward((ServletRequest)request, (ServletResponse)response);
            }
            asyncc.complete();
        }
        catch (IllegalStateException ilex) {
            pw.println("TestServlet_Async=NOT_STARTED");
        }
        catch (Exception ex) {
            pw.println("TestServlet_Async=FAILED: " + ex.getMessage());
        }
    }

    public void simpleasyncerror(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        pw.println("TestServlet Invoked");
        pw.println("In method simpleasyncerror");
        this.logger.debug("In method simpleasyncerror");
        try {
            AsyncContext asyncc = request.startAsync();
            response.getWriter().println("TestServlet_Async=STARTED");
            response.sendError(403);
            asyncc.complete();
        }
        catch (IllegalStateException ilex) {
            pw.println("TestServlet_Async=NOT_STARTED");
        }
        catch (Exception ex) {
            pw.println("TestServlet_Async=FAILED: " + ex.getMessage());
        }
    }

    public void error(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.logger.debug("In TestServlet, error method");
        res.sendError(403);
    }

    public void checkLogSimple(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        Boolean pass = true;
        String[] expected = new String[]{"in requestInitialized method of listener", "in requestDestroyed method of listener", "in requestInitialized method of listener"};
        int expected_len = expected.length;
        ArrayList result = (ArrayList)this.getServletContext().getAttribute("arraylist");
        result.trimToSize();
        int len = result.size();
        if (len == expected_len) {
            pw.write("Got expected " + expected_len + " access times");
            for (int i = 0; i < len; ++i) {
                String val = null;
                val = (String)result.get(i);
                if (!expected[i].equals(val)) {
                    pass = false;
                    pw.write("Expecting " + expected[i] + " at position " + i);
                    pw.write(". Got " + String.valueOf(val) + " instead.");
                    continue;
                }
                pw.write("Got expected value: " + expected[i] + " at position " + i);
            }
        } else {
            pass = false;
            pw.write("RequestListener is invoked/deleted more or less times than required");
            pw.write("Expect " + expected_len + " times, got " + len + ".");
            if (len > expected_len) {
                int i;
                for (i = 0; i < expected_len; ++i) {
                    String val = null;
                    val = (String)result.get(i);
                    if (!expected[i].equals(val)) {
                        pass = false;
                        pw.write("Expecting " + expected[i] + " at position " + i);
                        pw.write(". Got " + String.valueOf(val) + " instead.");
                        continue;
                    }
                    pw.write("Got expected value: " + expected[i] + " at position " + i);
                }
                for (i = expected_len; i < len; ++i) {
                    pw.write("Extra access to Listener: " + String.valueOf(result.get(i)) + " at position " + i);
                }
            } else {
                int i;
                for (i = 0; i < len; ++i) {
                    String val = null;
                    val = (String)result.get(i);
                    if (!expected[i].equals(val)) {
                        pass = false;
                        pw.write("Expecting " + expected[i] + " at position " + i);
                        pw.write(". Got " + String.valueOf(val) + " instead.");
                        continue;
                    }
                    pw.write("Got expected value: " + expected[i] + " at position " + i);
                }
                for (i = len; i < expected_len; ++i) {
                    pw.write("Missing expected value: " + expected[i] + " at position " + i);
                }
            }
        }
        this.getServletContext().removeAttribute("arraylist");
        ServletTestUtil.printResult(pw, (boolean)pass);
    }
}

