/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.security.clientcert;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import servlet.tck.common.client.AbstractTckTest;
import servlet.tck.spec.security.clientcert.ServletSecTestServlet;
import servlet.tck.util.WebUtil;

public class ClientCertTests
extends AbstractTckTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientCertTests.class);
    @ArquillianResource
    @OperateOnDeployment(value="webapp-https")
    URL urlHttps;
    private String hostname = null;
    private int portnum = 0;
    private String tlsVersion;
    private String pageBase = "/clientcert_web";
    private String authorizedPage = "/ServletSecTest";
    private String user = null;
    private final String webHostProp = "webServerHost";
    private final String webPortProp = "webServerPort";
    private final String failString = "FAILED!";
    private final String username = "CN=CTS, OU=Java Software, O=Sun Microsystems Inc., L=Burlington, ST=MA, C=US";
    private String request = null;
    private WebUtil.Response response = null;
    private HostnameVerifier hostnameVerifier;

    @Deployment(testable=false, name="webapp-https")
    @TargetsContainer(value="https")
    public static WebArchive getTestArchive() throws Exception {
        System.setProperty("jdk.internal.httpclient.disableHostnameVerification", Boolean.TRUE.toString());
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"clientcert_web.war")).addClasses(new Class[]{ServletSecTestServlet.class})).addAsWebInfResource("servlet/tck/spec/security/clientcert/clientcert_web.war.sun-web.xml", "sun-web.xml")).setWebXML(ClientCertTests.class.getResource("clientcert_web.xml"));
    }

    public static void addCertificateToContainerTrustStore(String alias, Certificate clientCertificate) {
        Path cacertsPath = Paths.get(System.getProperty("keystore.path"), new String[0]);
        String domain = System.getProperty("domain1");
        if (!cacertsPath.toFile().exists()) {
            throw new IllegalStateException("The container trust store at " + String.valueOf(cacertsPath.toAbsolutePath()) + " does not exists");
        }
        LOGGER.info("*** Adding certificate to container trust store: " + String.valueOf(cacertsPath.toAbsolutePath()));
        KeyStore keyStore = null;
        try (FileInputStream in = new FileInputStream(cacertsPath.toAbsolutePath().toFile());){
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(in, "changeit".toCharArray());
            Certificate existingCertificate = keyStore.getCertificate(alias);
            if (!clientCertificate.equals(existingCertificate)) {
                keyStore.setCertificateEntry(alias, clientCertificate);
                keyStore.store(new FileOutputStream(cacertsPath.toAbsolutePath().toFile()), "changeit".toCharArray());
            } else {
                System.out.println("Server's truststore already contains certificate");
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Path getAdminCliJar() {
        return Paths.get(System.getProperty("glassfish.home"), "glassfish/modules/admin-cli.jar");
    }

    private static void restartDomain() throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder("java", "-jar", ClientCertTests.getAdminCliJar().toAbsolutePath().toString(), "restart-domain", "domain1").inheritIO();
        processBuilder.start();
    }

    @Override
    public void setup(String[] args, Properties p) throws Exception {
        this.hostname = this.urlHttps.getHost();
        if ("localhost".equals(this.hostname)) {
            this.hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
            HttpsURLConnection.setDefaultHostnameVerifier((hostname, sslSession) -> hostname.equals("localhost"));
        }
        p.setProperty("webServerHost", this.hostname);
        this.portnum = Integer.getInteger("securedWebServicePort", this.urlHttps.getPort());
        p.setProperty("securedWebServicePort", Integer.toString(this.portnum));
        this.tlsVersion = System.getProperty("client.cert.test.jdk.tls.client.protocols", p.getProperty("client.cert.test.jdk.tls.client.protocols"));
        this.logger.info("securedWebServicePort = {}", (Object)p.getProperty("securedWebServicePort"));
        if (this.tlsVersion != null) {
            this.logger.info("client.cert.test.jdk.tls.client.protocols = {}", (Object)this.tlsVersion);
        }
    }

    @Override
    @AfterEach
    public void cleanup() {
        if (this.hostnameVerifier != null) {
            HttpsURLConnection.setDefaultHostnameVerifier(this.hostnameVerifier);
        }
    }

    @Test
    public void clientCertTest() throws Exception {
        String testName = "clientCertTest";
        String url = this.getURLString("https", this.hostname, this.portnum, this.pageBase.substring(1) + this.authorizedPage);
        if (this.tlsVersion != null) {
            System.setProperty("jdk.tls.client.protocols", this.tlsVersion);
        }
        URL newURL = new URL(url);
        URLConnection httpsURLConn = this.getHttpsURLConnection(newURL);
        try (InputStream content = httpsURLConn.getInputStream();
             BufferedReader in = new BufferedReader(new InputStreamReader(content));){
            String line;
            StringBuilder output = new StringBuilder();
            while ((line = in.readLine()) != null) {
                output.append(line);
                this.logger.trace("line: {}", (Object)line);
            }
            String userNameToSearch = "CN=CTS, OU=Java Software, O=Sun Microsystems Inc., L=Burlington, ST=MA, C=US";
            if (output.indexOf(userNameToSearch) == -1) {
                throw new Exception(testName + ": getRemoteUser(): - did not find \"" + userNameToSearch + "\" in log.");
            }
            this.logger.debug("Additional verification done");
            this.verifyTestOutput(output.toString(), testName);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new Exception(testName + ": FAILED", e);
        }
    }

    public void verifyTestOutput(String output, String testName) throws Exception {
        if (!output.contains(testName + ": PASSED")) {
            this.logger.error("Test {} Not Expected String from the output = {}: PASSED", (Object)testName, (Object)output);
            throw new Exception(testName + ": FAILED");
        }
    }
}

