/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.common.servlets;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import servlet.tck.common.servlets.RequestTests;

public class HttpRequestTestServlet
extends HttpServlet {
    private static final String TEST_HEADER = "testname";
    private static final Class<?>[] HTTP_TEST_ARGS = new Class[]{PrintWriter.class, HttpServletRequest.class, HttpServletResponse.class};
    private static final Class<?>[] TEST_ARGS = new Class[]{PrintWriter.class, ServletRequest.class, ServletResponse.class};
    private static final Class<?>[][] ALL_TYPES = new Class[][]{TEST_ARGS, HTTP_TEST_ARGS};

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        String test = servletRequest.getParameter(TEST_HEADER).trim();
        servletRequest.setAttribute("servletContext", (Object)this.getServletConfig().getServletContext());
        PrintWriter pw = servletResponse.getWriter();
        Method method = null;
        for (Class<?>[] allType : ALL_TYPES) {
            try {
                method = RequestTests.class.getDeclaredMethod(test, allType);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        if (method == null) {
            throw new ServletException("No such test: " + test);
        }
        this.invokeTest(method, new Object[]{pw, servletRequest, servletResponse});
    }

    private void invokeTest(Method toBeInvoked, Object[] paramValues) throws ServletException {
        try {
            toBeInvoked.invoke(null, paramValues);
        }
        catch (InvocationTargetException ite) {
            throw new ServletException(ite.getTargetException());
        }
        catch (Throwable t) {
            throw new ServletException("Error executing test: " + toBeInvoked.getName(), t);
        }
    }
}

