/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet_http.readlistener;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import servlet.tck.api.jakarta_servlet_http.readlistener.TestListener;
import servlet.tck.api.jakarta_servlet_http.readlistener.TestServlet;
import servlet.tck.common.client.AbstractTckTest;
import servlet.tck.common.util.ServletTestUtil;

public class ReadListenerTests
extends AbstractTckTest {
    @BeforeEach
    public void setupServletName() throws Exception {
        this.setServletName("TestServlet");
    }

    @Deployment(testable=false)
    public static WebArchive getTestArchive() throws Exception {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"servlet_jsh_readlistener.war")).addClasses(new Class[]{TestServlet.class, TestListener.class});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void nioInputTest() throws Exception {
        int sleepInSeconds = Integer.parseInt(this._props.getProperty("servlet_async_wait").trim());
        boolean passed = true;
        String EXPECTED_RESPONSE = "=onDataAvailable|=Hello|=onDataAvailable|=World|=onAllDataRead";
        BufferedReader input = null;
        BufferedWriter output = null;
        String requestUrl = this.getContextRoot() + "/" + this.getServletName();
        try {
            URL url = this.getURL("http", this._hostname, this._port, requestUrl.substring(1));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            this.logger.debug("Connecting {}", (Object)url.toExternalForm());
            conn.setRequestProperty("Content-type", "text/plain; charset=utf-8");
            conn.setChunkedStreamingMode(5);
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            this.logger.debug(" Header {}", (Object)conn);
            conn.connect();
            try {
                String line;
                output = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream()));
                try {
                    String data = "Hello";
                    output.write(data);
                    output.flush();
                    Thread.sleep(sleepInSeconds * 1000);
                    data = "World";
                    output.write(data);
                    output.flush();
                    output.close();
                }
                catch (Exception ex) {
                    passed = false;
                    this.logger.error("======= Exception sending message: " + ex.getMessage(), (Throwable)ex);
                }
                input = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder message_received = new StringBuilder();
                while ((line = input.readLine()) != null) {
                    this.logger.debug("======= message received: {}", (Object)line);
                    message_received.append(line);
                }
                passed = ServletTestUtil.compareString(EXPECTED_RESPONSE, message_received.toString());
            }
            catch (Exception ex) {
                passed = false;
                this.logger.error("Exception: " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception ex) {
                    this.logger.error("Fail to close BufferedReader" + ex.getMessage(), (Throwable)ex);
                }
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception ex) {
                    this.logger.error("Fail to close BufferedWriter" + ex.getMessage(), (Throwable)ex);
                }
            }
        }
        catch (Exception ex3) {
            passed = false;
            this.logger.error("Test" + ex3.getMessage(), (Throwable)ex3);
        }
        if (!passed) {
            throw new Exception("Test Failed.");
        }
    }
}

