/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.common.request;

import java.util.Properties;
import servlet.tck.common.client.BaseTckTest;

public abstract class SecBasicClient
extends BaseTckTest {
    private static final String USERNAME = "user";
    private static final String PASSWORD = "password";
    private static final String UNAUTH_USERNAME = "authuser";
    private static final String UNAUTH_PASSWORD = "authpassword";
    private static final String CLASS_TRACE_HEADER = "[SecBasicClient]: ";
    private static final String USER_PRINCIPAL_SEARCH = "The user principal is: ";
    private static final String REMOTE_USER_SEARCH = "getRemoteUser(): ";
    protected String pageSec = null;
    protected String pageGuest = null;
    protected String pageUnprotected = null;
    protected String pageRoleReverse = null;
    private String pageJspBase = "/jsp_sec_secbasic_web";
    private String pageJspSec = this.pageJspBase + "/jspSec.jsp";
    private String pageJspGuest = this.pageJspBase + "/guestPage.jsp";
    private String pageJspUnprotected = this.pageJspBase + "/unprotected.jsp";
    private String pageJspRoleReverse = this.pageJspBase + "/rolereverse.jsp";
    private String pageServletBase = "/servlet_sec_secbasic_web";
    private String pageServletSec = this.pageServletBase + "/ServletSecTest";
    private String pageServletGuest = this.pageServletBase + "/GuestPageTest";
    private String pageServletUnprotected = this.pageServletBase + "/UnProtectedTest";
    private String pageServletRoleReverse = this.pageServletBase + "/RoleReverseTest";
    private String username = null;
    private String password = null;
    private String unauthUsername = null;
    private String unauthPassword = null;

    @Override
    public void setup(String[] args, Properties p) throws Exception {
        super.setup(args, p);
        p.setProperty(USERNAME, "j2ee");
        p.setProperty(PASSWORD, "j2ee");
        p.setProperty(UNAUTH_USERNAME, "javajoe");
        p.setProperty(UNAUTH_PASSWORD, "javajoe");
        try {
            this.username = p.getProperty(USERNAME);
            this.password = p.getProperty(PASSWORD);
            this.unauthUsername = p.getProperty(UNAUTH_USERNAME);
            this.unauthPassword = p.getProperty(UNAUTH_PASSWORD);
            this.pageSec = this.pageServletSec;
            this.pageGuest = this.pageServletGuest;
            this.pageUnprotected = this.pageServletUnprotected;
            this.pageRoleReverse = this.pageServletRoleReverse;
        }
        catch (Exception e) {
            this.logErr("Error: got exception: ", e);
        }
    }

    public void test1() throws Exception {
        this.logMessage("Sending request to validate presence of www-authenticate header...");
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecBasic/Test1");
        ((Properties)TEST_PROPS.get()).setProperty("request", SecBasicClient.getRequestLine("GET", this.pageSec));
        ((Properties)TEST_PROPS.get()).setProperty("expected_headers", "www-authenticate:<somevalue>");
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "401");
        this.invoke();
        this.dumpResponse();
        this.logMessage("Authentication requested");
    }

    public void test2() throws Exception {
        this.logMessage("Sending request with Authroization header...");
        StringBuilder sb = new StringBuilder(100);
        sb.append(USER_PRINCIPAL_SEARCH).append(this.username).append("|");
        sb.append(REMOTE_USER_SEARCH).append(this.username).append("|");
        sb.append("isUserInRole(\"ADM\"): !true!").append("|");
        sb.append("isUserInRole(\"MGR\"): !false!").append("|");
        sb.append("isUserInRole(\"VP\"): !false!").append("|");
        sb.append("isUserInRole(\"EMP\"): !true!").append("|");
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecBasic/Test2");
        ((Properties)TEST_PROPS.get()).setProperty("request", SecBasicClient.getRequestLine("GET", this.pageSec));
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.username);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
        ((Properties)TEST_PROPS.get()).setProperty("search_string", sb.toString());
        this.invoke();
        this.dumpResponse();
        this.logMessage("isUserInRole() and getRemoteUser() returned expected results");
    }

    public void test3() throws Exception {
        this.logMessage("Sending an request for a protected resource with invalid username/password...");
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecBasic/Test3");
        ((Properties)TEST_PROPS.get()).setProperty("request", SecBasicClient.getRequestLine("GET", this.pageSec));
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", "invalid");
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "401");
        this.invoke();
        this.dumpResponse();
        this.logMessage("Access Denied");
    }

    public void test4() throws Exception {
        StringBuilder sb = new StringBuilder(100);
        sb.append(USER_PRINCIPAL_SEARCH).append(this.unauthUsername);
        this.logMessage("Sending request to resource the user has access to...");
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecBasic/Test4");
        ((Properties)TEST_PROPS.get()).setProperty("request", SecBasicClient.getRequestLine("GET", this.pageGuest));
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.unauthUsername);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.unauthPassword);
        ((Properties)TEST_PROPS.get()).setProperty("search_string", sb.toString());
        this.invoke();
        this.dumpResponse();
        this.logMessage("User successfully accessed the resource");
        this.logMessage("Sending request to resource with valid username/password, but not the right roles...");
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecBasic/Test4");
        ((Properties)TEST_PROPS.get()).setProperty("request", SecBasicClient.getRequestLine("GET", this.pageSec));
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.unauthUsername);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.unauthPassword);
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "403");
        this.invoke();
        this.dumpResponse();
        this.logMessage("Access Forbidden");
    }

    public void test5() throws Exception {
        StringBuilder sb = new StringBuilder(100);
        sb.append(USER_PRINCIPAL_SEARCH).append("|");
        sb.append(REMOTE_USER_SEARCH).append("null");
        this.logMessage("Sending request to unprotected resource....");
        ((Properties)TEST_PROPS.get()).setProperty("testname", "BasicSec/Test5");
        ((Properties)TEST_PROPS.get()).setProperty("request", SecBasicClient.getRequestLine("GET", this.pageUnprotected));
        ((Properties)TEST_PROPS.get()).setProperty("search_string", sb.toString());
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_response_match", "!true!");
        this.invoke();
        this.dumpResponse();
        this.logMessage("isUserInRole() and getRemoteUser() returned expected results");
    }

    public void test6() throws Exception {
        StringBuilder sb = new StringBuilder(100);
        sb.append(USER_PRINCIPAL_SEARCH).append(this.username).append("|");
        sb.append("isUserInRole(\"ADM\"): !false!").append("|");
        sb.append("isUserInRole(\"MGR\"): !true!").append("|");
        sb.append("isUserInRole(\"VP\"): !false!").append("|");
        sb.append("isUserInRole(\"EMP\"): !true!").append("|");
        this.logMessage("Sending request to validate isUserInRole with roles reversed...");
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecBasic/Test6");
        ((Properties)TEST_PROPS.get()).setProperty("request", SecBasicClient.getRequestLine("GET", this.pageRoleReverse));
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.username);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
        ((Properties)TEST_PROPS.get()).setProperty("search_string", sb.toString());
        this.invoke();
        this.dumpResponse();
        this.logMessage("isUserInRole() and getRemoteUser() returned expected results");
    }

    public void test7() throws Exception {
        this.logMessage("Sending an request for a protected resource with invalid username/password...");
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecBasic/Test7");
        ((Properties)TEST_PROPS.get()).setProperty("request", SecBasicClient.getRequestLine("GET", this.pageSec + "/j_security_check"));
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", "invalid");
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "401,404");
        this.invoke();
        this.dumpResponse();
        if (this._testCase != null && this._testCase.getResponse() != null) {
            String searchString = "Inside  ServletSecTestServlet";
            try {
                if (this._testCase.getResponse().getResponseBodyAsString().contains(searchString)) {
                    this.logger.error("(Should say: \"" + searchString + "\")");
                    throw new Exception("test7 failed.");
                }
            }
            catch (Exception ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        this.logMessage("Access properly Denied");
    }

    private static String getRequestLine(String method, String path) {
        return method + " " + path + " HTTP/1.1";
    }

    protected void logMessage(String message) {
        this.logger.info("{} {}", (Object)CLASS_TRACE_HEADER, (Object)message);
    }

    private void trace(String message) {
        this.logger.trace("{} {}", (Object)CLASS_TRACE_HEADER, (Object)message);
    }

    private void dumpResponse() {
        try {
            if (this._testCase != null && this._testCase.getResponse() != null) {
                this.trace(this._testCase.getResponse().getResponseBodyAsString());
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

