/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet_http.httpservletrequest;

import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import servlet.tck.api.jakarta_servlet_http.httpservletrequest.GetParameterNamesEmptyEnumTestServlet;
import servlet.tck.api.jakarta_servlet_http.httpservletrequest.GetQueryStringNullTestServlet;
import servlet.tck.api.jakarta_servlet_http.httpservletrequest.GetReaderUnsupportedEncodingExceptionTestServlet;
import servlet.tck.api.jakarta_servlet_http.httpservletrequest.GetServletPathEmptyStringTestServlet;
import servlet.tck.api.jakarta_servlet_http.httpservletrequest.SetCharacterEncodingTest;
import servlet.tck.api.jakarta_servlet_http.httpservletrequest.SetCharacterEncodingUnsupportedEncodingExceptionTest;
import servlet.tck.api.jakarta_servlet_http.httpservletrequest.doHeadTest;
import servlet.tck.api.jakarta_servlet_http.httpservletrequest.getServletContextTest;
import servlet.tck.common.request.Header;
import servlet.tck.common.request.HttpExchange;
import servlet.tck.common.request.HttpRequestClient;
import servlet.tck.common.request.HttpResponse;
import servlet.tck.common.servlets.CommonServlets;

public class HttpServletRequestTests
extends HttpRequestClient {
    @BeforeEach
    public void setupServletName() throws Exception {
        this.setServletName("TestServlet");
    }

    @Deployment(testable=false)
    public static WebArchive getTestArchive() throws Exception {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"servlet_jsh_httpservletrequest_web.war")).addAsLibraries((Archive[])CommonServlets.getCommonServletsArchive())).addClasses(new Class[]{GetParameterNamesEmptyEnumTestServlet.class, GetQueryStringNullTestServlet.class, GetReaderUnsupportedEncodingExceptionTestServlet.class, doHeadTest.class, getServletContextTest.class, GetServletPathEmptyStringTestServlet.class, SetCharacterEncodingTest.class, SetCharacterEncodingUnsupportedEncodingExceptionTest.class})).setWebXML(HttpServletRequestTests.class.getResource("servlet_jsh_httpservletrequest_web.xml"));
    }

    @Override
    @Test
    public void getAttributeNamesTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getAttributeNamesTest");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getAttributeNamesEmptyEnumTest");
        this.invoke();
    }

    @Override
    @Test
    public void getAttributeTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getAttributeTest");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getAttributeDoesNotExistTest");
        this.invoke();
    }

    @Override
    @Test
    public void getCharacterEncodingTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getCharacterEncodingTest");
        ((Properties)TEST_PROPS.get()).setProperty("request_headers", "Content-Type:text/plain; charset=ISO-8859-1");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getCharacterEncodingNullTest");
        this.invoke();
    }

    @Override
    @Test
    public void getLocaleTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getLocaleTest");
        ((Properties)TEST_PROPS.get()).setProperty("request_headers", "Accept-Language:en-US");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getLocaleDefaultTest");
        this.invoke();
    }

    @Override
    @Test
    public void getLocalesTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getLocalesTest");
        ((Properties)TEST_PROPS.get()).setProperty("request_headers", "Accept-Language:en-US,en-GB");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getLocalesDefaultTest");
        this.invoke();
    }

    @Override
    @Test
    public void getParameterNamesTest() throws Exception {
        String testName = "getParameterNamesTest";
        ((Properties)TEST_PROPS.get()).setProperty("testname", testName);
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=value1&parameter2=value2 HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test PASSED");
        this.invoke();
        testName = "getParameterNamesEmptyEnumTest";
        ((Properties)TEST_PROPS.get()).setProperty("testname", testName);
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + testName + " HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Override
    @Test
    public void getParameterTest() throws Exception {
        String testName = "getParameterTest";
        ((Properties)TEST_PROPS.get()).setProperty("testname", testName);
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&parameter1=value1 HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test PASSED");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getParameterDoesNotExistTest");
        this.invoke();
    }

    @Override
    @Test
    public void getParameterValuesTest() throws Exception {
        String testName = "getParameterValuesTest";
        ((Properties)TEST_PROPS.get()).setProperty("testname", testName);
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + "&Names=value1&Names=value2 HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test PASSED");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getParameterValuesDoesNotExistTest");
        this.invoke();
    }

    @Test
    public void getServletContextTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/getServletContextTest HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_response_match", "Test FAILED");
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "200");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void doHeadTest() throws Exception {
        HttpExchange requestGet = new HttpExchange("GET " + this.getContextRoot() + "/doHeadTest HTTP/1.1", this._hostname, this._port);
        HttpExchange requestHead = new HttpExchange("HEAD " + this.getContextRoot() + "/doHeadTest HTTP/1.1", this._hostname, this._port);
        try {
            HttpResponse responseGet = requestGet.execute();
            HttpResponse responseHead = requestHead.execute();
            String responseBodyGet = responseGet.getResponseBodyAsString();
            if (responseBodyGet == null || responseBodyGet.isEmpty()) {
                throw new Exception("GET request did not include a response body");
            }
            String responseBodyHead = responseHead.getResponseBodyAsRawString();
            if (responseBodyHead != null && !responseBodyHead.isEmpty()) {
                throw new Exception("HEAD request included a response body");
            }
            List<Header> headersGet = responseGet.getResponseHeaders();
            Set headersToMatch = headersGet.stream().map(Header::getName).filter(name -> !name.toLowerCase(Locale.ENGLISH).equals("date")).filter(name -> !name.toLowerCase(Locale.ENGLISH).equals("content-length")).filter(name -> !name.toLowerCase(Locale.ENGLISH).equals("vary")).filter(name -> !name.toLowerCase(Locale.ENGLISH).equals("transfer-encoding")).collect(Collectors.toSet());
            List<Header> headersHead = responseHead.getResponseHeaders();
            for (Header header : headersHead) {
                if (header.getName().equalsIgnoreCase("date") || header.getName().equalsIgnoreCase("content-length") || header.getName().equalsIgnoreCase("vary") || header.getName().equalsIgnoreCase("transfer-encoding") || headersToMatch.remove(header.getName())) continue;
                throw new Exception("HEAD request contained header that was not present for GET: " + header);
            }
            if (!headersToMatch.isEmpty()) {
                throw new Exception("HEAD request did not contain header that was present for GET:" + (String)headersToMatch.iterator().next());
            }
        }
        catch (Throwable t) {
            throw new Exception("Exception occurred:" + t, t);
        }
    }

    @Override
    @Test
    public void getAuthTypeWithoutProtectionTest() throws Exception {
        super.getAuthTypeWithoutProtectionTest();
    }

    @Override
    @Test
    public void getContentLengthTest() throws Exception {
        super.getContentLengthTest();
    }

    @Override
    @Test
    public void getContentTypeTest() throws Exception {
        super.getContentTypeTest();
    }

    @Override
    @Test
    public void getContextPathTest() throws Exception {
        super.getContextPathTest();
    }

    @Override
    @Test
    public void getCookiesNoCookiesTest() throws Exception {
        super.getCookiesNoCookiesTest();
    }

    @Override
    @Test
    public void getCookiesTest() throws Exception {
        super.getCookiesTest();
    }

    @Override
    @Test
    public void getDateHeaderIllegalArgumentExceptionTest() throws Exception {
        super.getDateHeaderIllegalArgumentExceptionTest();
    }

    @Override
    @Test
    public void getDateHeaderNoHeaderTest() throws Exception {
        super.getDateHeaderNoHeaderTest();
    }

    @Override
    @Test
    public void getDateHeaderTest() throws Exception {
        super.getDateHeaderTest();
    }

    @Override
    @Test
    public void getHeaderNamesTest() throws Exception {
        super.getHeaderNamesTest();
    }

    @Override
    @Test
    public void getHeaderNoHeaderTest() throws Exception {
        super.getHeaderNoHeaderTest();
    }

    @Override
    @Test
    public void getHeaderTest() throws Exception {
        super.getHeaderTest();
    }

    @Override
    @Test
    public void getHeadersNoHeadersTest() throws Exception {
        super.getHeadersNoHeadersTest();
    }

    @Override
    @Test
    public void getHeadersTest() throws Exception {
        super.getHeadersTest();
    }

    @Override
    @Test
    public void getInputStreamIllegalStateExceptionTest() throws Exception {
        super.getInputStreamIllegalStateExceptionTest();
    }

    @Override
    @Test
    public void getInputStreamTest() throws Exception {
        super.getInputStreamTest();
    }

    @Override
    @Test
    public void getIntHeaderNoHeaderTest() throws Exception {
        super.getIntHeaderNoHeaderTest();
    }

    @Override
    @Test
    public void getIntHeaderNumberFoundExceptionTest() throws Exception {
        super.getIntHeaderNumberFoundExceptionTest();
    }

    @Override
    @Test
    public void getIntHeaderTest() throws Exception {
        super.getIntHeaderTest();
    }

    @Override
    @Test
    public void getLocalAddrTest() throws Exception {
        super.getLocalAddrTest();
    }

    @Override
    @Test
    public void getLocalPortTest() throws Exception {
        super.getLocalPortTest();
    }

    @Override
    @Test
    public void getMethodTest() throws Exception {
        super.getMethodTest();
    }

    @Override
    @Test
    public void getParameterMapTest() throws Exception {
        super.getParameterMapTest();
    }

    @Override
    @Test
    public void getPathInfoNullTest() throws Exception {
        super.getPathInfoNullTest();
    }

    @Override
    @Test
    public void getPathInfoTest() throws Exception {
        super.getPathInfoTest();
    }

    @Override
    @Test
    public void getPathTranslatedNullTest() throws Exception {
        super.getPathTranslatedNullTest();
    }

    @Override
    @Test
    public void getPathTranslatedTest() throws Exception {
        super.getPathTranslatedTest();
    }

    @Override
    @Test
    public void getProtocolTest() throws Exception {
        super.getProtocolTest();
    }

    @Override
    @Test
    public void getQueryStringNullTest() throws Exception {
        super.getQueryStringNullTest();
    }

    @Override
    @Test
    public void getQueryStringTest() throws Exception {
        super.getQueryStringTest();
    }

    @Override
    @Test
    public void getReaderIllegalStateExceptionTest() throws Exception {
        super.getReaderIllegalStateExceptionTest();
    }

    @Override
    @Test
    public void getReaderTest() throws Exception {
        super.getReaderTest();
    }

    @Override
    @Test
    public void getReaderUnsupportedEncodingExceptionTest() throws Exception {
        super.getReaderUnsupportedEncodingExceptionTest();
    }

    @Override
    @Test
    public void getRemoteAddrTest() throws Exception {
        super.getRemoteAddrTest();
    }

    @Override
    @Test
    public void getRemoteHostTest() throws Exception {
        super.getRemoteHostTest();
    }

    @Override
    @Test
    public void getRemoteUserTest() throws Exception {
        super.getRemoteUserTest();
    }

    @Override
    @Test
    public void getRequestDispatcherTest() throws Exception {
        super.getRequestDispatcherTest();
    }

    @Override
    @Test
    public void getRequestURITest() throws Exception {
        super.getRequestURITest();
    }

    @Override
    @Test
    public void getRequestURLTest() throws Exception {
        super.getRequestURLTest();
    }

    @Override
    @Test
    public void getRequestedSessionIdNullTest() throws Exception {
        super.getRequestedSessionIdNullTest();
    }

    @Override
    @Test
    public void getRequestedSessionIdTest1() throws Exception {
        super.getRequestedSessionIdTest1();
    }

    @Override
    @Test
    public void getRequestedSessionIdTest2() throws Exception {
        super.getRequestedSessionIdTest2();
    }

    @Override
    @Test
    public void getSchemeTest() throws Exception {
        super.getSchemeTest();
    }

    @Override
    @Test
    public void getServerNameTest() throws Exception {
        super.getServerNameTest();
    }

    @Override
    @Test
    public void getServerPortTest() throws Exception {
        super.getServerPortTest();
    }

    @Override
    @Test
    public void getServletPathEmptyStringTest() throws Exception {
        super.getServletPathEmptyStringTest();
    }

    @Override
    @Test
    public void getServletPathTest() throws Exception {
        super.getServletPathTest();
    }

    @Override
    @Test
    public void getSessionFalseTest() throws Exception {
        super.getSessionFalseTest();
    }

    @Override
    @Test
    public void getSessionTest() throws Exception {
        super.getSessionTest();
    }

    @Override
    @Test
    public void getSessionTrueTest() throws Exception {
        super.getSessionTrueTest();
    }

    @Override
    @Test
    public void isRequestedSessionIdFromCookieTest() throws Exception {
        super.isRequestedSessionIdFromCookieTest();
    }

    @Override
    @Test
    public void isRequestedSessionIdFromURLTest() throws Exception {
        super.isRequestedSessionIdFromURLTest();
    }

    @Override
    @Test
    public void isRequestedSessionIdValidTest() throws Exception {
        super.isRequestedSessionIdValidTest();
    }

    @Override
    @Test
    public void isSecureTest() throws Exception {
        super.isSecureTest();
    }

    @Override
    @Test
    public void removeAttributeTest() throws Exception {
        super.removeAttributeTest();
    }

    @Override
    @Test
    public void sessionTimeoutTest() throws Exception {
        super.sessionTimeoutTest();
    }

    @Override
    @Test
    public void setAttributeTest() throws Exception {
        super.setAttributeTest();
    }

    @Override
    @Test
    public void setCharacterEncodingTest() throws Exception {
        super.setCharacterEncodingTest();
    }

    @Override
    @Test
    public void setCharacterEncodingTest1() throws Exception {
        super.setCharacterEncodingTest1();
    }

    @Override
    @Test
    public void setCharacterEncodingUnsupportedEncodingExceptionTest() throws Exception {
        super.setCharacterEncodingUnsupportedEncodingExceptionTest();
    }
}

