/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet.scattributeevent;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextAttributeEvent;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import servlet.tck.common.servlets.GenericTCKServlet;
import servlet.tck.common.util.ServletTestUtil;
import servlet.tck.common.util.StaticLog;

public class TestServlet
extends GenericTCKServlet {
    public void constructorTest(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        ServletContextAttributeEvent scae = new ServletContextAttributeEvent(this.getServletContext(), "test", (Object)"value");
        if (scae == null) {
            passed = false;
            pw.println("The constructor for ServletContextEvent returned a null");
        } else {
            passed = true;
        }
        StaticLog.clear();
        ServletTestUtil.printResult(pw, passed);
    }

    public void addedTest(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        StaticLog.clear();
        Object[] expected = new String[]{"AttributeAdded:addTest,Attribute1"};
        ServletContext context = this.getServletContext();
        context.setAttribute("addTest", (Object)"Attribute1");
        ArrayList result = StaticLog.getClear();
        boolean passed = ServletTestUtil.checkArrayList(result, (String[])expected, true, false);
        if (!passed) {
            ServletTestUtil.printFailureData(pw, result, expected);
        }
        context.removeAttribute("addTest");
        ServletTestUtil.printResult(pw, passed);
    }

    public void removedTest(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        StaticLog.clear();
        Object[] expected = new String[]{"AttributeAdded:removeTest,Attribute1", "AttributeRemoved:removeTest,Attribute1"};
        ServletContext context = this.getServletContext();
        context.setAttribute("removeTest", (Object)"Attribute1");
        context.removeAttribute("removeTest");
        ArrayList result = StaticLog.getClear();
        boolean passed = ServletTestUtil.checkArrayList(result, (String[])expected, true, false);
        if (!passed) {
            ServletTestUtil.printFailureData(pw, result, expected);
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void replacedTest(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        StaticLog.clear();
        Object[] expected = new String[]{"AttributeAdded:replacedTest,Attribute1", "AttributeReplaced:replacedTest,Attribute1"};
        ServletContext context = this.getServletContext();
        context.setAttribute("replacedTest", (Object)"Attribute1");
        context.setAttribute("replacedTest", (Object)"Attribute2");
        ArrayList result = StaticLog.getClear();
        boolean passed = ServletTestUtil.checkArrayList(result, (String[])expected, true, false);
        if (!passed) {
            ServletTestUtil.printFailureData(pw, result, expected);
        }
        context.removeAttribute("replacedTest");
        ServletTestUtil.printResult(pw, passed);
    }
}

