/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.jaxrs40.ee.rs.core.uriinfo;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.jaxrs40.ee.rs.core.uriinfo.TSAppConfig;
import ee.jakarta.tck.ws.rs.jaxrs40.ee.rs.core.uriinfo.UriInfoTestResource;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class UriInfo40ClientIT
extends JAXRSCommonClient {
    protected static final String ROOT = "jaxrs40_ee_core_uriinfo_web";
    protected static final String RESOURCE = "app/resource";

    public UriInfo40ClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs40_ee_core_uriinfo_web/app/resource");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs40_ee_core_uriinfo_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, UriInfoTestResource.class});
        return archive;
    }

    @Test
    public void getMatchedResourceTemplateOneTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "one/azazaz00"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "/app/resource/one/{name:[a-zA-Z][a-zA-Z_0-9]*}");
        this.invoke();
    }

    @Test
    public void getMatchedResourceTemplateTwoGetTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "two/P/abc/MyNumber"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "/app/resource/two/{Prefix}{p:/?}{id: ((\\d+)?)}/abc{p2:/?}{number: (([A-Za-z0-9]*)?)}");
        this.invoke();
    }

    @Test
    public void getMatchedResourceTemplateTwoPostTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "two/P/abc/MyNumber"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "/app/resource/two/{Prefix}{p:/?}{id: ((\\d+)?)}/abc/{yeah}");
        this.invoke();
    }

    @Test
    public void getMatchedResourceTemplateSubTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.PUT, "three/a/z"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "/app/resource/three/{x:[a-z]}/{x:[a-z]}");
        this.invoke();
    }
}

