/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.common.client;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsWebTestCase;
import ee.jakarta.tck.ws.rs.common.client.TextCaser;
import ee.jakarta.tck.ws.rs.common.webclient.TestFailureException;
import ee.jakarta.tck.ws.rs.common.webclient.validation.CheckOneOfStatusesTokenizedValidator;
import ee.jakarta.tck.ws.rs.lib.util.BASE64Encoder;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JaxrsCommonClient
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1L;
    protected transient JaxrsWebTestCase testCase;
    protected boolean isTestCaseAfterInvocation;
    protected List<Client> clients = new LinkedList<Client>();

    protected void setTestProperties(JaxrsWebTestCase testCase) {
        TestUtil.logTrace("[JAXRSCommonClient] setTestProperties");
        if (TEST_PROPS.get((Object)JAXRSCommonClient.Property.STATUS_CODE) == null) {
            this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JaxrsCommonClient.getStatusCode(Response.Status.OK));
        }
        this.setWebTestCaseProperties(testCase);
    }

    protected void setWebTestCaseProperties(JaxrsWebTestCase testCase) {
        JAXRSCommonClient.Property key = null;
        String value = null;
        Enumeration e = TEST_PROPS.keys();
        block28: while (e.hasMoreElements()) {
            key = (JAXRSCommonClient.Property)((Object)e.nextElement());
            value = (String)TEST_PROPS.get((Object)key);
            switch (key) {
                case APITEST: {
                    break;
                }
                case BASIC_AUTH_PASSWD: 
                case BASIC_AUTH_REALM: {
                    break;
                }
                case BASIC_AUTH_USER: {
                    String user = (String)TEST_PROPS.get((Object)JAXRSCommonClient.Property.BASIC_AUTH_USER);
                    String password = (String)TEST_PROPS.get((Object)JAXRSCommonClient.Property.BASIC_AUTH_PASSWD);
                    String base64 = new BASE64Encoder().encode((user + ":" + password).getBytes());
                    testCase.addHeader("Authorization", " Basic " + base64);
                    break;
                }
                case CONTENT: {
                    testCase.setEntity(value);
                    break;
                }
                case DONOTUSEServletName: {
                    break;
                }
                case EXPECT_RESPONSE_BODY: {
                    break;
                }
                case EXPECTED_HEADERS: {
                    testCase.addExpectedHeader(value);
                    break;
                }
                case FOLLOW_REDIRECT: {
                    TestUtil.logTrace("##########Found redirect Property");
                    this._redirect = true;
                    break;
                }
                case GOLDENFILE: {
                    StringBuffer sb = new StringBuffer(50);
                    sb.append(this._tsHome).append(this.GOLDENFILEDIR);
                    sb.append(this._generalURI).append("/");
                    sb.append(value);
                    testCase.setGoldenFilePath(sb.toString());
                    break;
                }
                case IGNORE_BODY: {
                    testCase.setGoldenFilePath(null);
                    break;
                }
                case IGNORE_STATUS_CODE: {
                    testCase.setExpectedStatusCode("-1");
                    break;
                }
                case REASON_PHRASE: {
                    testCase.setExpectedReasonPhrase(value);
                    break;
                }
                case REQUEST: {
                    testCase.setUrlRequest(value);
                    break;
                }
                case REQUEST_HEADERS: {
                    String[] headers;
                    for (String header : headers = JaxrsCommonClient.splitByColon(value)) {
                        String[] split = header.split(":", 2);
                        testCase.addHeader(split[0].trim(), split[1].trim());
                    }
                    continue block28;
                }
                case RESPONSE_MATCH: {
                    break;
                }
                case SAVE_STATE: {
                    this._saveState = true;
                    break;
                }
                case SEARCH_STRING: {
                    value = testCase.getTextCaser().getCasedText(value);
                    testCase.setResponseSearchString(value);
                    break;
                }
                case SEARCH_STRING_IGNORE_CASE: {
                    testCase.setResponseSearchStringIgnoreCase(value);
                    break;
                }
                case STANDARD: {
                    break;
                }
                case STATUS_CODE: {
                    if (value.contains("|")) {
                        testCase.setStrategy(CheckOneOfStatusesTokenizedValidator.class.getName());
                    }
                    testCase.setExpectedStatusCode(value);
                    break;
                }
                case STRATEGY: {
                    testCase.setStrategy(value);
                    break;
                }
                case TEST_NAME: {
                    break;
                }
                case UNEXPECTED_HEADERS: {
                    testCase.addUnexpectedHeader(value);
                    break;
                }
                case UNEXPECTED_RESPONSE_MATCH: {
                    testCase.setUnexpectedResponseSearchString(value);
                    break;
                }
                case UNORDERED_SEARCH_STRING: {
                    value = testCase.getTextCaser().getCasedText(value);
                    testCase.setUnorderedSearchString(value);
                    break;
                }
                case USE_SAVED_STATE: {
                    this._useSavedState = true;
                }
            }
        }
    }

    protected static String[] splitByColon(String value) {
        int colonIndex = -1;
        int lastIndex = 0;
        LinkedList<String> list = new LinkedList<String>();
        while ((colonIndex = value.indexOf(124, lastIndex)) != -1) {
            list.add(value.substring(lastIndex, colonIndex));
            lastIndex = colonIndex + 1;
        }
        if (lastIndex < value.length()) {
            list.add(value.substring(lastIndex));
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    protected void invoke() throws JAXRSCommonClient.Fault {
        TestUtil.logTrace("[JAXRSCommonClient] invoke");
        try {
            this.getTestCase().setPort(this._port);
            this.getTestCase().setHostname(this._hostname);
            this.setTestProperties(this.testCase);
            TestUtil.logTrace("[JAXRSCommonClient] EXECUTING");
            if (this._useSavedState && this._state != null) {
                this.testCase.getRequest().setState(this._state);
            }
            if (this._redirect) {
                TestUtil.logTrace("##########Call setFollowRedirects");
                this.testCase.getRequest().setFollowRedirects(this._redirect);
            }
            this.testCase.execute();
            this.isTestCaseAfterInvocation = true;
            if (this._saveState) {
                this._state = this.testCase.getResponse().getState();
            }
        }
        catch (TestFailureException tfe) {
            Throwable t = tfe.getRootCause();
            if (t != null) {
                TestUtil.logErr("Root cause of Failure: " + t.getMessage(), t);
            }
            throw new JAXRSCommonClient.Fault("[JAXRSCommonClient] " + this._testName + " failed!  Check output for cause of failure.", tfe);
        }
        finally {
            this._useSavedState = false;
            this._saveState = false;
            this._redirect = false;
            this.clearTestProperties();
            this.clients.add(this.testCase.client);
        }
    }

    @Override
    public void cleanup() throws JAXRSCommonClient.Fault {
        super.cleanup();
        for (Client c : this.clients) {
            c.close();
        }
        this.clients.clear();
    }

    @Override
    public void setup() {
        super.setup();
        String property = System.getProperty("cts.tmp", "/tmp");
        if (property != null) {
            System.setProperty("java.io.tmpdir", property);
        }
    }

    protected JaxrsWebTestCase getTestCase() {
        if (this.testCase == null || this.isTestCaseAfterInvocation) {
            this.testCase = new JaxrsWebTestCase();
            this.isTestCaseAfterInvocation = false;
        }
        return this.testCase;
    }

    @Override
    protected String buildRequest(JAXRSCommonClient.Request type, String ... path) {
        this.getTestCase().setRequestType(type.name());
        StringBuilder sb = new StringBuilder();
        sb.append(this._contextRoot == null ? "" : this._contextRoot).append("/");
        for (String segment : path) {
            sb.append(segment);
        }
        return sb.toString();
    }

    @Override
    @Deprecated
    protected void setProperty(String key, String value) {
        super.setProperty(key, value);
    }

    @Override
    @Deprecated
    protected String buildRequest(String type, String ... path) {
        return super.buildRequest(type, path);
    }

    protected Response getResponse() {
        return this.testCase.getJaxrsResponse();
    }

    @Override
    protected String getResponseBody() {
        return this.getResponseBody(String.class);
    }

    protected <T> T getResponseBody(Class<T> clazz) {
        return (T)this.getResponse().readEntity(clazz);
    }

    public List<Object> getProvidersToRegister() {
        return this.getTestCase().getProvidersToRegister();
    }

    public void addProvider(Object providerToRegister) {
        this.getTestCase().addProviderToRegister(providerToRegister);
    }

    @Override
    protected String[] getResponseHeaders() throws JAXRSCommonClient.Fault {
        return JaxrsCommonClient.getMetadata((MultivaluedMap<String, Object>)this.getResponse().getMetadata());
    }

    protected void addHeader(String header, String ... values) {
        StringBuilder sb = new StringBuilder();
        sb.append(header).append(":");
        if (values != null) {
            for (String value : values) {
                sb.append(value);
            }
        }
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, sb.toString());
    }

    public static String[] getMetadata(MultivaluedMap<String, Object> metadata) {
        String[] headers = new String[metadata.size()];
        int i = 0;
        for (Map.Entry e : metadata.entrySet()) {
            headers[i++] = (String)e.getKey() + ":" + JaxrsCommonClient.listToString((List)e.getValue());
        }
        return headers;
    }

    @Override
    protected Response.Status getResponseStatusCode() {
        return Response.Status.fromStatusCode((int)this.getResponse().getStatus());
    }

    protected void setRequestContentEntity(Object object) {
        this.getTestCase().setEntity(object);
    }

    public static <T> String listToString(List<T> list) {
        StringBuilder sb = new StringBuilder();
        for (T s : list) {
            sb.append(s).append(" ");
        }
        return sb.toString().trim();
    }

    protected void printClientCall(boolean print) {
        this.getTestCase().setPrintClientCall(print);
    }

    protected void setAsynchronousProcessing() {
        this.getTestCase().setProcessingType(JaxrsWebTestCase.Execution.ASYNCHRONOUS);
    }

    protected void setPrintEntity(boolean printEntity) {
        this.getTestCase().setPrintEntity(printEntity);
    }

    protected void bufferEntity(boolean buffer) {
        this.getTestCase().bufferEntity(buffer);
    }

    protected void setTextCaser(TextCaser caser) {
        this.getTestCase().setTextCaser(caser);
    }
}

