/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util;

import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;

public class KeyDataPair
extends NameValuePair {
    private final File fileObject_;
    private final String fileName_;
    private final String mimeType_;
    private transient Charset charset_;
    private byte[] data_;

    public KeyDataPair(String key, File file, String fileName, String mimeType, String charset) {
        this(key, file, fileName, mimeType, Charset.forName(charset));
    }

    public KeyDataPair(String key, File file, String fileName, String mimeType, Charset charset) {
        this(key, file == null ? "" : file.getName(), file != null && file.exists() ? file : null, fileName, mimeType, charset, null);
    }

    private KeyDataPair(String name, String value, File file, String fileName, String mimeType, Charset charset, byte[] data) {
        super(name, value);
        this.fileObject_ = file;
        this.fileName_ = fileName;
        this.mimeType_ = mimeType;
        this.charset_ = charset;
        this.data_ = data;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public File getFile() {
        return this.fileObject_;
    }

    public String getFileName() {
        return this.fileName_;
    }

    public Charset getCharset() {
        return this.charset_;
    }

    public String getMimeType() {
        return this.mimeType_;
    }

    public byte[] getData() {
        return this.data_;
    }

    public void setData(byte[] data) {
        this.data_ = data;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.charset_ == null ? null : this.charset_.name());
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        String charsetName = (String)ois.readObject();
        if (charsetName != null) {
            this.charset_ = Charset.forName(charsetName);
        }
    }

    @Override
    public KeyDataPair normalized() {
        return new KeyDataPair(this.getName(), this.getValue(), this.fileObject_, this.fileName_, this.mimeType_, this.charset_, this.data_);
    }
}

