/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.beanManager.equivalence.qualifier;

import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.beanManager.equivalence.qualifier.Level;
import org.jboss.cdi.tck.tests.extensions.beanManager.equivalence.qualifier.Monster;
import org.jboss.cdi.tck.tests.extensions.beanManager.equivalence.qualifier.MonsterQualifier;
import org.jboss.cdi.tck.tests.extensions.beanManager.equivalence.qualifier.Troll;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class QualifierEquivalenceTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(QualifierEquivalenceTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_determining_hash", id="a")})
    public void testAreQualifiersEquivalent() {
        MonsterQualifier literal1 = new MonsterQualifier(){};
        MonsterQualifier literal2 = new MonsterQualifier(){

            @Override
            public String position() {
                return "dungeon";
            }
        };
        Annotation containerProvided = this.getContainerProvidedQualifier(this.getUniqueBean(Troll.class, literal1), Monster.class);
        Assert.assertTrue((boolean)this.getCurrentManager().areQualifiersEquivalent((Annotation)literal1, containerProvided));
        Assert.assertFalse((boolean)this.getCurrentManager().areQualifiersEquivalent((Annotation)literal2, containerProvided));
        Assert.assertFalse((boolean)this.getCurrentManager().areQualifiersEquivalent((Annotation)literal1, (Annotation)literal2));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_determining_hash", id="c")})
    public void testGetQualifierHashCode() {
        MonsterQualifier literal1 = new MonsterQualifier(){};
        MonsterQualifier literal2 = new MonsterQualifier(){

            @Override
            public int numberOfVictims() {
                return 7;
            }

            @Override
            public Level level() {
                return Level.B;
            }
        };
        Annotation containerProvided = this.getContainerProvidedQualifier(this.getUniqueBean(Troll.class, literal1), Monster.class);
        Assert.assertEquals((int)this.getCurrentManager().getQualifierHashCode((Annotation)literal1), (int)this.getCurrentManager().getQualifierHashCode(containerProvided));
        Assert.assertNotEquals((Object)this.getCurrentManager().getQualifierHashCode((Annotation)literal2), (Object)this.getCurrentManager().getQualifierHashCode(containerProvided));
        Assert.assertNotEquals((Object)this.getCurrentManager().getQualifierHashCode((Annotation)literal1), (Object)this.getCurrentManager().getQualifierHashCode((Annotation)literal2));
    }

    private Annotation getContainerProvidedQualifier(Bean<?> bean, Class<? extends Annotation> qualifierClass) {
        for (Annotation annotation : bean.getQualifiers()) {
            if (!annotation.annotationType().equals(qualifierClass)) continue;
            return annotation;
        }
        Assert.fail((String)"Container provided qualifier not found");
        return null;
    }
}

