/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.policies;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.impl.policies.DefaultMatchPolicy;
import org.eclipse.emf.diffmerge.util.structures.comparable.ComparableLinkedList;
import org.eclipse.emf.diffmerge.util.structures.comparable.ComparableTreeMap;
import org.eclipse.emf.diffmerge.util.structures.comparable.IComparableStructure;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableMatchPolicy
extends DefaultMatchPolicy {
    private final Set<MatchCriterionKind> _selectedCriteria = new HashSet<MatchCriterionKind>(MatchCriterionKind.values().length);

    public ConfigurableMatchPolicy() {
        this._selectedCriteria.addAll(this.getDefaultCriteria());
    }

    public Collection<MatchCriterionKind> getApplicableCriteria() {
        return Arrays.asList(MatchCriterionKind.STRUCTURE, MatchCriterionKind.NAME, MatchCriterionKind.INTRINSIC_ID, MatchCriterionKind.EXTRINSIC_ID);
    }

    protected IComparableStructure<?> getContainerRelativeID(EObject element_p, IModelScope scope_p, boolean inScopeOnly_p, MatchCriterionKind criterion_p) {
        IComparableStructure<?> result = null;
        String lastIDPart = criterion_p == MatchCriterionKind.STRUCTURE ? this.getStructureMatchIDPart(element_p, scope_p, inScopeOnly_p) : this.getUniqueName(element_p, scope_p, inScopeOnly_p);
        if (lastIDPart != null && lastIDPart.length() > 0) {
            result = this.getContainerRelativeID(element_p, scope_p, inScopeOnly_p, lastIDPart);
        }
        return result;
    }

    protected IComparableStructure<?> getContainerRelativeID(EObject element_p, IModelScope scope_p, boolean inScopeOnly_p, String idSuffix_p) {
        Cloneable result = null;
        EObject container = this.getContainer(element_p, scope_p, inScopeOnly_p);
        if (container != null) {
            ComparableLinkedList<String> containerID = this.getMatchID(container, scope_p);
            if (containerID instanceof ComparableLinkedList) {
                result = containerID;
                result.add(idSuffix_p);
            } else if (containerID != null) {
                ComparableLinkedList<String> typeID = this.getEncapsulateOrNull(element_p.getClass().getName());
                ComparableTreeMap<String, ComparableLinkedList<String>> id = new ComparableTreeMap<String, ComparableLinkedList<String>>();
                id.put("CONTAINER_RELATIVE_ID_TYPE", typeID);
                id.put("CONTAINER_ID", containerID);
                id.put("ELEMENT_ID", this.getEncapsulateOrNull(idSuffix_p));
                result = id;
            }
        } else {
            ComparableLinkedList<String> id = new ComparableLinkedList<String>();
            id.add(idSuffix_p);
            result = id;
        }
        return result;
    }

    protected EObject getContainer(EObject element_p, IModelScope scope_p, boolean inScopeOnly_p) {
        Object result = inScopeOnly_p ? (scope_p instanceof IFeaturedModelScope ? ((IFeaturedModelScope)scope_p).getContainer(element_p) : null) : element_p.eContainer();
        return result;
    }

    protected EReference getContainment(EObject element_p, IModelScope scope_p, boolean inScopeOnly_p) {
        Object result = inScopeOnly_p ? (scope_p instanceof IFeaturedModelScope ? ((IFeaturedModelScope)scope_p).getContainment(element_p) : null) : element_p.eContainmentFeature();
        return result;
    }

    public Collection<MatchCriterionKind> getDefaultCriteria() {
        return Arrays.asList(MatchCriterionKind.INTRINSIC_ID, MatchCriterionKind.EXTRINSIC_ID);
    }

    protected <T extends Comparable<T>> ComparableLinkedList<T> getEncapsulateOrNull(T object_p) {
        ComparableLinkedList<T> result = null;
        if (object_p != null) {
            result = new ComparableLinkedList<T>();
            result.add(object_p);
        }
        return result;
    }

    protected String getExtrinsicID(EObject element_p, IModelScope scope_p) {
        String result = null;
        Comparable<?> superID = super.getExtrinsicID(element_p, scope_p);
        if (superID instanceof String) {
            result = (String)((Object)superID);
        }
        return result;
    }

    @Override
    public IComparableStructure<?> getMatchID(EObject element_p, IModelScope scope_p) {
        IComparableStructure<?> result = null;
        Iterator<MatchCriterionKind> it = this.getApplicableCriteria().iterator();
        while (result == null && it.hasNext()) {
            MatchCriterionKind criterion = it.next();
            if (!this.useMatchCriterion(criterion)) continue;
            result = this.getMatchID(element_p, scope_p, criterion);
        }
        return result;
    }

    public IComparableStructure<?> getMatchID(EObject element_p, IModelScope scope_p, MatchCriterionKind criterion_p) {
        IComparableStructure<String> result;
        switch (criterion_p) {
            case EXTRINSIC_ID: {
                result = this.getEncapsulateOrNull(this.getExtrinsicID(element_p, scope_p));
                break;
            }
            case INTRINSIC_ID: {
                result = this.getEncapsulateOrNull(this.getIntrinsicID(element_p));
                break;
            }
            case STRUCTURE: 
            case NAME: {
                result = this.getContainerRelativeID(element_p, scope_p, this.isScopeOnly(), criterion_p);
                break;
            }
            default: {
                result = this.getSemanticID(element_p, scope_p, this.isScopeOnly());
            }
        }
        return result;
    }

    protected String getUniqueName(EObject element_p, IModelScope scope_p, boolean inScopeOnly_p) {
        String result = null;
        if (element_p instanceof ENamedElement) {
            result = ((ENamedElement)element_p).getName();
        }
        return result;
    }

    protected IComparableStructure<?> getSemanticID(EObject element_p, IModelScope scope_p, boolean inScopeOnly_p) {
        return null;
    }

    protected List<EObject> getSiblings(EObject element_p, IModelScope scope_p, boolean inScopeOnly_p) {
        Object result;
        EReference containment = this.getContainment(element_p, scope_p, inScopeOnly_p);
        if (containment == null) {
            Resource resource = element_p.eResource();
            result = inScopeOnly_p || resource == null ? scope_p.getContents() : resource.getContents();
        } else if (scope_p instanceof IFeaturedModelScope) {
            EObject container = this.getContainer(element_p, scope_p, inScopeOnly_p);
            result = ((IFeaturedModelScope)scope_p).get(container, containment);
        } else {
            result = Collections.emptyList();
        }
        return Collections.unmodifiableList(result);
    }

    protected String getStructureMatchIDPart(EObject element_p, IModelScope scope_p, boolean inScopeOnly_p) {
        String result = null;
        EReference containment = this.getContainment(element_p, scope_p, inScopeOnly_p);
        if (this.isDiscriminatingContainment(element_p, containment)) {
            boolean validated;
            boolean bl = validated = containment != null && !containment.isMany();
            if (!validated) {
                List<EObject> siblings = this.getSiblings(element_p, scope_p, inScopeOnly_p);
                validated = this.isUniqueOfItsTypeAmong(element_p, siblings);
            }
            if (validated) {
                result = this.getValidatedStructureMatchIDPart(element_p, scope_p, containment);
            }
        }
        return result;
    }

    protected String getValidatedStructureMatchIDPart(EObject element_p, IModelScope scope_p, EReference containment_p) {
        StringBuilder builder = new StringBuilder();
        builder.append("::");
        if (containment_p != null && containment_p.getName() != null) {
            builder.append(containment_p.getName());
        }
        builder.append('[');
        builder.append(element_p.eClass().getName());
        builder.append(']');
        return builder.toString();
    }

    protected boolean isDiscriminatingContainment(EObject element_p, EReference containment_p) {
        return containment_p == null || !containment_p.isMany();
    }

    protected boolean isFirstOfItsTypeAmong(EObject element_p, Collection<? extends EObject> collection_p) {
        Iterator<? extends EObject> it = collection_p.iterator();
        EClass type = element_p.eClass();
        while (it.hasNext()) {
            EObject root = it.next();
            if (root == element_p) {
                return true;
            }
            if (root.eClass() != type) continue;
            return false;
        }
        return false;
    }

    protected boolean isInstanceOf(EObject element_p, Collection<? extends EClass> types_p) {
        for (EClass eClass : types_p) {
            if (!eClass.isInstance((Object)element_p)) continue;
            return true;
        }
        return false;
    }

    protected boolean isScopeOnly() {
        return true;
    }

    protected boolean isUniqueOfItsTypeAmong(EObject element_p, Collection<? extends EObject> collection_p) {
        Iterator<? extends EObject> it = collection_p.iterator();
        EClass type = element_p.eClass();
        boolean isPresent = false;
        boolean sameType = false;
        while (it.hasNext() && !sameType) {
            EObject root = it.next();
            if (root == element_p) {
                isPresent = true;
                continue;
            }
            if (root.eClass() != type) continue;
            sameType = true;
        }
        boolean result = isPresent && !sameType;
        return result;
    }

    public void setUseMatchCriterion(MatchCriterionKind criterion_p, boolean use_p) {
        if (use_p) {
            this._selectedCriteria.add(criterion_p);
        } else {
            this._selectedCriteria.remove((Object)criterion_p);
        }
    }

    public boolean useMatchCriterion(MatchCriterionKind criterion_p) {
        return this._selectedCriteria.contains((Object)criterion_p);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MatchCriterionKind {
        SEMANTICS,
        STRUCTURE,
        NAME,
        INTRINSIC_ID,
        EXTRINSIC_ID;

    }
}

