/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.comma.monitoring.lib.CComponentMonitor;
import org.eclipse.comma.monitoring.lib.CComponentMonitoringTaskContext;
import org.eclipse.comma.monitoring.lib.CComponentResults;
import org.eclipse.comma.monitoring.lib.CConnectionResults;
import org.eclipse.comma.monitoring.lib.CDispatcher;
import org.eclipse.comma.monitoring.lib.CEntryPoint;
import org.eclipse.comma.monitoring.lib.CFactory;
import org.eclipse.comma.monitoring.lib.CInterfaceMonitor;
import org.eclipse.comma.monitoring.lib.CMonitorCall;
import org.eclipse.comma.monitoring.lib.CMonitorResults;
import org.eclipse.comma.monitoring.lib.CPartDescriptor;
import org.eclipse.comma.monitoring.lib.CPortInstance;
import org.eclipse.comma.monitoring.lib.messages.CObservedCommand;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;
import org.eclipse.comma.monitoring.lib.messages.CObservedSignal;
import org.eclipse.comma.monitoring.lib.utils.Utils;

public class CComponentDispatcher
extends CDispatcher {
    private CComponentMonitoringTaskContext context;
    private CFactory factory;
    private Map<String, CComponentMonitor> componentMonitors = new HashMap<String, CComponentMonitor>();
    private List<CEntryPoint> entryPoints;
    private List<String> componentInstances;
    private List<List<CPortInstance>> portPaths;
    private List<CPartDescriptor> partDescriptors;
    private Map<CInterfaceMonitor, CComponentMonitor> connection2component = new HashMap<CInterfaceMonitor, CComponentMonitor>();
    private List<CMonitorResults> resultsLastEvent;

    public CComponentDispatcher(CComponentMonitoringTaskContext context, CFactory factory) {
        this.context = context;
        this.factory = factory;
        this.entryPoints = context.entryPoints;
        this.componentInstances = context.getComponentInstances();
        this.portPaths = context.portPaths;
        this.partDescriptors = context.getMonitoredComponentDescriptor().partDescriptors;
    }

    @Override
    public void consume(CObservedMessage message) throws Exception {
        CInterfaceMonitor interfaceMonitor;
        CEntryPoint entry = null;
        String instanceToMonitor = null;
        String port = null;
        String rootInstance = null;
        ArrayList<CMonitorCall> monitoringPath = new ArrayList<CMonitorCall>();
        String connectionKey = null;
        this.resultsLastEvent = new ArrayList<CMonitorResults>();
        for (CEntryPoint ep : this.entryPoints) {
            boolean outgoing = false;
            outgoing = ep.receivingComponentInstance.equals(message.getSource()) && ep.receivingPort.equals(message.getSourcePort());
            if (!outgoing && (!ep.receivingComponentInstance.equals(message.getDestination()) || !ep.receivingPort.equals(message.getDestinationPort()))) continue;
            entry = ep;
            rootInstance = instanceToMonitor = entry.actualComponentInstance;
            port = entry.actualPort;
            for (List<CPortInstance> path : this.portPaths) {
                if (!path.get((int)0).port.equals(port) || !path.get((int)0).componentInstance.equals("")) continue;
                for (CPortInstance pi : path) {
                    CMonitorCall call = new CMonitorCall(String.valueOf(rootInstance) + pi.componentInstance, pi.port);
                    if (outgoing) {
                        monitoringPath.add(call.renameSource());
                        continue;
                    }
                    monitoringPath.add(call.renameTarget());
                }
                Collections.reverse(monitoringPath);
                break;
            }
            if (message instanceof CObservedCommand || message instanceof CObservedSignal) {
                if (outgoing) {
                    connectionKey = this.makeMultitonConnectionKey(message.getDestination(), rootInstance, message.getInterface());
                    break;
                }
                if (this.context.getMonitoredComponentDescriptor().singletonPorts.contains(port)) {
                    connectionKey = this.makeSingletonConnectionKey(rootInstance, port, message.getInterface());
                    break;
                }
                connectionKey = this.makeMultitonConnectionKey(rootInstance, message.getSource(), message.getInterface());
                break;
            }
            if (outgoing) {
                if (this.context.getMonitoredComponentDescriptor().singletonPorts.contains(port)) {
                    connectionKey = this.makeSingletonConnectionKey(rootInstance, port, message.getInterface());
                    break;
                }
                connectionKey = this.makeMultitonConnectionKey(rootInstance, message.getDestination(), message.getInterface());
                break;
            }
            connectionKey = this.makeMultitonConnectionKey(message.getSource(), rootInstance, message.getInterface());
            break;
        }
        if (rootInstance == null) {
            for (String ci : this.componentInstances) {
                CMonitorCall mc;
                String otherSide;
                Object otherPort;
                boolean isCall;
                if (!message.getSource().startsWith(String.valueOf(ci) + ".")) continue;
                rootInstance = ci;
                boolean bl = isCall = message instanceof CObservedCommand || message instanceof CObservedSignal;
                if (isCall) {
                    port = message.getDestinationPort();
                    instanceToMonitor = message.getDestination();
                    otherPort = message.getSourcePort();
                    otherSide = message.getSource();
                } else {
                    port = message.getSourcePort();
                    instanceToMonitor = message.getSource();
                    otherPort = message.getDestinationPort();
                    otherSide = message.getDestination();
                }
                String partId = instanceToMonitor.substring(ci.length());
                String partType = "";
                for (CPartDescriptor pd : this.partDescriptors) {
                    if (!pd.partId.equals(partId)) continue;
                    partType = pd.type;
                    break;
                }
                connectionKey = this.context.getComponentDescriptor((String)partType).singletonPorts.contains(port) ? this.makeSingletonConnectionKey(instanceToMonitor, port, message.getInterface()) : this.makeMultitonConnectionKey(instanceToMonitor, otherSide, message.getInterface());
                ArrayList<CMonitorCall> part = new ArrayList<CMonitorCall>();
                for (List<CPortInstance> path : this.portPaths) {
                    if (!path.get((int)0).port.equals(port) || !(String.valueOf(rootInstance) + path.get((int)0).componentInstance).equals(instanceToMonitor)) continue;
                    for (CPortInstance pi : path) {
                        mc = new CMonitorCall(String.valueOf(rootInstance) + pi.componentInstance, pi.port);
                        if (isCall) {
                            part.add(mc.renameTarget());
                            continue;
                        }
                        part.add(mc.renameSource());
                    }
                    Collections.reverse(part);
                    monitoringPath.addAll(part);
                    break;
                }
                part = new ArrayList();
                for (List<CPortInstance> path : this.portPaths) {
                    if (!path.get((int)0).port.equals(otherPort) || !(String.valueOf(rootInstance) + path.get((int)0).componentInstance).equals(otherSide)) continue;
                    for (CPortInstance pi : path) {
                        mc = new CMonitorCall(String.valueOf(rootInstance) + pi.componentInstance, pi.port);
                        if (isCall) {
                            part.add(mc.renameSource());
                            continue;
                        }
                        part.add(mc.renameTarget());
                    }
                    Collections.reverse(part);
                    monitoringPath.addAll(part);
                    break;
                }
                int lastDot = message.getSource().lastIndexOf(46);
                String parent = message.getSource().substring(0, lastDot);
                monitoringPath.add(new CMonitorCall(parent, ""));
                break;
            }
        }
        if (rootInstance == null) {
            return;
        }
        if (!this.componentMonitors.containsKey(rootInstance)) {
            for (CPartDescriptor pd : this.partDescriptors) {
                CComponentMonitor componentMonitor = new CComponentMonitor(this.context.createComponentMonitoringContext(String.valueOf(rootInstance) + pd.partId, pd.type));
                this.componentMonitors.put(String.valueOf(rootInstance) + pd.partId, componentMonitor);
            }
            CComponentMonitor componentMonitor = new CComponentMonitor(this.context.createComponentMonitoringContext(rootInstance, this.context.componentType));
            this.componentMonitors.put(rootInstance, componentMonitor);
        }
        if ((interfaceMonitor = (CInterfaceMonitor)this.connection2monitor.get(connectionKey)) == null) {
            interfaceMonitor = new CInterfaceMonitor(this.context.createPortConnectionContext(message.getInterface(), port, instanceToMonitor, connectionKey), this.factory);
            this.connection2monitor.put(connectionKey, interfaceMonitor);
            this.connection2component.put(interfaceMonitor, this.componentMonitors.get(instanceToMonitor));
        }
        if (!interfaceMonitor.inErrorState()) {
            if (!interfaceMonitor.consume(message)) {
                CConnectionResults interfaceResults = interfaceMonitor.getResults();
                for (CMonitorCall c : monitoringPath) {
                    if (c.instance.equals(instanceToMonitor)) {
                        this.componentMonitors.get(c.instance).connectionError(interfaceResults);
                        continue;
                    }
                    this.componentMonitors.get(c.instance).connectionError();
                }
            } else {
                for (CMonitorCall c : monitoringPath) {
                    CObservedMessage msgCopy = (CObservedMessage)Utils.deepCopy(message);
                    if (c.renameSource) {
                        msgCopy.setSource(c.instance);
                        msgCopy.setSourcePort(c.port);
                    }
                    if (c.renameTarget) {
                        msgCopy.setDestination(c.instance);
                        msgCopy.setDestinationPort(c.port);
                    }
                    this.componentMonitors.get(c.instance).consume(msgCopy, interfaceMonitor.getPathDescriptions(), connectionKey);
                    CComponentResults r = this.componentMonitors.get(c.instance).getResultForLastEvent();
                    if (r == null || !r.hasIssues()) continue;
                    this.resultsLastEvent.add(r);
                }
            }
            CConnectionResults interfaceResult = interfaceMonitor.getResultForLastEvent();
            if (interfaceResult != null && interfaceResult.hasIssues()) {
                this.resultsLastEvent.add(interfaceResult);
            }
        }
    }

    @Override
    public void traceEnded() throws Exception {
        for (CInterfaceMonitor cInterfaceMonitor : this.connection2monitor.values().stream().filter(h -> !h.inErrorState()).collect(Collectors.toList())) {
            cInterfaceMonitor.traceEnded();
            this.connection2component.get(cInterfaceMonitor).connectionMonitoringDone(cInterfaceMonitor.getResults());
        }
        for (CComponentMonitor cComponentMonitor : this.componentMonitors.values()) {
            cComponentMonitor.traceEnded();
        }
    }

    @Override
    public List<CMonitorResults> getResults() {
        return this.componentMonitors.values().stream().map(m -> m.getResults()).collect(Collectors.toList());
    }

    @Override
    public List<CMonitorResults> getIssuesForLastEvent() {
        return this.resultsLastEvent;
    }
}

