/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.generator;

import java.util.Arrays;
import java.util.List;
import org.eclipse.comma.actions.actions.CommandEvent;
import org.eclipse.comma.actions.actions.EVENT_KIND;
import org.eclipse.comma.actions.actions.EventPattern;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.ProvidedPort;
import org.eclipse.comma.behavior.component.component.AnyEvent;
import org.eclipse.comma.behavior.component.component.CommandReply;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.component.ComponentPart;
import org.eclipse.comma.behavior.component.component.FunctionalConstraint;
import org.eclipse.comma.behavior.component.component.FunctionalConstraintsBlock;
import org.eclipse.comma.behavior.component.component.NotificationEvent;
import org.eclipse.comma.behavior.component.component.PredicateFunctionalConstraint;
import org.eclipse.comma.behavior.component.component.SignalEvent;
import org.eclipse.comma.behavior.component.component.StateBasedFunctionalConstraint;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.monitoring.generator.ConstraintsRulesGenerator;
import org.eclipse.comma.monitoring.generator.FunctionalConstraintGenerator;
import org.eclipse.comma.monitoring.generator.InterfaceDecisionGenerator;
import org.eclipse.comma.monitoring.generator.TypesJavaGenerator;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.MapTypeConstructor;
import org.eclipse.comma.types.types.MapTypeDecl;
import org.eclipse.comma.types.types.NamedElement;
import org.eclipse.comma.types.types.RecordField;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.comma.types.types.VectorTypeConstructor;
import org.eclipse.comma.types.types.VectorTypeDecl;
import org.eclipse.comma.types.utilities.CommaUtilities;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class InfrastructureGenerator
extends TypesJavaGenerator {
    protected final IFileSystemAccess fsa;
    protected final Iterable<RecordTypeDecl> recordTypes;
    protected static final String factoryClassName = "CFactoryGenerated";

    public InfrastructureGenerator(IFileSystemAccess fsa, Iterable<RecordTypeDecl> recordTypes) {
        this.fsa = fsa;
        this.recordTypes = recordTypes;
    }

    public void generateFactory(Iterable<Interface> interfaces, Iterable<Component> components) {
        this.fsa.generateFile(TypesJavaGenerator.generatedFileName(factoryClassName), this.factoryContent(interfaces, components));
    }

    public CharSequence factoryContent(Iterable<Interface> interfaces, Iterable<Component> components) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.ArrayList;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.append("import java.util.function.Function;");
        _builder.newLine();
        _builder.append("import java.util.Optional;");
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".messages.*;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        _builder.append(factoryClassName);
        _builder.append(" extends CFactory {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CRecordsTracker getRecordsTracker() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return new CRecordsInstances();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CInterfaceDecisionClass createDecisionClass(String interfaceName){");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("switch(interfaceName){");
        _builder.newLine();
        for (Interface i : interfaces) {
            _builder.append("\t\t\t");
            _builder.append("case \"");
            String _fullyQualifiedNameAsString = CommaUtilities.getFullyQualifiedNameAsString((NamedElement)i);
            _builder.append(_fullyQualifiedNameAsString, "\t\t\t");
            _builder.append("\" : return new ");
            CharSequence _decisionClassName = InterfaceDecisionGenerator.decisionClassName(i);
            _builder.append((Object)_decisionClassName, "\t\t\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t\t");
        _builder.append("default: return null;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public List<CComponentConstraintMonitor> createComponentConstraintMonitors(CComponentMonitoringContext context) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("List<CComponentConstraintMonitor> result = new ArrayList<CComponentConstraintMonitor>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("CFunctionalConstraint c;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Function<CObservedMessage, Boolean> filter;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("CComponentConstraintMonitor mon;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("switch(context.getComponentType()){");
        _builder.newLine();
        for (Component c : components) {
            boolean _tripleNotEquals;
            _builder.append("\t\t\t");
            _builder.append("case \"");
            String _fullyQualifiedNameAsString_1 = CommaUtilities.getFullyQualifiedNameAsString((NamedElement)c);
            _builder.append(_fullyQualifiedNameAsString_1, "\t\t\t");
            _builder.append("\" : {");
            _builder.newLineIfNotEmpty();
            FunctionalConstraintsBlock _functionalConstraintsBlock = c.getFunctionalConstraintsBlock();
            boolean bl = _tripleNotEquals = _functionalConstraintsBlock != null;
            if (_tripleNotEquals) {
                EList _functionalConstraints = c.getFunctionalConstraintsBlock().getFunctionalConstraints();
                for (FunctionalConstraint fc : _functionalConstraints) {
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("c = new ");
                    String _constraintClassName = FunctionalConstraintGenerator.constraintClassName(c, fc);
                    _builder.append(_constraintClassName, "\t\t\t\t");
                    _builder.append("(\"");
                    String _name = fc.getName();
                    _builder.append(_name, "\t\t\t\t");
                    _builder.append("\", context.getComponentInstanceName());");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("filter =");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    CharSequence _generateEventFilter = this.generateEventFilter(fc);
                    _builder.append((Object)_generateEventFilter, "\t\t\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("mon = new CFunctionalConstraintMonitor(context, c, filter);");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("result.add(mon);");
                    _builder.newLine();
                }
            }
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("mon = new CComponentTimeDataMonitor(context.createComponentTimeDataContext(), new ");
            CharSequence _rulesClassName = ConstraintsRulesGenerator.rulesClassName((NamedElement)c);
            _builder.append((Object)_rulesClassName, "\t\t\t\t");
            _builder.append("(context.getComponentInstanceName()).getRules());");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("result.add(mon);");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("return result;");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t\t\t");
        _builder.append("default: return null;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateEventFilter(StateBasedFunctionalConstraint fc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("m -> ");
        EList _usedEvents = fc.getUsedEvents();
        for (EventPattern e : _usedEvents) {
            boolean _tripleNotEquals;
            _builder.append("(");
            CharSequence _filterFragment = this.filterFragment((EObject)e);
            _builder.append((Object)_filterFragment);
            _builder.append(")");
            EventPattern _last = (EventPattern)IterableExtensions.last((Iterable)fc.getUsedEvents());
            boolean bl = _tripleNotEquals = e != _last;
            if (_tripleNotEquals) {
                _builder.append(" ||");
            }
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateEventFilter(PredicateFunctionalConstraint fc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("m -> true");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _filterFragment(AnyEvent e) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder;
        StringConcatenation _xblockexpression = null;
        StringConcatenation eventTypeFragment = _builder = new StringConcatenation();
        EVENT_KIND _kind = e.getKind();
        if (_kind != null) {
            switch (_kind) {
                case CALL: {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append(" ");
                    _builder_1.append("&& (m instanceof CObservedCommand)");
                    eventTypeFragment = _builder_1;
                    break;
                }
                case SIGNAL: {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append(" ");
                    _builder_2.append("&& (m instanceof CObservedSignal)");
                    eventTypeFragment = _builder_2;
                    break;
                }
                case NOTIFICATION: {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append(" ");
                    _builder_3.append("&& (m instanceof CObservedNotification)");
                    eventTypeFragment = _builder_3;
                    break;
                }
                default: {
                    StringConcatenation _builder_4;
                    eventTypeFragment = _builder_4 = new StringConcatenation();
                    break;
                }
            }
        } else {
            StringConcatenation _builder_4;
            eventTypeFragment = _builder_4 = new StringConcatenation();
        }
        StringConcatenation _builder_5 = new StringConcatenation();
        _builder_5.append("((m.getSourcePort().equals(\"");
        String _name = e.getPort().getName();
        _builder_5.append(_name);
        _builder_5.append("\") && (context.getComponentInstanceName()");
        ComponentPart _part = e.getPart();
        boolean bl = _tripleNotEquals = _part != null;
        if (_tripleNotEquals) {
            _builder_5.append(" + \".");
            String _name_1 = e.getPart().getName();
            _builder_5.append(_name_1);
            _builder_5.append("\"");
        }
        _builder_5.append(").equals(m.getSource())) || (m.getDestinationPort().equals(\"");
        String _name_2 = e.getPort().getName();
        _builder_5.append(_name_2);
        _builder_5.append("\") && (context.getComponentInstanceName()");
        ComponentPart _part_1 = e.getPart();
        boolean bl2 = _tripleNotEquals_1 = _part_1 != null;
        if (_tripleNotEquals_1) {
            _builder_5.append(" + \".");
            String _name_3 = e.getPart().getName();
            _builder_5.append(_name_3);
            _builder_5.append("\"");
        }
        _builder_5.append(").equals(m.getDestination())))");
        _builder_5.append((Object)eventTypeFragment);
        _xblockexpression = _builder_5;
        return _xblockexpression;
    }

    protected CharSequence _filterFragment(CommandReply e) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("m.");
        Port _port = e.getPort();
        if (_port instanceof ProvidedPort) {
            _builder.append("getSourcePort()");
        } else {
            _builder.append("getDestinationPort()");
        }
        _builder.append(".equals(\"");
        String _name = e.getPort().getName();
        _builder.append(_name);
        _builder.append("\") && m.");
        Port _port_1 = e.getPort();
        if (_port_1 instanceof ProvidedPort) {
            _builder.append("getSource()");
        } else {
            _builder.append("getDestination()");
        }
        _builder.append(".equals(context.getComponentInstanceName()");
        ComponentPart _part = e.getPart();
        boolean bl = _tripleNotEquals = _part != null;
        if (_tripleNotEquals) {
            _builder.append(" + \".");
            String _name_1 = e.getPart().getName();
            _builder.append(_name_1);
            _builder.append("\"");
        }
        _builder.append(") &&");
        CommandEvent _command = e.getCommand();
        boolean bl2 = _tripleNotEquals_1 = _command != null;
        if (_tripleNotEquals_1) {
            _builder.append(" m.getName().equals(\"");
            String _name_2 = e.getCommand().getEvent().getName();
            _builder.append(_name_2);
            _builder.append("\") &&");
        }
        _builder.append(" (m instanceof CObservedReply)");
        return _builder;
    }

    protected CharSequence _filterFragment(org.eclipse.comma.behavior.component.component.CommandEvent e) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("m.");
        Port _port = e.getPort();
        if (_port instanceof ProvidedPort) {
            _builder.append("getDestinationPort()");
        } else {
            _builder.append("getSourcePort()");
        }
        _builder.append(".equals(\"");
        String _name = e.getPort().getName();
        _builder.append(_name);
        _builder.append("\") && m.");
        Port _port_1 = e.getPort();
        if (_port_1 instanceof ProvidedPort) {
            _builder.append("getDestination()");
        } else {
            _builder.append("getSource()");
        }
        _builder.append(".equals(context.getComponentInstanceName()");
        ComponentPart _part = e.getPart();
        boolean bl = _tripleNotEquals = _part != null;
        if (_tripleNotEquals) {
            _builder.append(" + \".");
            String _name_1 = e.getPart().getName();
            _builder.append(_name_1);
            _builder.append("\"");
        }
        _builder.append(") && m.getName().equals(\"");
        String _name_2 = e.getEvent().getName();
        _builder.append(_name_2);
        _builder.append("\")");
        return _builder;
    }

    protected CharSequence _filterFragment(SignalEvent e) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("m.");
        Port _port = e.getPort();
        if (_port instanceof ProvidedPort) {
            _builder.append("getDestinationPort()");
        } else {
            _builder.append("getSourcePort()");
        }
        _builder.append(".equals(\"");
        String _name = e.getPort().getName();
        _builder.append(_name);
        _builder.append("\") && m.");
        Port _port_1 = e.getPort();
        if (_port_1 instanceof ProvidedPort) {
            _builder.append("getDestination()");
        } else {
            _builder.append("getSource()");
        }
        _builder.append(".equals(context.getComponentInstanceName()");
        ComponentPart _part = e.getPart();
        boolean bl = _tripleNotEquals = _part != null;
        if (_tripleNotEquals) {
            _builder.append(" + \".");
            String _name_1 = e.getPart().getName();
            _builder.append(_name_1);
            _builder.append("\"");
        }
        _builder.append(") && m.getName().equals(\"");
        String _name_2 = e.getEvent().getName();
        _builder.append(_name_2);
        _builder.append("\")");
        return _builder;
    }

    protected CharSequence _filterFragment(NotificationEvent e) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("m.");
        Port _port = e.getPort();
        if (_port instanceof ProvidedPort) {
            _builder.append("getSourcePort()");
        } else {
            _builder.append("getDestinationPort()");
        }
        _builder.append(".equals(\"");
        String _name = e.getPort().getName();
        _builder.append(_name);
        _builder.append("\") && m.");
        Port _port_1 = e.getPort();
        if (_port_1 instanceof ProvidedPort) {
            _builder.append("getSource()");
        } else {
            _builder.append("getDestination()");
        }
        _builder.append(".equals(context.getComponentInstanceName()");
        ComponentPart _part = e.getPart();
        boolean bl = _tripleNotEquals = _part != null;
        if (_tripleNotEquals) {
            _builder.append(" + \".");
            String _name_1 = e.getPart().getName();
            _builder.append(_name_1);
            _builder.append("\"");
        }
        _builder.append(") && m.getName().equals(\"");
        String _name_2 = e.getEvent().getName();
        _builder.append(_name_2);
        _builder.append("\")");
        return _builder;
    }

    public void generateRecordsTracker() {
        this.fsa.generateFile(TypesJavaGenerator.generatedFileName("CRecordsInstances"), this.createRecordsTracker());
    }

    public void generateScenarioPlayer(List<String> taskNames) {
        this.fsa.generateFile(TypesJavaGenerator.generatedFileName("ScenarioPlayer"), this.scenarioPlayerContent(taskNames));
    }

    public CharSequence createRecordsTracker() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.append("/*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Copyright (c) 2021 Contributors to the Eclipse Foundation");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This program and the accompanying materials are made");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* available under the terms of the Eclipse Public License 2.0");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* which is available at https://www.eclipse.org/legal/epl-2.0/");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* SPDX-License-Identifier: EPL-2.0");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/\t\t\t\t");
        _builder.newLine();
        _builder.append("import java.util.LinkedHashMap;");
        _builder.newLine();
        _builder.append("import java.util.HashMap;");
        _builder.newLine();
        _builder.append("import java.util.Map;\t\t");
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".CRecordsTracker;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class CRecordsInstances implements CRecordsTracker {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private Map<String,Map<String,String>> records;");
        _builder.newLine();
        boolean _isEmpty = IterableExtensions.isEmpty(this.recordTypes);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("\t");
            _builder.append("public CRecordsInstances () {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("    ");
            _builder.append("records = new HashMap<String,Map<String,String>>();");
            _builder.newLine();
            for (RecordTypeDecl rt : this.recordTypes) {
                _builder.append(" \t\t\t\t");
                _builder.append("Map<String,String> ");
                String _removeDot = this.removeDot(CommaUtilities.getFullyQualifiedNameAsString((NamedElement)rt));
                _builder.append(_removeDot, " \t\t\t\t");
                _builder.append("_fields = new  LinkedHashMap<String,String>();");
                _builder.newLineIfNotEmpty();
                List _allFields = TypeUtilities.getAllFields((RecordTypeDecl)rt);
                for (RecordField field : _allFields) {
                    _builder.append(" \t\t\t\t");
                    String _removeDot_1 = this.removeDot(CommaUtilities.getFullyQualifiedNameAsString((NamedElement)rt));
                    _builder.append(_removeDot_1, " \t\t\t\t");
                    _builder.append("_fields.put(\"");
                    String _name = field.getName();
                    _builder.append(_name, " \t\t\t\t");
                    _builder.append("\",\"");
                    CharSequence _type = InfrastructureGenerator.toType((EObject)field.getType());
                    _builder.append((Object)_type, " \t\t\t\t");
                    _builder.append("\");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append(" \t\t\t\t");
                _builder.append("records.put(\"");
                String _removeDot_2 = this.removeDot(CommaUtilities.getFullyQualifiedNameAsString((NamedElement)rt));
                _builder.append(_removeDot_2, " \t\t\t\t");
                _builder.append("\",");
                String _removeDot_3 = this.removeDot(CommaUtilities.getFullyQualifiedNameAsString((NamedElement)rt));
                _builder.append(_removeDot_3, " \t\t\t\t");
                _builder.append("_fields);");
                _builder.newLineIfNotEmpty();
                _builder.append(" \t\t\t\t");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("@Override");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public Map<String,String> getFieldsOfRecord(String recordName) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if(!records.containsKey(recordName)) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("throw new IllegalArgumentException(\"The record \"+recordName+ \" is not used by the interface model.\");");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return records.get(recordName);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("public CRecordsInstances () {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("//no records defined in the interface model");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("@Override");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public Map<String,String> getFieldsOfRecord(String recordName) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("throw new IllegalArgumentException(\"unexpected record value \"+recordName+\". Model does not use record types.\");");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public String removeDot(String string) {
        return string.replace(".", "_");
    }

    public CharSequence scenarioPlayerContent(List<String> taskNames) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.ArrayList;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".CTask;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".CTaskResults;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".ExportToJson;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".ExportToDashboard;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ScenarioPlayer {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private List<CTask> tasks = new ArrayList<CTask>();");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void init() {");
        _builder.newLine();
        for (String task : taskNames) {
            _builder.append("\t\t");
            _builder.append("CTask ");
            _builder.append(task, "\t\t");
            _builder.append(" = new CTask_");
            _builder.append(task, "\t\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("tasks.add(");
            _builder.append(task, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void run() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for(CTask task : tasks) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("task.run();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("List<CTaskResults> results = new ArrayList<CTaskResults>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for(CTask task : tasks) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("results.add(task.getResults());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("System.out.println(\"All monitoring tasks executed\");");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("ExportToJson exportJson = new ExportToJson();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("exportJson.export(results);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("ExportToDashboard exportDashboard = new ExportToDashboard();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("exportDashboard.export(results);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public static void main(String[] args) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("ScenarioPlayer player = new ScenarioPlayer();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("player.init();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("player.run();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected static CharSequence _toType(TypeReference t) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _type = InfrastructureGenerator.toType((EObject)t.getType());
        _builder.append((Object)_type);
        return _builder;
    }

    protected static CharSequence _toType(SimpleTypeDecl t) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        SimpleTypeDecl _base = t.getBase();
        boolean bl = _tripleNotEquals = _base != null;
        if (_tripleNotEquals) {
            String _name = t.getBase().getName();
            _builder.append(_name);
        } else {
            String _name_1 = t.getName();
            _builder.append(_name_1);
        }
        return _builder;
    }

    protected static CharSequence _toType(EnumTypeDecl t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("enum");
        return _builder;
    }

    protected static CharSequence _toType(RecordTypeDecl t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("record");
        return _builder;
    }

    protected static CharSequence _toType(VectorTypeConstructor t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("vector");
        return _builder;
    }

    protected static CharSequence _toType(VectorTypeDecl t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("vector");
        return _builder;
    }

    protected static CharSequence _toType(MapTypeConstructor t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("map");
        return _builder;
    }

    protected static CharSequence _toType(MapTypeDecl t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("map");
        return _builder;
    }

    public CharSequence generateEventFilter(FunctionalConstraint fc) {
        if (fc instanceof PredicateFunctionalConstraint) {
            return this._generateEventFilter((PredicateFunctionalConstraint)fc);
        }
        if (fc instanceof StateBasedFunctionalConstraint) {
            return this._generateEventFilter((StateBasedFunctionalConstraint)fc);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(fc).toString());
    }

    public CharSequence filterFragment(EObject e) {
        if (e instanceof org.eclipse.comma.behavior.component.component.CommandEvent) {
            return this._filterFragment((org.eclipse.comma.behavior.component.component.CommandEvent)e);
        }
        if (e instanceof NotificationEvent) {
            return this._filterFragment((NotificationEvent)e);
        }
        if (e instanceof SignalEvent) {
            return this._filterFragment((SignalEvent)e);
        }
        if (e instanceof AnyEvent) {
            return this._filterFragment((AnyEvent)e);
        }
        if (e instanceof CommandReply) {
            return this._filterFragment((CommandReply)e);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }

    public static CharSequence toType(EObject t) {
        if (t instanceof EnumTypeDecl) {
            return InfrastructureGenerator._toType((EnumTypeDecl)t);
        }
        if (t instanceof MapTypeDecl) {
            return InfrastructureGenerator._toType((MapTypeDecl)t);
        }
        if (t instanceof RecordTypeDecl) {
            return InfrastructureGenerator._toType((RecordTypeDecl)t);
        }
        if (t instanceof SimpleTypeDecl) {
            return InfrastructureGenerator._toType((SimpleTypeDecl)t);
        }
        if (t instanceof VectorTypeDecl) {
            return InfrastructureGenerator._toType((VectorTypeDecl)t);
        }
        if (t instanceof MapTypeConstructor) {
            return InfrastructureGenerator._toType((MapTypeConstructor)t);
        }
        if (t instanceof TypeReference) {
            return InfrastructureGenerator._toType((TypeReference)t);
        }
        if (t instanceof VectorTypeConstructor) {
            return InfrastructureGenerator._toType((VectorTypeConstructor)t);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t).toString());
    }
}

