/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.tasks;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.tasks.userinput.NonInteractiveUserInputHandler;
import org.gradle.api.internal.tasks.userinput.UserInputHandler;
import org.gradle.api.internal.tasks.userinput.UserQuestions;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.api.tasks.options.OptionValues;
import org.gradle.api.tasks.wrapper.internal.WrapperDefaults;
import org.gradle.api.tasks.wrapper.internal.WrapperGenerator;
import org.gradle.buildinit.InsecureProtocolOption;
import org.gradle.buildinit.plugins.internal.BuildConverter;
import org.gradle.buildinit.plugins.internal.BuildGenerator;
import org.gradle.buildinit.plugins.internal.BuildInitException;
import org.gradle.buildinit.plugins.internal.BuildInitializer;
import org.gradle.buildinit.plugins.internal.GenerationSettings;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.ProjectLayoutSetupRegistry;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.buildinit.plugins.internal.modifiers.ModularizationOption;
import org.gradle.buildinit.specs.BuildInitConfig;
import org.gradle.buildinit.specs.BuildInitGenerator;
import org.gradle.buildinit.specs.BuildInitParameter;
import org.gradle.buildinit.specs.BuildInitSpec;
import org.gradle.buildinit.specs.internal.BuildInitSpecRegistry;
import org.gradle.internal.instrumentation.api.annotations.NotToBeReplacedByLazyProperty;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.util.GradleVersion;
import org.gradle.work.DisableCachingByDefault;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@DisableCachingByDefault(because="Not worth caching")
public abstract class InitBuild
extends DefaultTask {
    private static final String SOURCE_PACKAGE_DEFAULT = "org.example";
    private static final String SOURCE_PACKAGE_PROPERTY = "org.gradle.buildinit.source.package";
    private static final int MINIMUM_VERSION_SUPPORTED_BY_FOOJAY_API = 7;
    private static final int DEFAULT_JAVA_VERSION = 21;
    private final Directory projectDir = this.getProject().getLayout().getProjectDirectory();
    private String type;
    private final Property<Boolean> splitProject = this.getProject().getObjects().property(Boolean.class);
    private String dsl;
    private final Property<Boolean> useIncubatingAPIs = this.getProject().getObjects().property(Boolean.class);
    private String testFramework;
    private String projectName;
    private String packageName;
    private final Property<InsecureProtocolOption> insecureProtocol = this.getProject().getObjects().property(InsecureProtocolOption.class);
    private final Property<String> javaVersion = this.getProject().getObjects().property(String.class);
    @Internal
    private ProjectLayoutSetupRegistry projectLayoutRegistry;

    @Incubating
    @Input
    @Optional
    @Option(option="use-defaults", description="Use default values for options not configured explicitly")
    public abstract Property<Boolean> getUseDefaults();

    @Incubating
    @Input
    @Optional
    @Option(option="overwrite", description="Allow existing files in the build directory to be overwritten?")
    public abstract Property<Boolean> getAllowFileOverwrite();

    @Input
    @ToBeReplacedByLazyProperty
    public String getType() {
        return Strings.isNullOrEmpty((String)this.type) ? this.detectType() : this.type;
    }

    @Input
    @Optional
    @Option(option="split-project", description="Split functionality across multiple subprojects?")
    public Property<Boolean> getSplitProject() {
        return this.splitProject;
    }

    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public String getDsl() {
        return Strings.isNullOrEmpty((String)this.dsl) ? BuildInitDsl.KOTLIN.getId() : this.dsl;
    }

    @Input
    @Optional
    @Option(option="incubating", description="Allow the generated build to use new features and APIs.")
    public Property<Boolean> getUseIncubating() {
        return this.useIncubatingAPIs;
    }

    @Input
    @Optional
    @Incubating
    @Option(option="java-version", description="Provides java version to use in the project.")
    public Property<String> getJavaVersion() {
        return this.javaVersion;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public String getProjectName() {
        return this.projectName == null ? this.projectDir.getAsFile().getName() : this.projectName;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public String getPackageName() {
        return this.packageName == null ? "" : this.packageName;
    }

    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public @Nullable String getTestFramework() {
        return this.testFramework;
    }

    @Input
    @Option(option="insecure-protocol", description="How to handle insecure URLs used for Maven Repositories.")
    public Property<InsecureProtocolOption> getInsecureProtocol() {
        return this.insecureProtocol;
    }

    @Incubating
    @Input
    @Optional
    @Option(option="comments", description="Include clarifying comments in files.")
    public abstract Property<Boolean> getComments();

    @NotToBeReplacedByLazyProperty(because="Injected service")
    public ProjectLayoutSetupRegistry getProjectLayoutRegistry() {
        if (this.projectLayoutRegistry == null) {
            this.projectLayoutRegistry = (ProjectLayoutSetupRegistry)this.getServices().get(ProjectLayoutSetupRegistry.class);
        }
        return this.projectLayoutRegistry;
    }

    @TaskAction
    public void setupProjectLayout() {
        UserInputHandler inputHandler = this.getEffectiveInputHandler();
        if (this.shouldUseInitProjectSpec(inputHandler)) {
            this.doInitSpecProjectGeneration(inputHandler);
        } else {
            this.doStandardProjectGeneration(inputHandler);
        }
    }

    private boolean shouldUseInitProjectSpec(UserInputHandler inputHandler) {
        boolean templatesAvailable = !this.getBuildInitSpecRegistry().isEmpty();
        return templatesAvailable && (Boolean)inputHandler.askUser(uq -> uq.askBooleanQuestion("Additional project types were loaded.  Do you want to generate a project using a contributed project specification?", true)).get() != false;
    }

    private void doInitSpecProjectGeneration(UserInputHandler inputHandler) {
        BuildInitConfig config = (BuildInitConfig)inputHandler.askUser(this::selectAndConfigureSpec).get();
        BuildInitGenerator generator = this.createGenerator(config);
        boolean userInterrupted = inputHandler.interrupted();
        if (userInterrupted) {
            throw new BuildCancelledException();
        }
        this.getLogger().lifecycle("Generate '{}'", new Object[]{config.getBuildSpec().getDisplayName()});
        generator.generate(config, this.projectDir);
        this.generateWrapper();
    }

    private BuildInitConfig selectAndConfigureSpec(UserQuestions userQuestions) {
        BuildInitSpecRegistry registry = this.getBuildInitSpecRegistry();
        final BuildInitSpec spec = this.type == null ? (BuildInitSpec)userQuestions.choice("Select project type", (Collection)registry.getAllSpecs()).renderUsing(BuildInitSpec::getDisplayName).ask() : registry.getSpecByType(this.type);
        return new BuildInitConfig(){

            public @NonNull BuildInitSpec getBuildSpec() {
                return spec;
            }

            public @NonNull Map<BuildInitParameter<?>, Object> getArguments() {
                return Collections.emptyMap();
            }
        };
    }

    private BuildInitGenerator createGenerator(BuildInitConfig config) {
        Class generator = this.getBuildInitSpecRegistry().getGeneratorForSpec(config.getBuildSpec());
        return (BuildInitGenerator)this.getObjectFactory().newInstance(generator, new Object[0]);
    }

    private void doStandardProjectGeneration(UserInputHandler inputHandler) {
        GenerationSettings settings = (GenerationSettings)inputHandler.askUser(this::calculateGenerationSettings).get();
        boolean userInterrupted = inputHandler.interrupted();
        if (userInterrupted) {
            throw new BuildCancelledException();
        }
        settings.getInitializer().generate(settings.getSettings());
        this.generateWrapper();
        settings.getInitializer().getFurtherReading(settings.getSettings()).ifPresent(link -> this.getLogger().lifecycle(link));
    }

    private GenerationSettings calculateGenerationSettings(UserQuestions userQuestions) {
        this.validateBuildDirectory(userQuestions);
        ProjectLayoutSetupRegistry projectLayoutRegistry = this.getProjectLayoutRegistry();
        BuildInitializer initializer = this.getBuildInitializer(userQuestions, projectLayoutRegistry);
        JavaLanguageVersion javaLanguageVersion = this.getJavaLanguageVersion(userQuestions, initializer);
        String projectName = this.getEffectiveProjectName(userQuestions, initializer);
        ModularizationOption modularizationOption = this.getModularizationOption(userQuestions, initializer);
        BuildInitDsl dsl = this.getBuildInitDsl(userQuestions, initializer);
        BuildInitTestFramework testFramework = this.getBuildInitTestFramework(userQuestions, initializer, modularizationOption);
        String packageName = this.getEffectivePackageName(initializer);
        InitBuild.validatePackageName(packageName);
        boolean useIncubatingAPIs = this.shouldUseIncubatingAPIs(userQuestions);
        boolean generateComments = (Boolean)this.getComments().get();
        List<String> subprojectNames = initializer.getDefaultProjectNames();
        InitSettings initSettings = new InitSettings(projectName, useIncubatingAPIs, subprojectNames, modularizationOption, dsl, packageName, testFramework, (InsecureProtocolOption)((Object)this.insecureProtocol.get()), this.projectDir, javaLanguageVersion, generateComments);
        return new GenerationSettings(initializer, initSettings);
    }

    private void generateWrapper() {
        Directory projectDirectory = this.getLayout().getProjectDirectory();
        File unixScript = projectDirectory.file("gradlew").getAsFile();
        File jarFile = projectDirectory.file("gradle/wrapper/gradle-wrapper.jar").getAsFile();
        String jarFileRelativePath = InitBuild.getRelativePath(projectDirectory.getAsFile(), jarFile);
        File propertiesFile = WrapperGenerator.getPropertiesFile(jarFile);
        String distributionUrl = WrapperGenerator.getDistributionUrl(GradleVersion.current(), WrapperDefaults.DISTRIBUTION_TYPE);
        WrapperGenerator.generate(WrapperDefaults.ARCHIVE_BASE, "wrapper/dists", WrapperDefaults.DISTRIBUTION_BASE, "wrapper/dists", null, propertiesFile, jarFile, jarFileRelativePath, unixScript, WrapperGenerator.getBatchScript(unixScript), distributionUrl, true, 10000);
    }

    private static String getRelativePath(File baseDir, File targetFile) {
        return baseDir.toPath().relativize(targetFile.toPath()).toString();
    }

    private UserInputHandler getEffectiveInputHandler() {
        if (((Boolean)this.getUseDefaults().get()).booleanValue()) {
            return new NonInteractiveUserInputHandler();
        }
        return this.getUserInputHandler();
    }

    private void validateBuildDirectory(UserQuestions userQuestions) {
        if (!this.isPomConversion()) {
            boolean isNotEmptyDirectory;
            File projectDirFile = this.projectDir.getAsFile();
            File[] existingProjectFiles = projectDirFile.listFiles();
            boolean bl = isNotEmptyDirectory = existingProjectFiles != null && existingProjectFiles.length != 0;
            if (isNotEmptyDirectory) {
                boolean fileOverwriteAllowed = (Boolean)this.getAllowFileOverwrite().get();
                if (!fileOverwriteAllowed) {
                    fileOverwriteAllowed = userQuestions.askBooleanQuestion("Found existing files in the project directory: '" + projectDirFile + "'." + System.lineSeparator() + "Directory will be modified and existing files may be overwritten.  Continue?", false);
                }
                if (!fileOverwriteAllowed) {
                    this.abortBuildDueToExistingFiles(projectDirFile);
                }
            }
        }
    }

    private boolean isPomConversion() {
        return Objects.equals(this.getType(), "pom");
    }

    private void abortBuildDueToExistingFiles(File projectDirFile) {
        List<String> resolutions = Arrays.asList("Remove any existing files in the project directory and run the init task again.", "Enable the --overwrite option to allow existing files to be overwritten.");
        throw new BuildInitException("Aborting build initialization due to existing files in the project directory: '" + projectDirFile + "'.", resolutions);
    }

    private static void validatePackageName(String packageName) {
        if (!Strings.isNullOrEmpty((String)packageName) && !SourceVersion.isName(packageName)) {
            throw new GradleException("Package name: '" + packageName + "' is not valid - it may contain invalid characters or reserved words.");
        }
    }

    @VisibleForTesting
    @Nullable JavaLanguageVersion getJavaLanguageVersion(UserQuestions userQuestions, BuildInitializer initializer) {
        if (!initializer.supportsJavaTargets()) {
            return null;
        }
        String version = (String)this.javaVersion.getOrNull();
        if (Strings.isNullOrEmpty((String)version)) {
            return JavaLanguageVersion.of((int)userQuestions.askIntQuestion("Enter target Java version", 7, 21));
        }
        try {
            int parsedVersion = Integer.parseInt(version);
            if (parsedVersion < 7) {
                throw new GradleException("Target Java version: '" + version + "' is not a supported target version. It must be equal to or greater than " + 7);
            }
            return JavaLanguageVersion.of((int)parsedVersion);
        }
        catch (NumberFormatException e) {
            throw new GradleException("Invalid target Java version '" + version + "'. The version must be an integer.", (Throwable)e);
        }
    }

    private BuildInitDsl getBuildInitDsl(UserQuestions userQuestions, BuildInitializer initializer) {
        BuildInitDsl dsl;
        if (Strings.isNullOrEmpty((String)this.dsl)) {
            dsl = (BuildInitDsl)userQuestions.selectOption("Select build script DSL", initializer.getDsls(), (Object)initializer.getDefaultDsl());
        } else {
            dsl = BuildInitDsl.fromName(this.getDsl());
            if (!initializer.getDsls().contains(dsl)) {
                throw new GradleException("The requested DSL '" + this.getDsl() + "' is not supported for '" + initializer.getId() + "' build type");
            }
        }
        return dsl;
    }

    private ModularizationOption getModularizationOption(UserQuestions userQuestions, BuildInitializer initializer) {
        if (this.splitProject.isPresent()) {
            return (Boolean)this.splitProject.get() != false ? ModularizationOption.WITH_LIBRARY_PROJECTS : ModularizationOption.SINGLE_PROJECT;
        }
        return (ModularizationOption)((Object)userQuestions.choice("Select application structure", initializer.getModularizationOptions()).renderUsing(ModularizationOption::getDisplayName).ask());
    }

    private boolean shouldUseIncubatingAPIs(UserQuestions userQuestions) {
        if (this.useIncubatingAPIs.isPresent()) {
            return (Boolean)this.useIncubatingAPIs.get();
        }
        return userQuestions.askBooleanQuestion("Generate build using new APIs and behavior (some features may change in the next minor release)?", false);
    }

    private BuildInitTestFramework getBuildInitTestFramework(UserQuestions userQuestions, BuildInitializer initializer, ModularizationOption modularizationOption) {
        if (!Strings.isNullOrEmpty((String)this.testFramework)) {
            return initializer.getTestFrameworks(modularizationOption).stream().filter(candidate -> this.testFramework.equals(candidate.getId())).findFirst().orElseThrow(() -> this.createNotSupportedTestFrameWorkException(initializer, modularizationOption));
        }
        BuildInitTestFramework testFramework = initializer.getDefaultTestFramework(modularizationOption);
        return (BuildInitTestFramework)userQuestions.selectOption("Select test framework", initializer.getTestFrameworks(modularizationOption), (Object)testFramework);
    }

    private GradleException createNotSupportedTestFrameWorkException(BuildInitializer initDescriptor, ModularizationOption modularizationOption) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("The requested test framework '" + this.getTestFramework() + "' is not supported for '" + initDescriptor.getId() + "' build type. Supported frameworks");
        formatter.startChildren();
        for (BuildInitTestFramework framework : initDescriptor.getTestFrameworks(modularizationOption)) {
            formatter.node("'" + framework.getId() + "'");
        }
        formatter.endChildren();
        return new GradleException(formatter.toString());
    }

    @VisibleForTesting
    String getEffectiveProjectName(UserQuestions userQuestions, BuildInitializer initializer) {
        String projectName = this.projectName;
        if (initializer.supportsProjectName()) {
            if (Strings.isNullOrEmpty((String)projectName)) {
                return userQuestions.askQuestion("Project name", this.getProjectName());
            }
        } else if (!Strings.isNullOrEmpty((String)projectName)) {
            throw new GradleException("Project name is not supported for '" + initializer.getId() + "' build type.");
        }
        return projectName;
    }

    @VisibleForTesting
    String getEffectivePackageName(BuildInitializer initializer) {
        String packageName = this.packageName;
        if (initializer.supportsPackage()) {
            if (packageName == null) {
                return (String)this.getProviderFactory().gradleProperty(SOURCE_PACKAGE_PROPERTY).getOrElse((Object)SOURCE_PACKAGE_DEFAULT);
            }
        } else if (!Strings.isNullOrEmpty((String)packageName)) {
            throw new GradleException("Package name is not supported for '" + initializer.getId() + "' build type.");
        }
        return packageName;
    }

    private BuildInitializer getBuildInitializer(UserQuestions userQuestions, ProjectLayoutSetupRegistry projectLayoutRegistry) {
        if (!Strings.isNullOrEmpty((String)this.type)) {
            return projectLayoutRegistry.get(this.type);
        }
        BuildConverter converter = projectLayoutRegistry.getBuildConverter();
        if (converter.canApplyToCurrentDirectory(this.projectDir) && userQuestions.askBooleanQuestion("Found a " + converter.getSourceBuildDescription() + " build. Generate a Gradle build from this?", true)) {
            return converter;
        }
        return InitBuild.selectTypeOfBuild(userQuestions, projectLayoutRegistry);
    }

    private static BuildGenerator selectTypeOfBuild(UserQuestions userQuestions, ProjectLayoutSetupRegistry projectLayoutRegistry) {
        assert (projectLayoutRegistry.getDefaultComponentType() == projectLayoutRegistry.getComponentTypes().get(0));
        ComponentType componentType = (ComponentType)((Object)userQuestions.choice("Select type of build to generate", projectLayoutRegistry.getComponentTypes()).renderUsing(ComponentType::getDisplayName).defaultOption((Object)projectLayoutRegistry.getDefaultComponentType()).whenNotConnected((Object)projectLayoutRegistry.getDefault().getComponentType()).ask());
        List<BuildGenerator> generators = projectLayoutRegistry.getGeneratorsFor(componentType);
        if (generators.size() == 1) {
            return generators.get(0);
        }
        LinkedHashMap<Language, BuildGenerator> generatorsByLanguage = new LinkedHashMap<Language, BuildGenerator>();
        block0: for (Language language : Language.values()) {
            for (BuildGenerator generator : generators) {
                if (!generator.productionCodeUses(language)) continue;
                generatorsByLanguage.put(language, generator);
                continue block0;
            }
        }
        Language language = (Language)((Object)userQuestions.choice("Select implementation language", generatorsByLanguage.keySet()).ask());
        return (BuildGenerator)generatorsByLanguage.get((Object)language);
    }

    @Option(option="type", description="Set the type of project to generate.")
    public void setType(String type) {
        this.type = type;
    }

    @OptionValues(value={"type"})
    @ToBeReplacedByLazyProperty(comment="Not yet supported", issue="https://github.com/gradle/gradle/issues/29341")
    public List<String> getAvailableBuildTypes() {
        return this.getProjectLayoutRegistry().getAllTypes();
    }

    @Option(option="dsl", description="Set the build script DSL to be used in generated scripts.")
    public void setDsl(String dsl) {
        this.dsl = dsl;
    }

    @OptionValues(value={"dsl"})
    @ToBeReplacedByLazyProperty(comment="Not yet supported", issue="https://github.com/gradle/gradle/issues/29341")
    public List<String> getAvailableDSLs() {
        return BuildInitDsl.listSupported();
    }

    @Option(option="test-framework", description="Set the test framework to be used.")
    public void setTestFramework(@Nullable String testFramework) {
        this.testFramework = testFramework;
    }

    @OptionValues(value={"test-framework"})
    @ToBeReplacedByLazyProperty(comment="Not yet supported", issue="https://github.com/gradle/gradle/issues/29341")
    public List<String> getAvailableTestFrameworks() {
        return BuildInitTestFramework.listSupported();
    }

    @Option(option="project-name", description="Set the project name.")
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Option(option="package", description="Set the package for source files.")
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    void setProjectLayoutRegistry(ProjectLayoutSetupRegistry projectLayoutRegistry) {
        this.projectLayoutRegistry = projectLayoutRegistry;
    }

    private String detectType() {
        ProjectLayoutSetupRegistry projectLayoutRegistry = this.getProjectLayoutRegistry();
        BuildConverter buildConverter = projectLayoutRegistry.getBuildConverter();
        if (buildConverter.canApplyToCurrentDirectory(this.projectDir)) {
            return buildConverter.getId();
        }
        return projectLayoutRegistry.getDefault().getId();
    }

    @Inject
    protected abstract ProviderFactory getProviderFactory();

    @Inject
    protected abstract UserInputHandler getUserInputHandler();

    @Inject
    protected abstract ProjectLayout getLayout();

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Inject
    protected abstract BuildInitSpecRegistry getBuildInitSpecRegistry();
}

